/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.support;

import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.security.core.config.SecurityTokenConfig;
import com.jxdinfo.hussar.support.security.core.dto.LoginUserAuthorizationDTO;
import com.jxdinfo.hussar.support.security.core.properties.HussarReloadUserAuthorizationProperties;
import com.jxdinfo.hussar.support.security.core.session.SecuritySession;
import com.jxdinfo.hussar.support.security.core.session.TokenSession;
import com.jxdinfo.hussar.support.security.core.session.TokenSign;
import com.jxdinfo.hussar.support.security.core.stp.SecurityLogic;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserAuthorizationReloader {
    private static Logger logger = LoggerFactory.getLogger(AbstractUserAuthorizationReloader.class);
    @Resource
    private HussarReloadUserAuthorizationProperties properties;

    public void reload(String accessToken) {
        Long userId;
        UserDetails userDetails;
        if (!this.properties.getEnable().booleanValue()) {
            return;
        }
        if (HussarUtils.isNotEmpty((Object)accessToken) && HussarUtils.isNotEmpty((Object)(userDetails = HussarSecurityUtils.getLoginUserDetails(accessToken))) && HussarCacheUtil.containKey((String)"hussar_user_authorization_change", (Object)(userId = userDetails.getUserId()))) {
            ArrayList<String> affectedTokens = new ArrayList();
            try {
                affectedTokens = this.doReload(userId, userDetails);
            }
            catch (Exception e) {
                logger.error("\u6743\u9650\u4fe1\u606f\u53d8\u66f4\u540e\uff0c\u5237\u65b0\u5df2\u767b\u5f55\u7528\u6237\u7f13\u5b58\u5931\u8d25, userId = {}", (Object)userId, (Object)e);
            }
            try {
                this.callback(userId, affectedTokens);
            }
            catch (Exception e) {
                logger.error("\u6743\u9650\u4fe1\u606f\u53d8\u66f4\uff0c\u5237\u65b0\u767b\u5f55\u7528\u6237\u7f13\u5b58\u540e\u6267\u884c\u56de\u8c03\u65b9\u6cd5\u5931\u8d25, userId = {}", (Object)userId, (Object)e);
            }
        }
    }

    private List<String> doReload(Long userId, UserDetails curUserDetails) {
        LoginUserAuthorizationDTO userAuthorization = this.generateUserLatestAuthorization(userId);
        if (HussarUtils.isEmpty((Object)userAuthorization)) {
            return new ArrayList<String>();
        }
        List newRoleIds = userAuthorization.getRoleIds();
        List newPermissions = userAuthorization.getPermissions();
        Map addExtendMap = userAuthorization.getExtendMap();
        if (HussarUtils.equals((Object)newRoleIds, (Object)curUserDetails.getExtendUserMap("rolesList")) && HussarUtils.equals((Object)newPermissions, (Object)curUserDetails.getExtendUserMap("permissions")) && HussarUtils.isEmpty((Object)addExtendMap)) {
            return new ArrayList<String>();
        }
        List<String> loginTickets = this.getLoginTickets(userId);
        ArrayList<String> affectedTokens = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(loginTickets)) {
            for (String loginTicket : loginTickets) {
                TokenSession tokenSession = SecurityUtil.getTokenSession((String)loginTicket);
                if (HussarUtils.isEmpty((Object)tokenSession)) {
                    logger.warn("\u901a\u8fc7loginTicket = {} \u83b7\u53d6tokenSession\u4e3a\u7a7a", (Object)loginTicket);
                    continue;
                }
                UserDetails userDetails = tokenSession.getUserDetails();
                userDetails.addExtendUserMap("rolesList", (Object)userAuthorization.getRoleIds());
                userDetails.addExtendUserMap("permissions", (Object)userAuthorization.getPermissions());
                if (HussarUtils.isNotEmpty((Object)addExtendMap)) {
                    addExtendMap.entrySet().forEach(entry -> userDetails.addExtendUserMap((String)entry.getKey(), entry.getValue()));
                }
                tokenSession.setUserDetails(userDetails);
                SecurityUtil.updateTokenSession((String)loginTicket, (TokenSession)tokenSession);
                affectedTokens.add(userDetails.getAccessToken());
            }
        }
        HussarCacheUtil.evict((String)"hussar_user_authorization_change", (Object)userId);
        HussarCacheUtil.evictKeysLeftLike((String)((SecurityTokenConfig)SpringContextUtil.getBean(SecurityTokenConfig.class)).getTokenName(), (String)SecurityLogic.splicingUserPermissions((String)"*", (Long)userId));
        return affectedTokens;
    }

    public abstract LoginUserAuthorizationDTO generateUserLatestAuthorization(Long var1);

    public void callback(Long userId, List<String> tokens) {
    }

    private List<String> getLoginTickets(Long userId) {
        ArrayList<String> loginTickets = new ArrayList<String>();
        SecuritySession session = SecurityUtil.getSessionByLoginId((Object)userId);
        if (session != null) {
            List tokenSignList = session.getTokenSignList();
            for (TokenSign tokenSign : tokenSignList) {
                loginTickets.add(tokenSign.getValue());
            }
        }
        return loginTickets;
    }
}

