/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.support;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.security.core.properties.HussarReloadUserAuthorizationProperties;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserAuthorizationChangeReporter {
    @Resource
    private HussarReloadUserAuthorizationProperties properties;
    private static final Logger logger = LoggerFactory.getLogger(AbstractUserAuthorizationChangeReporter.class);

    public void report(Object ... args) {
        if (!this.properties.getEnable().booleanValue()) {
            return;
        }
        try {
            List<Long> userIds = this.getUserIds(args);
            if (HussarUtils.isNotEmpty(userIds)) {
                userIds.stream().filter(userId -> HussarUtils.isNotEmpty((Object)SecurityUtil.getSessionByLoginId((Object)userId))).forEach(userId -> HussarCacheUtil.put((String)"hussar_user_authorization_change", (Object)userId, (Object)this.properties.getAffectedUserValidTime()));
            }
        }
        catch (Exception e) {
            logger.error("\u6743\u9650\u4fe1\u606f\u53d8\u66f4\u540e\uff0c\u8bb0\u5f55\u53d7\u5f71\u54cd\u7528\u6237token\u503c\u5931\u8d25", (Throwable)e);
        }
    }

    public abstract List<Long> getUserIds(Object ... var1);
}

