/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.interceptors;

import com.jxdinfo.hussar.support.cache.support.redis.HussarRedisTemplate;
import com.jxdinfo.hussar.support.security.core.SecurityManager;
import com.jxdinfo.hussar.support.security.core.context.SecurityTokenContext;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityStorage;
import com.jxdinfo.hussar.support.security.core.prefetch.SecurityDaoPrefetchCache;
import com.jxdinfo.hussar.support.security.core.router.SecurityRouter;
import com.jxdinfo.hussar.support.security.core.stp.SecurityLogic;
import com.jxdinfo.hussar.support.security.core.stp.SecuritySpecialUtil;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.defer.SecurityDaoDeferredCommand;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.defer.SecurityDaoDeferredQueue;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.prefetch.SecurityDaoPrefetchCacheImpl;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.prefetch.SecurityDaoPrefetchTask;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.properties.SecurityCacheProperties;
import com.jxdinfo.hussar.support.security.plugin.oauth2.handler.AbstractOauth2HandlerInterceptor;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Template;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityRequestForServlet;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityResponseForServlet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class SecurityDaoPrefetchInterceptor
extends AbstractOauth2HandlerInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SecurityDaoPrefetchInterceptor.class);
    private final SecurityTokenContext tokenContext;
    private final SecurityCacheProperties cacheProperties;
    private final SecurityOAuth2Template oauth2Template;
    private HussarRedisTemplate<Object, Object> redisTemplate;

    public SecurityDaoPrefetchInterceptor(SecurityTokenContext tokenContext, SecurityCacheProperties cacheProperties, SecurityOAuth2Template oauth2Template) {
        this.tokenContext = tokenContext;
        this.cacheProperties = cacheProperties;
        this.oauth2Template = oauth2Template;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!Boolean.TRUE.equals(this.cacheProperties.getDaoPrefetch())) {
            return true;
        }
        if (this.redisTemplate == null) {
            return true;
        }
        SecurityRequestForServlet securityRequest = new SecurityRequestForServlet(request);
        SecurityResponseForServlet securityResponse = new SecurityResponseForServlet(response);
        if (this.isAuthEndpoint((SecurityRequest)securityRequest)) {
            SecurityStorage storage = this.tokenContext.getStorage();
            SecurityDaoPrefetchCacheImpl prefetchCache = new SecurityDaoPrefetchCacheImpl();
            SecurityDaoDeferredQueue deferredQueue = new SecurityDaoDeferredQueue();
            storage.set("dao_prefetch_cache", (Object)prefetchCache);
            storage.set("dao_deferred_queue", (Object)deferredQueue);
            this.prefetchForAuthEndpoint((RedisTemplate<Object, Object>)this.redisTemplate, (SecurityDaoPrefetchCache)prefetchCache, (SecurityRequest)securityRequest, (SecurityResponse)securityResponse);
            return true;
        }
        boolean prehandler = this.isPrehandler((SecurityRequest)securityRequest, (SecurityResponse)securityResponse, handler);
        if (prehandler) {
            return true;
        }
        SecurityStorage storage = this.tokenContext.getStorage();
        SecurityDaoPrefetchCacheImpl prefetchCache = new SecurityDaoPrefetchCacheImpl();
        SecurityDaoDeferredQueue deferredQueue = new SecurityDaoDeferredQueue();
        storage.set("dao_prefetch_cache", (Object)prefetchCache);
        storage.set("dao_deferred_queue", (Object)deferredQueue);
        this.prefetchForApiAuth((RedisTemplate<Object, Object>)this.redisTemplate, (SecurityDaoPrefetchCache)prefetchCache, (SecurityRequest)securityRequest, (SecurityResponse)securityResponse);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        SecurityStorage storage = this.tokenContext.getStorage();
        SecurityDaoDeferredQueue queue = null;
        Object rawDeferredQueue = storage.get("dao_deferred_queue");
        if (rawDeferredQueue instanceof SecurityDaoDeferredQueue) {
            queue = (SecurityDaoDeferredQueue)rawDeferredQueue;
        }
        if (queue != null && !queue.isEmpty()) {
            this.executeDeferredCommands(queue.drain());
        }
        storage.delete("dao_deferred_queue");
        storage.delete("dao_prefetch_cache");
    }

    private boolean isAuthEndpoint(SecurityRequest securityRequest) {
        return SecurityRouter.isMatch((String)"/oauth2/*", (String)securityRequest.getRequestPath());
    }

    private void prefetchForAuthEndpoint(RedisTemplate<Object, Object> redisTemplate, SecurityDaoPrefetchCache prefetchCache, SecurityRequest securityRequest, SecurityResponse securityResponse) {
        logger.debug("{} \u5f00\u59cb\u8ba4\u8bc1\u7aef\u70b9\u7f13\u5b58\u9884\u52a0\u8f7d", (Object)securityRequest.getRequestPath());
        SecurityLogic logic = SecurityManager.getStpLogic((String)"login");
        String noTokenSessionKey = logic.splicingKeyTokenSession("no-token");
        String nullTokenSessionKey = SecuritySpecialUtil.securityLogic.splicingKeyTokenSession("null");
        prefetchCache.set(noTokenSessionKey, null);
        prefetchCache.set(nullTokenSessionKey, null);
        logger.debug("{} \u8ba4\u8bc1\u7aef\u70b9\u7f13\u5b58\u9884\u52a0\u8f7d\u5b8c\u6210: {}", (Object)securityRequest.getRequestPath(), (Object)prefetchCache);
    }

    private void prefetchForApiAuth(RedisTemplate<Object, Object> redisTemplate, SecurityDaoPrefetchCache prefetchCache, SecurityRequest securityRequest, SecurityResponse securityResponse) {
        logger.debug("\u5f00\u59cb\u8ba4\u8bc1\u7f13\u5b58\u9884\u52a0\u8f7d");
        String oauth2Token = this.getOauth2Token(securityRequest);
        String tenantCode = securityRequest.getHeader(SecurityOAuth2Constants.Param.tenant_code);
        TokenModel tokenModel = this.getTokenModel(oauth2Token, tenantCode);
        if (tokenModel instanceof AccessTokenModel) {
            this.prefetchByAccessTokenModel(redisTemplate, prefetchCache, (AccessTokenModel)tokenModel);
        } else {
            prefetchCache.set(this.oauth2Template.splicingAccessTokenSaveKey(oauth2Token), null);
        }
        logger.debug("\u8ba4\u8bc1\u7f13\u5b58\u9884\u52a0\u8f7d\u5b8c\u6210: {}", (Object)prefetchCache);
    }

    private void prefetchByAccessTokenModel(RedisTemplate<Object, Object> redisTemplate, SecurityDaoPrefetchCache prefetchCache, AccessTokenModel tokenModel) {
        SecurityLogic logic = SecurityManager.getStpLogic((String)tokenModel.loginType);
        String accessTokenKey = this.oauth2Template.splicingAccessTokenSaveKey(tokenModel.accessToken);
        prefetchCache.set(accessTokenKey, (Object)tokenModel);
        ArrayList<SecurityDaoPrefetchTask> tasks = new ArrayList<SecurityDaoPrefetchTask>();
        tasks.add(SecurityDaoPrefetchTask.valueOf((Object)logic.splicingKeyTokenValue(tokenModel.loginTicket)));
        tasks.add(SecurityDaoPrefetchTask.valueOf((Object)logic.splicingKeyTokenSession(tokenModel.loginTicket)));
        tasks.add(SecurityDaoPrefetchTask.valueAndTimeoutOf((Object)logic.splicingKeySession(tokenModel.loginId)));
        tasks.add(SecurityDaoPrefetchTask.valueOf((Object)this.oauth2Template.splicingRefreshTokenSaveKey(tokenModel.refreshToken)));
        tasks.add(SecurityDaoPrefetchTask.valueOf((Object)this.oauth2Template.splicingAccessTokenIndexKey(tokenModel.clientId, tokenModel.loginId)));
        tasks.add(SecurityDaoPrefetchTask.valueOf((Object)this.oauth2Template.splicingRefreshTokenIndexKey(tokenModel.clientId, tokenModel.loginId)));
        SecurityDaoPrefetchTask.prefetchAll(redisTemplate, (String)this.cacheProperties.getTokenName(), (SecurityDaoPrefetchCache)prefetchCache, tasks);
    }

    private void executeDeferredCommands(List<SecurityDaoDeferredCommand> commands) {
        if (this.redisTemplate == null) {
            logger.warn("\u7f3a\u5c11 redisTemplate \u5904\u7406\u5ef6\u8fdf\u6267\u884c");
            return;
        }
        logger.debug("\u5f00\u59cb\u9274\u6743\u5904\u7406\u5ef6\u8fdf\u6267\u884c: {}", commands);
        StringRedisSerializer keySerializer = StringRedisSerializer.UTF_8;
        RedisSerializer valueSerializer = this.redisTemplate.getValueSerializer();
        List serializedCommands = commands.stream().map(arg_0 -> SecurityDaoPrefetchInterceptor.lambda$executeDeferredCommands$0((RedisSerializer)keySerializer, valueSerializer, arg_0)).collect(Collectors.toList());
        this.redisTemplate.executePipelined(connection -> {
            for (SecurityDaoDeferredCommand command : serializedCommands) {
                command.execute(connection);
            }
            return null;
        });
        logger.debug("\u9274\u6743\u5904\u7406\u5ef6\u8fdf\u6267\u884c\u5b8c\u6210: {}", commands);
    }

    public boolean extendPreHandler(SecurityRequest securityRequest, SecurityResponse securityResponse, Object handler) {
        return false;
    }

    public void setRedisTemplate(HussarRedisTemplate<Object, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    private static /* synthetic */ SecurityDaoDeferredCommand lambda$executeDeferredCommands$0(RedisSerializer keySerializer, RedisSerializer valueSerializer, SecurityDaoDeferredCommand command) {
        return command.serialize(keySerializer, valueSerializer);
    }
}

