/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.support.utils;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.context.SecurityHolder;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.session.TokenSession;
import com.jxdinfo.hussar.support.security.core.stp.SecuritySpecialUtil;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SpecialTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HussarSecurityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarSecurityUtils.class);

    public static UserDetails getLoginUserDetails(String accessToken) {
        String loginToken;
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return null;
        }
        TokenModel tokenModel = SecurityOAuth2Util.getTokenModelByAcessToken((String)accessToken, null);
        if (HussarUtils.isEmpty((Object)tokenModel)) {
            return null;
        }
        TokenSession tokenSession = null;
        if (tokenModel instanceof AccessTokenModel) {
            AccessTokenModel accessTokenModel = (AccessTokenModel)tokenModel;
            if (HussarUtils.isNotEmpty((Object)accessTokenModel.loginTicket)) {
                loginToken = accessTokenModel.loginTicket;
                tokenSession = SecurityUtil.getTokenSession((String)loginToken);
            }
        }
        if (tokenModel instanceof SpecialTokenModel) {
            SpecialTokenModel specialTokenModel = (SpecialTokenModel)tokenModel;
            if (HussarUtils.isNotEmpty((Object)specialTokenModel.loginTicket)) {
                loginToken = specialTokenModel.loginTicket;
                tokenSession = SecuritySpecialUtil.getTokenSession((String)loginToken);
            }
        }
        if (HussarUtils.isEmpty(tokenSession)) {
            return null;
        }
        UserDetails userDetails = tokenSession.getUserDetails();
        return userDetails;
    }

    public static UserDetails getLoginUserDetails() {
        SecurityRequest securityRequest;
        SecurityOAuth2Config securityOAuth2Config;
        try {
            securityOAuth2Config = SecurityOAuth2Manager.getConfig();
            securityRequest = SecurityHolder.getRequest();
        }
        catch (Exception ex) {
            LOGGER.warn("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            return null;
        }
        if (HussarUtils.isEmpty((Object)securityRequest.getHeader(securityOAuth2Config.getFeignKey()))) {
            return HussarSecurityUtils.getLoginUserDetailsOrigin();
        }
        String accessToken = securityRequest.getHeader(SecurityOAuth2Manager.getConfig().getHeaderTokenKey());
        return HussarSecurityUtils.getLoginUserDetails(accessToken);
    }

    private static UserDetails getLoginUserDetailsOrigin() {
        try {
            String tokenValue = SecurityUtil.getTokenValue();
            if (HussarUtils.isEmpty((Object)tokenValue) && HussarUtils.isEmpty((Object)(tokenValue = SecuritySpecialUtil.getTokenValue()))) {
                LOGGER.debug("\u83b7\u53d6token\u4e3a\u7a7a");
                return null;
            }
            TokenSession session = SecurityUtil.getTokenSession((String)tokenValue);
            if (HussarUtils.isEmpty((Object)session) && HussarUtils.isEmpty((Object)(session = SecuritySpecialUtil.getTokenSession()))) {
                LOGGER.debug("\u83b7\u53d6TokenSession\u4e3a\u7a7a");
                return null;
            }
            UserDetails userDetails = session.getUserDetails();
            if (HussarUtils.isEmpty((Object)userDetails)) {
                LOGGER.debug("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
                return null;
            }
            return userDetails;
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static <T> T getSessionExtend(String key) {
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isEmpty((Object)userDetails)) {
            userDetails = new UserDetails();
        }
        if (HussarUtils.isEmpty((Object)key)) {
            return null;
        }
        return (T)userDetails.getExtendUserMap(key);
    }

    public static void updateUserDetails(UserDetails userDetails) {
        String tokenValue = SecurityUtil.getTokenValue();
        if (HussarUtils.isNotEmpty((Object)tokenValue)) {
            SecurityUtil.getTokenSession((String)tokenValue).addUserDetailToTokenSession(userDetails, tokenValue);
        }
    }

    public static void putSessionExtend(String key, Object value) {
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isEmpty((Object)userDetails)) {
            userDetails = new UserDetails();
        }
        if (HussarUtils.isEmpty((Object)key) || HussarUtils.isEmpty((Object)value)) {
            return;
        }
        userDetails.addExtendUserMap(key, value);
        String tokenValue = SecurityUtil.getTokenValue();
        if (HussarUtils.isNotEmpty((Object)tokenValue)) {
            SecurityUtil.getTokenSession((String)tokenValue).addUserDetailToTokenSession(userDetails, tokenValue);
            return;
        }
        tokenValue = SecuritySpecialUtil.getTokenValue();
        if (HussarUtils.isNotEmpty((Object)tokenValue)) {
            SecuritySpecialUtil.getTokenSession((String)tokenValue).addUserDetailToTokenSession(userDetails, tokenValue);
        }
    }

    public static String getSecuritySessionId() {
        String tokenValue = SecurityUtil.getTokenValue();
        if (HussarUtils.isNotEmpty((Object)tokenValue)) {
            return SecurityUtil.getSession().getId();
        }
        tokenValue = SecuritySpecialUtil.getTokenValue();
        if (HussarUtils.isNotEmpty((Object)tokenValue)) {
            return SecuritySpecialUtil.getSession().getId();
        }
        return null;
    }

    public static boolean expireByToken(String accessToken) {
        return HussarSecurityUtils.expireByToken(accessToken, null);
    }

    public static boolean expireByToken(String accessToken, String tenantCode) {
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return true;
        }
        TokenModel tokenModel = SecurityOAuth2Util.getTokenModelByAcessToken((String)accessToken, (String)tenantCode);
        return HussarUtils.isEmpty((Object)tokenModel);
    }

    public static boolean revokeAccessToken(String accessToken) {
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return false;
        }
        TokenModel tokenModel = SecurityOAuth2Util.getTokenModelByAcessToken((String)accessToken, null);
        if (HussarUtils.isEmpty((Object)tokenModel)) {
            return false;
        }
        if (tokenModel instanceof AccessTokenModel) {
            SecurityOAuth2Util.revokeAccessToken((String)accessToken);
        } else if (tokenModel instanceof SpecialTokenModel) {
            SecurityOAuth2Util.revokeSpecialClientToken((String)accessToken);
        } else {
            return false;
        }
        return true;
    }

    public static boolean revokeClientToken(String clientId, String tenantCode) {
        if (HussarUtils.isEmpty((Object)clientId)) {
            return false;
        }
        SecurityOAuth2Util.revokeClientToken((String)clientId, (String)tenantCode);
        return true;
    }

    public static void updateClientPermissions(String clientId, String tenantCode, List<String> permissions) {
        if (HussarUtils.isEmpty((Object)clientId)) {
            LOGGER.error("\u66f4\u65b0\u5ba2\u6237\u7aef\u5e94\u7528\u6743\u9650\u5931\u8d25\uff0cclientId\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        SecurityOAuth2Util.updateClientPermissions((String)clientId, (String)tenantCode, permissions);
    }

    public static boolean changeTenant(Long tenantId) {
        if (HussarUtils.isEmpty((Object)tenantId)) {
            LOGGER.debug("\u5207\u6362\u7684\u79df\u6237id\u4e3a\u7a7a");
            return Boolean.FALSE;
        }
        boolean isSpecial = false;
        try {
            TokenSession session;
            String tokenValue = SecurityUtil.getTokenValue();
            if (HussarUtils.isEmpty((Object)tokenValue)) {
                tokenValue = SecuritySpecialUtil.getTokenValue();
                if (HussarUtils.isEmpty((Object)tokenValue)) {
                    LOGGER.debug("\u83b7\u53d6token\u4e3a\u7a7a");
                    return Boolean.FALSE;
                }
                isSpecial = true;
            }
            if (HussarUtils.isEmpty((Object)(session = SecurityUtil.getTokenSession((String)tokenValue))) && HussarUtils.isEmpty((Object)(session = SecuritySpecialUtil.getTokenSession((String)tokenValue)))) {
                LOGGER.debug("\u83b7\u53d6TokenSession\u4e3a\u7a7a");
                return Boolean.FALSE;
            }
            UserDetails userDetails = session.getUserDetails();
            if (HussarUtils.isEmpty((Object)userDetails)) {
                LOGGER.debug("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
                return Boolean.FALSE;
            }
            userDetails.setTenantId(tenantId);
            if (isSpecial) {
                SecuritySpecialUtil.updateTokenSession((String)tokenValue, (TokenSession)session);
            } else {
                SecurityUtil.updateTokenSession((String)tokenValue, (TokenSession)session);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static boolean changeTenant(String accessToken, Long tenantId) {
        if (HussarUtils.isEmpty((Object)tenantId)) {
            LOGGER.debug("\u5207\u6362\u7684\u79df\u6237id\u4e3a\u7a7a");
            return Boolean.FALSE;
        }
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return Boolean.FALSE;
        }
        TokenModel tokenModel = SecurityOAuth2Util.getTokenModelByAcessToken((String)accessToken, null);
        if (HussarUtils.isEmpty((Object)tokenModel)) {
            return Boolean.FALSE;
        }
        if (tokenModel instanceof AccessTokenModel) {
            AccessTokenModel accessTokenModel = (AccessTokenModel)tokenModel;
            if (HussarUtils.isNotEmpty((Object)accessTokenModel.loginTicket)) {
                String loginToken = accessTokenModel.loginTicket;
                TokenSession tokenSession = SecurityUtil.getTokenSession((String)loginToken);
                UserDetails userDetails = tokenSession.getUserDetails();
                userDetails.setTenantId(tenantId);
                SecurityUtil.updateTokenSession((String)loginToken, (TokenSession)tokenSession);
                return Boolean.TRUE;
            }
        }
        if (tokenModel instanceof SpecialTokenModel) {
            SpecialTokenModel specialTokenModel = (SpecialTokenModel)tokenModel;
            if (HussarUtils.isNotEmpty((Object)specialTokenModel.loginTicket)) {
                String loginToken = specialTokenModel.loginTicket;
                TokenSession tokenSession = SecuritySpecialUtil.getTokenSession((String)loginToken);
                UserDetails userDetails = tokenSession.getUserDetails();
                userDetails.setTenantId(tenantId);
                SecuritySpecialUtil.updateTokenSession((String)loginToken, (TokenSession)tokenSession);
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static List<String> getPermissions() {
        SecurityRequest securityRequest;
        SecurityOAuth2Config securityOAuth2Config;
        try {
            securityOAuth2Config = SecurityOAuth2Manager.getConfig();
            securityRequest = SecurityHolder.getRequest();
        }
        catch (Exception ex) {
            LOGGER.warn("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            return Lists.newArrayListWithCapacity((int)0);
        }
        if (HussarUtils.isEmpty((Object)securityRequest.getHeader(securityOAuth2Config.getFeignKey()))) {
            String tokenValue = SecurityUtil.getTokenValue();
            if (HussarUtils.isEmpty((Object)tokenValue)) {
                tokenValue = SecuritySpecialUtil.getTokenValue();
            }
            if (HussarUtils.isNotBlank((CharSequence)tokenValue)) {
                return HussarSecurityUtils.getPermissionsByLoginTicket(tokenValue);
            }
        }
        String accessToken = securityRequest.getHeader(securityOAuth2Config.getHeaderTokenKey());
        return HussarSecurityUtils.getPermissions(accessToken);
    }

    public static List<String> getPermissions(String accessToken) {
        if (HussarUtils.isBlank((CharSequence)accessToken)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        String loginTicket = HussarSecurityUtils.getLoginTicket(accessToken);
        return HussarSecurityUtils.getPermissionsByLoginTicket(loginTicket);
    }

    private static String getLoginTicket(String accessToken) {
        TokenModel tokenModel = SecurityOAuth2Util.getTokenModelByAcessToken((String)accessToken, null);
        if (HussarUtils.isEmpty((Object)tokenModel)) {
            return "";
        }
        String loginTicket = null;
        if (tokenModel instanceof AccessTokenModel) {
            loginTicket = ((AccessTokenModel)tokenModel).loginTicket;
        } else if (tokenModel instanceof SpecialTokenModel) {
            loginTicket = ((SpecialTokenModel)tokenModel).loginTicket;
        }
        return loginTicket;
    }

    private static List<String> getPermissionsByLoginTicket(String loginTicket) {
        if (HussarUtils.isBlank((CharSequence)loginTicket)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        Set permissionSet = SecurityUtil.getPermissions((String)loginTicket);
        if (HussarUtils.isEmpty((Object)permissionSet)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)permissionSet.size());
        for (Object permission : permissionSet) {
            result.add(permission.toString());
        }
        return result;
    }
}

