/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.config;

import com.jxdinfo.hussar.platform.core.support.service.AuthSecurityClientModelDetailService;
import com.jxdinfo.hussar.platform.core.support.service.AuthSecurityUserDetailService;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.properties.HussarReloadUserAuthorizationProperties;
import com.jxdinfo.hussar.support.security.integration.authentication.filter.SecurityOAuth2ServletFilter;
import com.jxdinfo.hussar.support.security.integration.authentication.interceptors.SecurityIsoloateInternetInterceptor;
import com.jxdinfo.hussar.support.security.integration.authentication.interceptors.SecurityOAuth2Interceptor;
import com.jxdinfo.hussar.support.security.integration.authentication.support.service.DefaultAuthSecurityClientModelDetailService;
import com.jxdinfo.hussar.support.security.integration.authentication.support.service.DefaultAuthSecurityUserDetailService;
import com.jxdinfo.hussar.support.security.integration.authentication.support.service.DefaultGetLoginUserService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityInterceptorCustomizers;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityOAuth2InterceptorCustomizers;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.DefaultHussarSecurityOauthListener;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.HussarSecurityOauthListener;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(prefix="hussar.security", name={"enable"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={HussarReloadUserAuthorizationProperties.class})
public class AuthenticationSecurityInterceptorConfigure
implements WebMvcConfigurer {
    @Autowired
    private Optional<List<HussarSecurityInterceptorCustomizers>> hussarSecurityInterceptorCustomizers;
    @Autowired
    private Optional<List<HussarSecurityOAuth2InterceptorCustomizers>> hussarSecurityOAuth2InterceptorCustomizers;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new SecurityIsoloateInternetInterceptor()).addPathPatterns(new String[]{"/**"});
        this.customizeHussarSecurityInterceptorCustomizers(registry);
        registry.addInterceptor((HandlerInterceptor)new SecurityOAuth2Interceptor(this.hussarSecurityOAuth2InterceptorCustomizers)).addPathPatterns(new String[]{"/**"});
    }

    @Bean
    public SecurityOAuth2ServletFilter securityOAuth2ServletFilter() {
        return new SecurityOAuth2ServletFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public GetLoginUserService defaultGetLoginUserService() {
        return new DefaultGetLoginUserService();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthSecurityUserDetailService defaultAuthSecurityUserDetailService() {
        return new DefaultAuthSecurityUserDetailService();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthSecurityClientModelDetailService defaultAuthSecurityClientModelDetailService() {
        return new DefaultAuthSecurityClientModelDetailService();
    }

    @Bean
    @ConditionalOnMissingBean
    public HussarSecurityOauthListener defaultHussarSecurityOauthListener() {
        return new DefaultHussarSecurityOauthListener();
    }

    protected void customizeHussarSecurityInterceptorCustomizers(InterceptorRegistry registry) {
        List<Object> securityInterceptorCustomizers;
        if (this.hussarSecurityInterceptorCustomizers.isPresent() && HussarUtils.isNotEmpty(securityInterceptorCustomizers = this.hussarSecurityInterceptorCustomizers.get())) {
            securityInterceptorCustomizers = securityInterceptorCustomizers.stream().sorted(Comparator.comparing(HussarSecurityInterceptorCustomizers::order)).collect(Collectors.toList());
            securityInterceptorCustomizers.forEach(c -> c.customize(registry));
        }
    }
}

