/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.support;

import com.jxdinfo.hussar.platform.core.support.service.AuthSecurityClientModelDetailService;
import com.jxdinfo.hussar.platform.core.support.service.dto.ClientModelDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.apimanager.core.support.model.ScopePermissionModel;
import com.jxdinfo.hussar.support.apimanager.core.util.ApiManagerUtil;
import com.jxdinfo.hussar.support.security.core.SecurityManager;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.router.SecurityRouter;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.core.strategy.SecurityStrategy;
import com.jxdinfo.hussar.support.security.core.util.SecurityFoxUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.constants.SecurityConstants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Template;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.ClientTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.PastAccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.PastClientTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SecurityClientModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SpecialTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityResponseForServlet;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
@ConditionalOnProperty(prefix="hussar.security", name={"enable"}, havingValue="true", matchIfMissing=true)
public class HussarSecurityOAuth2Template
extends SecurityOAuth2Template {
    @Autowired
    private AuthSecurityClientModelDetailService authSecurityClientModelDetailService;

    public SecurityClientModel getClientModel(String clientId) {
        return this.getClientModel(clientId, null);
    }

    public SecurityClientModel getClientModel(String clientId, String tenantCode) {
        SecurityClientModel securityClientModel = new SecurityClientModel();
        ClientModelDetails clientModelDetails = this.authSecurityClientModelDetailService.loadClientModelByClientId(clientId, null, tenantCode);
        HussarUtils.copy((Object)clientModelDetails, (Object)securityClientModel);
        return securityClientModel;
    }

    public String getOpenid(String clientId, Object loginId) {
        return "gr_SwoIN0MC1ewxHX_vfCW3BothWDZMMtx__";
    }

    public AccessTokenModel checkAccessToken(String accessToken) {
        AccessTokenModel at = this.getAccessToken(accessToken);
        SecurityOAuth2Exception.throwBy((at == null ? 1 : 0) != 0, (String)("\u65e0\u6548access_token\uff1a" + accessToken));
        SecurityOAuth2Exception.throwBy((at.getExpiresIn() <= 0L ? 1 : 0) != 0, (String)("\u65e0\u6548\u7684access_token\uff1a" + accessToken + "\u5931\u6548"));
        SecurityClientModel securityClientModel = this.getClientModel(at.clientId);
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)securityClientModel), (String)("\u65e0\u6548accesss_token:" + accessToken + "\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728"));
        return at;
    }

    public boolean checkOauthToken(TokenModel tokenModel, SecurityRequest securityRequest, SecurityResponse response, Object handler) {
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)tokenModel), (String)"\u8bf7\u6c42\u5931\u8d25\uff0ctoken\u65e0\u6548");
        if (tokenModel instanceof AccessTokenModel) {
            AccessTokenModel accessTokenModel = (AccessTokenModel)tokenModel;
            this.validateAccessToken(accessTokenModel, securityRequest, response, handler);
        } else if (tokenModel instanceof PastAccessTokenModel) {
            PastAccessTokenModel pastAccessTokenModel = (PastAccessTokenModel)tokenModel;
            this.vaildatePastAccessToken(pastAccessTokenModel, handler);
        } else if (tokenModel instanceof PastClientTokenModel) {
            PastClientTokenModel pastClientTokenModel = (PastClientTokenModel)tokenModel;
            this.validatePastClientToken(pastClientTokenModel, securityRequest, response);
        } else if (tokenModel instanceof ClientTokenModel) {
            ClientTokenModel clientTokenModel = (ClientTokenModel)tokenModel;
            this.validateClientToken(clientTokenModel, securityRequest);
        } else if (tokenModel instanceof SpecialTokenModel) {
            SpecialTokenModel specialTokenModel = (SpecialTokenModel)tokenModel;
            this.validateSpecialClientToken(specialTokenModel, securityRequest, handler);
        } else {
            SecurityOAuth2Exception.throwBy((boolean)true, (String)"\u8bf7\u6c42\u5931\u8d25,tokenModel\u8f6c\u5316\u5931\u8d25");
        }
        return true;
    }

    public void checkClientScope(String scope, SecurityClientModel securityClientModel) {
        Object[] clientScope = securityClientModel.getContractScope();
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object[])clientScope), (String)("\u8ba4\u8bc1\u5931\u8d25\uff0cclientId=[" + securityClientModel.getClientId() + "]\uff0c\u672a\u8bbe\u7f6e\u6743\u9650\u7c7b\u578bscope"));
        List scopes = SecurityFoxUtil.convertStringToList((String)scope);
        List<Object> clientScopes = Arrays.asList(clientScope);
        scopes.forEach(s -> SecurityOAuth2Exception.throwBy((!clientScopes.contains(s) ? 1 : 0) != 0, (String)("\u8ba4\u8bc1\u5931\u8d25\uff0cclientId=[" + securityClientModel.getClientId() + "],\u4e0d\u5b58\u5728scope=[" + s + "]")));
    }

    private void validatePastOrAccessToken(TokenModel tokenModel, SecurityRequest securityRequest, SecurityResponse response, Object handler) {
        if (tokenModel instanceof AccessTokenModel) {
            AccessTokenModel accessTokenModel = (AccessTokenModel)tokenModel;
            this.validateAccessToken(accessTokenModel, securityRequest, response, handler);
        } else if (tokenModel instanceof PastAccessTokenModel) {
            PastAccessTokenModel pastAccessTokenModel = (PastAccessTokenModel)tokenModel;
            this.vaildatePastAccessToken(pastAccessTokenModel, handler);
        } else {
            SecurityOAuth2Exception.throwBy((boolean)true, (String)"\u8bf7\u6c42\u5931\u8d25,tokenModel\u8f6c\u5316\u5931\u8d25");
        }
    }

    private void vaildatePastAccessToken(PastAccessTokenModel pastAccessTokenModel, Object handler) {
        SecurityOAuth2Exception.throwBy((pastAccessTokenModel.getExpiresIn() <= 0L ? 1 : 0) != 0, (String)("\u8bf7\u6c42\u5931\u8d25\uff0cpastToken=[" + pastAccessTokenModel.accessToken + "]\u5df2\u7ecf\u8fc7\u671f~\uff01"));
        String loginToken = pastAccessTokenModel.loginTicket;
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)loginToken), (String)"\u8bf7\u6c42\u5931\u8d25\uff0cLoginToken\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u6c38\u4e0d\u8fc7\u671f\uff0c\u7136\u540e\u7981\u7528cookie");
        SecurityClientModel securityClientModel = this.getClientModel(pastAccessTokenModel.clientId);
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)securityClientModel), (String)("\u8bf7\u6c42\u5931\u8d25,token=[" + pastAccessTokenModel.accessToken + "],\u5ba2\u6237\u7aefclientId=[" + pastAccessTokenModel.clientId + "]\u4e0d\u5b58\u5728"));
        if (HussarUtils.isNotEmpty((Object)handler)) {
            SecurityManager.getStpLogic((String)pastAccessTokenModel.loginType).setTokenValue(loginToken, -1);
            this.checkLoginToken(handler, pastAccessTokenModel.loginType);
        }
    }

    private void validateAccessToken(AccessTokenModel accessTokenModel, SecurityRequest securityRequest, SecurityResponse response, Object handler) {
        SecurityOAuth2Exception.throwBy((accessTokenModel.getExpiresIn() <= 0L ? 1 : 0) != 0, (String)("\u8bf7\u6c42\u5931\u8d25\uff0ctoken=[" + accessTokenModel.accessToken + "]\u8fc7\u671f"));
        String loginToken = accessTokenModel.loginTicket;
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)loginToken), (String)"\u8bf7\u6c42\u5931\u8d25\uff0cLoginToken\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u6c38\u4e0d\u8fc7\u671f\uff0c\u7136\u540e\u7981\u7528cookie");
        SecurityClientModel securityClientModel = this.getClientModel(accessTokenModel.clientId);
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)securityClientModel), (String)("\u8bf7\u6c42\u5931\u8d25,token=[" + accessTokenModel.accessToken + "],\u5ba2\u6237\u7aefclientId=[" + accessTokenModel.clientId + "]\u4e0d\u5b58\u5728"));
        boolean isNoRenew = SecurityRouter.isMatchCurrURI(SecurityConstants.SECURITY_NO_RENEW_URL);
        if (!isNoRenew) {
            AccessTokenModel newAccessTokenModel = this.renewalAndRefreshToken(accessTokenModel, securityClientModel);
            HttpServletResponse responseSource = (HttpServletResponse)response.getSource();
            this.returnAccessTokenModelToResponse(responseSource, newAccessTokenModel);
            if (HussarUtils.isNotEmpty((Object)newAccessTokenModel)) {
                loginToken = newAccessTokenModel.loginTicket;
            }
        }
        SecurityManager.getStpLogic((String)accessTokenModel.loginType).setTokenValue(loginToken, -1);
        if (HussarUtils.isNotEmpty((Object)handler)) {
            this.checkLoginToken(handler, accessTokenModel.loginType);
        }
    }

    private void validateClientToken(ClientTokenModel clientTokenModel, SecurityRequest securityRequest) {
        SecurityOAuth2Exception.throwBy((clientTokenModel.getExpiresIn() <= 0L ? 1 : 0) != 0, (String)("\u8bf7\u6c42\u5931\u8d25\uff0ctoken=[" + clientTokenModel.clientToken + "]\u8fc7\u671f"));
        List permissionList = clientTokenModel.permissions;
        SecurityOAuth2Exception.throwBy((HussarUtils.isEmpty((Object)permissionList) || !permissionList.contains(securityRequest.getRequestPath()) ? 1 : 0) != 0, (String)("\u8bf7\u6c42\u5931\u8d25\uff0cclientId=[" + clientTokenModel.clientId + "]\u65e0\u6743\u8bbf\u95eeurl=[" + securityRequest.getRequestPath() + "]"));
    }

    private void validatePastClientToken(PastClientTokenModel pastClientTokenModel, SecurityRequest securityRequest, SecurityResponse response) {
        SecurityOAuth2Exception.throwBy((pastClientTokenModel.getExpiresIn() <= 0L ? 1 : 0) != 0, (String)("\u8bf7\u6c42\u5931\u8d25\uff0ctoken=[" + pastClientTokenModel.clientToken + "]\u8fc7\u671f"));
        List permissionList = pastClientTokenModel.permissions;
        SecurityOAuth2Exception.throwBy((HussarUtils.isEmpty((Object)permissionList) || !permissionList.contains(securityRequest.getRequestPath()) ? 1 : 0) != 0, (String)("\u8bf7\u6c42\u5931\u8d25\uff0cclientId=[" + pastClientTokenModel.clientId + "]\u65e0\u6743\u8bbf\u95eeurl=[" + securityRequest.getRequestPath() + "]"));
        HttpServletResponse responseSource = (HttpServletResponse)response.getSource();
        this.returnClientTokenModelToResponse(responseSource, pastClientTokenModel);
    }

    private void validateSpecialClientToken(SpecialTokenModel specialTokenModel, SecurityRequest securityRequest, Object handler) {
        SecurityOAuth2Exception.throwBy((specialTokenModel.getExpiresIn() <= 0L ? 1 : 0) != 0, (String)("\u8bf7\u6c42\u5931\u8d25\uff0ctoken=[" + specialTokenModel.accessToken + "]\u8fc7\u671f"));
        String loginToken = specialTokenModel.loginTicket;
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)loginToken), (String)"\u8bf7\u6c42\u5931\u8d25\uff0cLoginToken\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u6c38\u4e0d\u8fc7\u671f\uff0c\u7136\u540e\u7981\u7528cookie");
        SecurityClientModel securityClientModel = this.getClientModel(specialTokenModel.clientId);
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)securityClientModel), (String)("\u8bf7\u6c42\u5931\u8d25,token=[" + specialTokenModel.accessToken + "],\u5ba2\u6237\u7aefclientId=[" + specialTokenModel.clientId + "]\u4e0d\u5b58\u5728"));
        if (HussarUtils.isNotEmpty((Object)handler)) {
            SecurityManager.getStpLogic((String)specialTokenModel.getLoginType()).setTokenValue(loginToken, -1);
            this.checkLoginToken(handler, specialTokenModel.getLoginType());
        }
    }

    private AccessTokenModel renewalAndRefreshToken(AccessTokenModel accessTokenModel, SecurityClientModel securityClientModel) {
        SecurityOAuth2Config securityOAuth2Config = SecurityOAuth2Manager.getConfig();
        if (securityOAuth2Config.getRefreshTokenThreshold() <= 0L) {
            return null;
        }
        if (HussarUtils.isEmpty((Object)securityClientModel)) {
            return null;
        }
        AccessTokenModel newAccessTokenModel = null;
        if (securityOAuth2Config.getEnableRenewal().booleanValue()) {
            SecurityUtil.updateAllLoginTokenTimeout((String)accessTokenModel.loginTicket, (long)securityClientModel.getRefreshTokenValidTime());
            SecurityOAuth2Util.updateAllAccessTokenTimeout((String)accessTokenModel.accessToken, (long)securityClientModel.getAccessTokenValidTime(), (long)securityClientModel.getRefreshTokenValidTime());
        } else if (accessTokenModel.getExpiresIn() > securityOAuth2Config.getRefreshTokenThreshold()) {
            SecurityUtil.updateAllLoginTokenTimeout((String)accessTokenModel.loginTicket, (long)securityClientModel.getRefreshTokenValidTime());
            SecurityOAuth2Util.updateAllAccessTokenTimeout((String)accessTokenModel.accessToken, (long)securityClientModel.getAccessTokenValidTime(), (long)securityClientModel.getRefreshTokenValidTime());
        } else {
            newAccessTokenModel = SecurityOAuth2Util.refreshAccessToken((String)accessTokenModel.refreshToken);
        }
        return newAccessTokenModel;
    }

    private void returnAccessTokenModelToResponse(HttpServletResponse response, AccessTokenModel accessTokenModel) {
        if (HussarUtils.isEmpty((Object)accessTokenModel)) {
            return;
        }
        SecurityResponseForServlet securityResponse = new SecurityResponseForServlet(response);
        securityResponse.setHeader(SecurityOAuth2Constants.Param.client_id, accessTokenModel.clientId);
        securityResponse.setHeader(SecurityOAuth2Constants.Param.access_token, accessTokenModel.accessToken);
        securityResponse.setHeader(SecurityOAuth2Constants.Param.refresh_token, accessTokenModel.refreshToken);
        securityResponse.setHeader(SecurityOAuth2Constants.Param.expires_in, accessTokenModel.getExpiresIn() + "");
        securityResponse.setHeader(SecurityOAuth2Constants.Param.refresh_expires_in, accessTokenModel.getRefreshExpiresIn() + "");
        securityResponse.setHeader(SecurityOAuth2Constants.Param.openid, accessTokenModel.openid);
        securityResponse.setHeader(SecurityOAuth2Constants.Param.scope, accessTokenModel.scope);
        securityResponse.setHeader(SecurityOAuth2Constants.Param.login_ticket, accessTokenModel.loginTicket);
    }

    private void returnClientTokenModelToResponse(HttpServletResponse response, PastClientTokenModel pastClientTokenModel) {
        if (HussarUtils.isEmpty((Object)pastClientTokenModel) || HussarUtils.isEmpty((Object)pastClientTokenModel.getNewClientToken())) {
            return;
        }
        String newClientToken = pastClientTokenModel.getNewClientToken();
        ClientTokenModel clientTokenModel = this.getClientToken(newClientToken, pastClientTokenModel.getTenantCode());
        SecurityResponseForServlet securityResponse = new SecurityResponseForServlet(response);
        securityResponse.setHeader(SecurityOAuth2Constants.Param.client_id, clientTokenModel.clientId);
        securityResponse.setHeader(SecurityOAuth2Constants.Param.client_token, clientTokenModel.clientToken);
        securityResponse.setHeader(SecurityOAuth2Constants.Param.expires_in, clientTokenModel.getExpiresIn() + "");
        securityResponse.setHeader(SecurityOAuth2Constants.Param.scope, clientTokenModel.scope);
        securityResponse.setHeader(SecurityOAuth2Constants.Param.permissions, JsonUtil.toJson((Object)clientTokenModel.permissions));
    }

    private boolean checkLoginToken(Object handler, String loginType) {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            SecurityStrategy.me.checkMethodAuthenticatonAnnotation.accept(method);
        }
        SecurityRouter.match((String[])new String[]{"/**"}).check(() -> SecurityManager.getStpLogic((String)loginType).checkLogin());
        return true;
    }

    public ClientTokenModel generateClientToken(SecurityClientModel securityClientModel, String scope, String tenantCode) {
        String clientTokenValue = this.getClientTokenValue(securityClientModel.getClientId(), tenantCode);
        if (HussarUtils.isNotEmpty((Object)clientTokenValue)) {
            this.deleteClientToken(clientTokenValue, tenantCode);
        }
        this.deleteClientTokenIndex(securityClientModel.getClientId(), tenantCode);
        ClientTokenModel ct = new ClientTokenModel(this.randomClientToken(securityClientModel.getClientId(), scope), securityClientModel.getClientId(), scope);
        ct.expiresTime = System.currentTimeMillis() + securityClientModel.getAccessTokenValidTime() * 1000L;
        ScopePermissionModel scopePermissionModel = new ScopePermissionModel(ct.scope, ct.clientId, tenantCode);
        ct.permissions = ApiManagerUtil.getPermissionList((ScopePermissionModel)scopePermissionModel);
        ct.tenantCode = tenantCode;
        this.saveClientToken(ct);
        this.saveClientTokenIndex(ct);
        return ct;
    }

    public ClientTokenModel generateClientTokenSavePast(SecurityClientModel securityClientModel, String scope, String tenantCode) {
        ClientTokenModel ct = new ClientTokenModel(this.randomClientToken(securityClientModel.getClientId(), scope), securityClientModel.getClientId(), scope);
        ct.expiresTime = System.currentTimeMillis() + securityClientModel.getAccessTokenValidTime() * 1000L;
        ct.tenantCode = tenantCode;
        String pastClientTokenValue = this.getPastClientTokenValue(securityClientModel.clientId, tenantCode);
        if (HussarUtils.isNotEmpty((Object)pastClientTokenValue)) {
            this.deletePastClientToken(pastClientTokenValue, tenantCode);
            this.deletePastClientTokenIndex(securityClientModel.getClientId(), tenantCode);
        }
        ClientTokenModel oldClientTokenModel = this.getClientTokenModel(securityClientModel.getClientId(), tenantCode);
        PastClientTokenModel pastClientTokenModel = null;
        if (HussarUtils.isNotEmpty((Object)oldClientTokenModel)) {
            pastClientTokenModel = new PastClientTokenModel();
            pastClientTokenModel.setClientToken(oldClientTokenModel.clientToken);
            pastClientTokenModel.setExpiresTime(oldClientTokenModel.expiresTime);
            pastClientTokenModel.setPermissions(oldClientTokenModel.permissions);
            pastClientTokenModel.setScope(oldClientTokenModel.scope);
            pastClientTokenModel.setClientId(oldClientTokenModel.clientId);
            pastClientTokenModel.setTenantCode(oldClientTokenModel.tenantCode);
            pastClientTokenModel.setNewClientToken(ct.clientToken);
            ct.permissions = oldClientTokenModel.permissions;
        } else {
            ScopePermissionModel scopePermissionModel = new ScopePermissionModel(ct.scope, ct.clientId, tenantCode);
            ct.permissions = ApiManagerUtil.getPermissionList((ScopePermissionModel)scopePermissionModel);
        }
        this.deleteClientToken(oldClientTokenModel.clientToken, tenantCode);
        this.deleteClientTokenIndex(securityClientModel.getClientId(), tenantCode);
        this.saveClientToken(ct);
        this.saveClientTokenIndex(ct);
        this.savePastClientToken(pastClientTokenModel);
        this.savePastClientTokenIndex(pastClientTokenModel);
        return ct;
    }
}

