/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.interceptors;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.handler.InnerHandler;
import com.jxdinfo.hussar.support.security.core.id.SecurityIdUtil;
import com.jxdinfo.hussar.support.security.core.router.SecurityRouter;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityRequestForServlet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class SecurityIsoloateInternetInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        SecurityOAuth2Config config = SecurityOAuth2Manager.getConfig();
        if (!config.isEnableIsoloate()) {
            return true;
        }
        if (HussarUtils.isNotEmpty((Object)request.getHeader(SecurityOAuth2Constants.Param.swagger))) {
            return true;
        }
        SecurityRequestForServlet securityRequest = new SecurityRequestForServlet(request);
        if (this.isPass((SecurityRequest)securityRequest, handler, config)) {
            return true;
        }
        String isoloateIdToken = this.getIsoloateIdToken((SecurityRequest)securityRequest);
        SecurityOAuth2Exception.throwBy((!SecurityIdUtil.isValid((String)isoloateIdToken) ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u76f4\u63a5\u8bbf\u95ee\u5b50\u670d\u52a1\uff0c\u8bf7\u901a\u8fc7\u7f51\u5173\u8fdb\u884c\u8bbf\u95ee\uff01");
        return true;
    }

    private String getIsoloateIdToken(SecurityRequest request) {
        SecurityOAuth2Config securityOAuth2Config = SecurityOAuth2Manager.getConfig();
        String idToken = request.getHeader(securityOAuth2Config.getIsolatedKey());
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)idToken), (String)"\u65e0\u6cd5\u76f4\u63a5\u8bbf\u95ee\u5b50\u670d\u52a1\uff0c\u8bf7\u901a\u8fc7\u7f51\u5173\u8fdb\u884c\u8bbf\u95ee\uff01");
        return idToken;
    }

    private boolean isPass(SecurityRequest request, Object handler, SecurityOAuth2Config config) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        List ignoreList = InnerHandler.getIgnoreList((SecurityRequest)request, (Object)handler);
        if (SecurityRouter.isMatchCurrURI((List)ignoreList)) {
            return true;
        }
        return HussarUtils.isNotEmpty((Object)request.getHeader(config.getFeignKey())) && config.getFeignSign().equals(request.getHeader(config.getFeignKey()));
    }
}

