/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.support.wrapper;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HussarHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private CharArrayWriter bufferWriter;
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private HttpServletResponse httpServletResponse;

    public HussarHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
        this.bufferWriter = new CharArrayWriter();
        this.httpServletResponse = response;
    }

    public PrintWriter getWriter() throws IOException {
        return this.httpServletResponse.getWriter();
    }

    public ServletOutputStream getOutputStream() {
        return new ServletOutputStreamWrapper(this.byteArrayOutputStream, this.httpServletResponse);
    }

    public String getResult() {
        return this.bufferWriter.toString();
    }

    public String getContent() {
        return new String(this.byteArrayOutputStream.toByteArray());
    }

    public void setContentType(String type) {
        super.setContentType(type);
    }

    private class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private ByteArrayOutputStream outputStream;
        private HttpServletResponse response;

        public ServletOutputStreamWrapper(ByteArrayOutputStream byteArrayOutputStream, HttpServletResponse response) {
            this.outputStream = byteArrayOutputStream;
            this.response = response;
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener listener) {
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        public void flush() throws IOException {
            if (!this.response.isCommitted()) {
                byte[] body = this.outputStream.toByteArray();
                ServletOutputStream outputStream = this.response.getOutputStream();
                outputStream.write(body);
                outputStream.flush();
            }
        }
    }
}

