/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.support;

import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.security.core.config.SecurityTokenConfig;
import com.jxdinfo.hussar.support.security.core.dto.LoginUserAuthorizationDTO;
import com.jxdinfo.hussar.support.security.core.properties.HussarReloadUserAuthorizationProperties;
import com.jxdinfo.hussar.support.security.core.session.SecuritySession;
import com.jxdinfo.hussar.support.security.core.session.TokenSession;
import com.jxdinfo.hussar.support.security.core.session.TokenSign;
import com.jxdinfo.hussar.support.security.core.stp.SecurityLogic;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserAuthorizationReloader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractUserAuthorizationReloader.class);
    protected static final String HUSSAR_USER_AUTHORIZATION_CHANGE = "hussar_user_authorization_change";
    protected static final String ROLES_LIST = "rolesList";
    protected static final String PERMISSIONS_CHECKSUM = "permissionsChecksum";
    protected static final String PERMISSIONS = "permissions";
    @Resource
    private HussarReloadUserAuthorizationProperties properties;

    public void reload(String accessToken) {
        Long userId;
        UserDetails userDetails;
        if (!this.properties.getEnable().booleanValue()) {
            return;
        }
        if (HussarUtils.isNotEmpty((Object)accessToken) && HussarUtils.isNotEmpty((Object)(userDetails = HussarSecurityUtils.getLoginUserDetails(accessToken))) && HussarCacheUtil.containKey((String)HUSSAR_USER_AUTHORIZATION_CHANGE, (Object)(userId = userDetails.getUserId()))) {
            ArrayList<String> affectedTokens = new ArrayList();
            try {
                affectedTokens = this.doReload(userId, userDetails);
            }
            catch (Exception e) {
                logger.error("\u6743\u9650\u4fe1\u606f\u53d8\u66f4\u540e\uff0c\u5237\u65b0\u5df2\u767b\u5f55\u7528\u6237\u7f13\u5b58\u5931\u8d25, userId = {}", (Object)userId, (Object)e);
            }
            try {
                this.callback(userId, affectedTokens);
            }
            catch (Exception e) {
                logger.error("\u6743\u9650\u4fe1\u606f\u53d8\u66f4\uff0c\u5237\u65b0\u767b\u5f55\u7528\u6237\u7f13\u5b58\u540e\u6267\u884c\u56de\u8c03\u65b9\u6cd5\u5931\u8d25, userId = {}", (Object)userId, (Object)e);
            }
        }
    }

    private List<String> doReload(Long userId, UserDetails curUserDetails) {
        LoginUserAuthorizationDTO userAuthorization = this.generateUserLatestAuthorization(userId);
        if (HussarUtils.isEmpty((Object)userAuthorization)) {
            return new ArrayList<String>();
        }
        if (!this.isUserAuthorizationChanged(userAuthorization, curUserDetails)) {
            return new ArrayList<String>();
        }
        List<String> loginTickets = this.getLoginTickets(userId);
        ArrayList<String> affectedTokens = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(loginTickets)) {
            for (String loginTicket : loginTickets) {
                TokenSession tokenSession = SecurityUtil.getTokenSession((String)loginTicket);
                if (HussarUtils.isEmpty((Object)tokenSession)) {
                    logger.warn("\u901a\u8fc7loginTicket = {} \u83b7\u53d6tokenSession\u4e3a\u7a7a", (Object)loginTicket);
                    continue;
                }
                UserDetails userDetails = tokenSession.getUserDetails();
                userDetails.addExtendUserMap(ROLES_LIST, (Object)userAuthorization.getRoleIds());
                if (userAuthorization.getPermissionsChecksum() != null) {
                    userDetails.addExtendUserMap(PERMISSIONS_CHECKSUM, (Object)userAuthorization.getPermissionsChecksum());
                } else {
                    userDetails.addExtendUserMap(PERMISSIONS, (Object)userAuthorization.getPermissions());
                }
                Map addExtendMap = userAuthorization.getExtendMap();
                if (HussarUtils.isNotEmpty((Object)addExtendMap)) {
                    addExtendMap.forEach((arg_0, arg_1) -> ((UserDetails)userDetails).addExtendUserMap(arg_0, arg_1));
                }
                tokenSession.setUserDetails(userDetails);
                SecurityUtil.updateTokenSession((String)loginTicket, (TokenSession)tokenSession);
                affectedTokens.add(userDetails.getAccessToken());
            }
        }
        HussarCacheUtil.evict((String)HUSSAR_USER_AUTHORIZATION_CHANGE, (Object)userId);
        HussarCacheUtil.evictKeysLeftLike((String)((SecurityTokenConfig)SpringContextUtil.getBean(SecurityTokenConfig.class)).getTokenName(), (String)SecurityLogic.splicingUserPermissions((String)"*", (Long)userId));
        return affectedTokens;
    }

    protected boolean isUserAuthorizationChanged(LoginUserAuthorizationDTO userAuthorization, UserDetails curUserDetails) {
        if (!HussarUtils.equals((Object)userAuthorization.getRoleIds(), (Object)curUserDetails.getExtendUserMap(ROLES_LIST))) {
            return true;
        }
        if (HussarUtils.isNotEmpty((Object)userAuthorization.getExtendMap())) {
            return true;
        }
        if (HussarUtils.isNotEmpty((Object)userAuthorization.getPermissionsChecksum()) && HussarUtils.isNotEmpty((Object)curUserDetails.getExtendUserMap(PERMISSIONS_CHECKSUM))) {
            return !HussarUtils.equals((Object)userAuthorization.getPermissionsChecksum(), (Object)curUserDetails.getExtendUserMap(PERMISSIONS_CHECKSUM));
        }
        if (userAuthorization.getPermissions() != null && curUserDetails.getExtendUserMap(PERMISSIONS) != null) {
            return !HussarUtils.equals((Object)userAuthorization.getPermissions(), (Object)curUserDetails.getExtendUserMap(PERMISSIONS));
        }
        return false;
    }

    public abstract LoginUserAuthorizationDTO generateUserLatestAuthorization(Long var1);

    public void callback(Long userId, List<String> tokens) {
    }

    private List<String> getLoginTickets(Long userId) {
        ArrayList<String> loginTickets = new ArrayList<String>();
        SecuritySession session = SecurityUtil.getSessionByLoginId((Object)userId);
        if (session != null) {
            List tokenSignList = session.getTokenSignList();
            for (TokenSign tokenSign : tokenSignList) {
                loginTickets.add(tokenSign.getValue());
            }
        }
        return loginTickets;
    }
}

