/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.interceptors;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityOAuth2InterceptorCustomizers;
import com.jxdinfo.hussar.support.security.plugin.oauth2.handler.AbstractOauth2HandlerInterceptor;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityRequestForServlet;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityResponseForServlet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class SecurityOAuth2Interceptor
extends AbstractOauth2HandlerInterceptor
implements HandlerInterceptor {
    private static Logger LOGGER = LoggerFactory.getLogger(SecurityOAuth2Interceptor.class);
    private List<HussarSecurityOAuth2InterceptorCustomizers> hussarCustomizers;

    public SecurityOAuth2Interceptor() {
    }

    public SecurityOAuth2Interceptor(Optional<List<HussarSecurityOAuth2InterceptorCustomizers>> hussarSecurityOAuth2InterceptorCustomizers) {
        List<HussarSecurityOAuth2InterceptorCustomizers> list;
        if (hussarSecurityOAuth2InterceptorCustomizers.isPresent() && HussarUtils.isNotEmpty(list = hussarSecurityOAuth2InterceptorCustomizers.get())) {
            this.hussarCustomizers = list.stream().sorted(Comparator.comparing(HussarSecurityOAuth2InterceptorCustomizers::order)).collect(Collectors.toList());
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        SecurityRequestForServlet securityRequest = new SecurityRequestForServlet(request);
        SecurityResponseForServlet securityResponse = new SecurityResponseForServlet(response);
        boolean prehandler = this.isPrehandler((SecurityRequest)securityRequest, (SecurityResponse)securityResponse, handler);
        if (prehandler) {
            return true;
        }
        this.customizeHussarSecurityOAuth2InterceptorCustomizers((SecurityRequest)securityRequest, (SecurityResponse)securityResponse);
        this.validateTokenModel((SecurityRequest)securityRequest, (SecurityResponse)securityResponse, handler);
        return true;
    }

    public boolean extendPreHandler(SecurityRequest securityRequest, SecurityResponse securityResponse, Object handler) {
        return false;
    }

    protected void customizeHussarSecurityOAuth2InterceptorCustomizers(SecurityRequest request, SecurityResponse response) {
        if (HussarUtils.isNotEmpty(this.hussarCustomizers)) {
            this.hussarCustomizers.forEach(customizers -> customizers.customize(request, response));
        }
    }
}

