/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.filter;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.constants.enums.ExceptionCodeEnum;
import com.jxdinfo.hussar.platform.core.utils.ExceptionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.ReflectUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.handler.InnerHandler;
import com.jxdinfo.hussar.support.security.core.router.SecurityRouter;
import com.jxdinfo.hussar.support.security.integration.authentication.support.wrapper.HussarHttpServletResponseWrapper;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.handler.AbstractOauth2HandlerInterceptor;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityRequestForServlet;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityResponseForServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class SecurityOAuth2ServletFilter
extends AbstractOauth2HandlerInterceptor
implements Filter {
    private static Logger LOGGER = LoggerFactory.getLogger(SecurityOAuth2ServletFilter.class);
    private List<String> distinctIgnoreList;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        SecurityRequestForServlet securityRequest = new SecurityRequestForServlet(httpServletRequest);
        SecurityResponseForServlet securityResponse = new SecurityResponseForServlet(httpServletResponse);
        try {
            RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)SpringContextUtil.getBean((String)"requestMappingHandlerMapping");
            Method getHandlerInternal = ReflectUtil.getMethod(RequestMappingHandlerMapping.class, (String)"getHandlerInternal", (Class[])new Class[]{HttpServletRequest.class});
            getHandlerInternal.setAccessible(true);
            HandlerMethod handlerMethod = (HandlerMethod)getHandlerInternal.invoke((Object)mapping, httpServletRequest);
            if (HussarUtils.isNotEmpty((Object)handlerMethod)) {
                chain.doFilter(request, response);
                return;
            }
            boolean prehandler = this.isPrehandler((SecurityRequest)securityRequest, (SecurityResponse)securityResponse, null);
            if (prehandler) {
                chain.doFilter(request, response);
                return;
            }
            this.validateTokenModel((SecurityRequest)securityRequest, (SecurityResponse)securityResponse, null);
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            this.doException(httpServletRequest, httpServletResponse, e);
        }
    }

    public boolean isPrehandler(SecurityRequest securityRequest, SecurityResponse securityResponse, Object handler) {
        this.distinctIgnoreList = InnerHandler.getIgnoreList((SecurityRequest)securityRequest, (Object)handler);
        if (SecurityRouter.isMatchCurrURI(this.distinctIgnoreList)) {
            return true;
        }
        SecurityOAuth2Config config = SecurityOAuth2Manager.getConfig();
        if (!config.isEnableIsolateFeign() && HussarUtils.isNotEmpty((Object)securityRequest.getHeader(config.getFeignKey())) && config.getFeignSign().equals(securityRequest.getHeader(config.getFeignKey()))) {
            return true;
        }
        boolean preHandler = this.extendPreHandler(securityRequest, securityResponse, handler);
        return preHandler;
    }

    public boolean extendPreHandler(SecurityRequest securityRequest, SecurityResponse securityResponse, Object handler) {
        return false;
    }

    private void doException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception e) throws IOException {
        ApiResponse apiResponse;
        HussarHttpServletResponseWrapper hussarHttpServletResponseWrapper = new HussarHttpServletResponseWrapper(httpServletResponse);
        if (httpServletRequest != null && !StringUtils.isEmpty((Object)httpServletRequest.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", new Object[]{httpServletRequest.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        e.printStackTrace();
        if (e instanceof SecurityOAuth2Exception) {
            hussarHttpServletResponseWrapper.setStatus(HttpStatus.OK.value());
            apiResponse = ApiResponse.fail((int)ExceptionCodeEnum.UNKNOWN_AUTHENTICATION_EXCEPTION.getCode(), (String)e.getMessage());
        } else {
            Throwable unwrap = ExceptionUtil.unwrap((Throwable)e);
            hussarHttpServletResponseWrapper.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            apiResponse = ApiResponse.fail((String)unwrap.getMessage());
        }
        httpServletResponse.setContentType("application/json; charset=UTF-8");
        String toJson = JsonUtil.toJson((Object)apiResponse);
        PrintWriter printWriter = hussarHttpServletResponseWrapper.getWriter();
        printWriter.write(toJson);
        printWriter.flush();
        printWriter.close();
    }
}

