/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.config;

import com.jxdinfo.hussar.encrypt.util.SM3Util;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.crypto.properties.HussarEncryptProperties;
import com.jxdinfo.hussar.platform.core.support.service.AuthSecurityUserDetailService;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.DeviceUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.core.exception.LoginCheckEncryptPwException;
import com.jxdinfo.hussar.support.security.core.exception.NotLoginException;
import com.jxdinfo.hussar.support.security.core.stp.SecurityLoginModel;
import com.jxdinfo.hussar.support.security.core.stp.SecurityTokenInfo;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.DefaultSecurityAuthenticationService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityAuthenticationService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.extend.otherauth.service.SecurityOAuth2SpecialHandlerService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.extend.otherauth.service.impl.DefaultSecurityOAuth2SpecialHandlerService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.HussarSecurityOauthListener;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.DefaultSecurityOAuth2HandleService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.service.SecurityOAuth2HandleService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SecurityClientModel;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ModelAndView;

@Configuration
@ConditionalOnExpression(value="!${hussar.core.enable-micro-service:false} and ${hussar.security.enable:true}")
public class AuthenticationOAuth2Configuration {
    @Autowired
    private AuthSecurityUserDetailService authSecurityUserDetailService;
    @Autowired
    private HussarEncryptProperties hussarEncryptProperties;
    @Autowired
    private PasswordEncryptService passwordEncryptService;
    public Supplier<Object> notLoginView = () -> {
        throw NotLoginException.newInstance((String)"pc", null);
    };
    public BiFunction<String, String, Object> confirmView = (clientId, scope) -> {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("clientId", (String)clientId);
        map.put("scope", (String)scope);
        return new ModelAndView("confirm.html", map);
    };
    public Function<LoginUser, Object> doLoginHandle = loginUser -> {
        UserDetails userDetails;
        SecurityOAuth2Exception.throwBy((HussarUtils.isEmpty((Object)loginUser) || HussarUtils.isEmpty((Object)loginUser.getUserName()) || HussarUtils.isEmpty((Object)loginUser.getPassword()) ? 1 : 0) != 0, (String)"\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)loginUser.getClientId()), (String)"clientId\u4e3a\u7a7a\uff01");
        SecurityClientModel securityClientModel = SecurityOAuth2Util.checkClientModel((String)loginUser.getClientId());
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)securityClientModel), (String)("clientId:" + loginUser.getClientId() + "\u5bf9\u5e94securityClientModel\u4e0d\u5b58\u5728"));
        if (this.hussarEncryptProperties.isEnablePwEncryption() && HussarUtils.isEmpty((Object)loginUser.getExtendMap(SecurityOAuth2Constants.Param.swagger))) {
            String decryptPassword;
            String md5;
            String username_password_md5;
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = HussarUtils.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
            String string = username_password_md5 = HussarUtils.isEmpty((Object)request) ? null : request.getHeader(SecurityOAuth2Constants.Param.sec_check);
            if (HussarUtils.isNotEmpty((Object)username_password_md5) && !username_password_md5.equals(md5 = SM3Util.digest((String)(loginUser.getUserName() + loginUser.getPassword())))) {
                throw new HussarException("\u6570\u636e\u5b8c\u6574\u6027\u88ab\u7834\u574f!");
            }
            try {
                decryptPassword = this.passwordEncryptService.decrypt(loginUser.getPassword());
            }
            catch (HussarException e) {
                throw new LoginCheckEncryptPwException();
            }
            loginUser.setPassword(decryptPassword);
        }
        if (HussarUtils.isNotEmpty((Object)(userDetails = this.authSecurityUserDetailService.loadUserByUsername(loginUser))) && HussarUtils.isNotEmpty((Object)userDetails.getUserId())) {
            String device;
            SecurityLoginModel securityLoginModel = new SecurityLoginModel();
            securityLoginModel.setTimeout(securityClientModel.getRefreshTokenValidTime());
            if (HussarUtils.isNotEmpty((Object)userDetails.getMaxSameCount())) {
                securityLoginModel.setMaxSameCount(userDetails.getMaxSameCount());
            }
            if (HussarUtils.isNotEmpty((Object)(device = DeviceUtils.getDevice()))) {
                securityLoginModel.setDevice(device);
            }
            SecurityUtil.login((Object)userDetails.getUserId(), (SecurityLoginModel)securityLoginModel);
            SecurityTokenInfo tokenInfo = SecurityUtil.getTokenInfo();
            userDetails.setLoginType(tokenInfo.getLoginType());
            userDetails.setLoginDevice(tokenInfo.getLoginDevice());
            userDetails.setTokenName(tokenInfo.getTokenName());
            userDetails.setTokenValue(tokenInfo.getTokenValue());
            userDetails.setLoginId(tokenInfo.loginId);
            userDetails.setAccessToken(tokenInfo.getShareAccessToken());
            SecurityUtil.getTokenSession((String)tokenInfo.getTokenValue()).addUserDetailToTokenSession(userDetails, tokenInfo.getTokenValue());
            return ApiResponse.success((Object)userDetails, (String)"\u767b\u5f55\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u8d26\u53f7\u540d\u6216\u5bc6\u7801\u9519\u8bef");
    };

    @Autowired
    @ConditionalOnBean(value={AuthSecurityUserDetailService.class})
    public void setSaOAuth2Config(SecurityOAuth2Config cfg) {
        cfg.setNotLoginView(this.notLoginView).setDoLoginHandle(this.doLoginHandle).setConfirmView(this.confirmView);
    }

    @Bean
    public SecurityOAuth2HandleService securityOAuth2HandleService(HussarSecurityAuthenticationService hussarSecurityAuthenticationService) {
        return new DefaultSecurityOAuth2HandleService(hussarSecurityAuthenticationService);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityOAuth2SpecialHandlerService securityOAuth2SpecialHandlerService() {
        return new DefaultSecurityOAuth2SpecialHandlerService();
    }

    @Bean
    @ConditionalOnMissingBean
    public HussarSecurityAuthenticationService hussarSecurityAuthenticationService(HussarSecurityOauthListener hussarSecurityOauthListener) {
        return new DefaultSecurityAuthenticationService(hussarSecurityOauthListener);
    }
}

