/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.integration.authentication.config;

import com.jxdinfo.hussar.support.cache.support.redis.HussarRedisTemplate;
import com.jxdinfo.hussar.support.security.core.context.SecurityTokenContext;
import com.jxdinfo.hussar.support.security.integration.authentication.interceptors.SecurityDaoPrefetchInterceptor;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.properties.SecurityCacheProperties;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Template;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(prefix="hussar.security", name={"enable"}, havingValue="true", matchIfMissing=true)
public class AuthenticationDaoPrefetchInterceptorConfiguration
implements WebMvcConfigurer {
    @Autowired
    private SecurityTokenContext tokenContext;
    @Autowired
    private SecurityCacheProperties cacheProperties;
    @Autowired
    @Lazy
    private SecurityOAuth2Template oauth2Template;
    @Autowired(required=false)
    private HussarRedisTemplate<Object, Object> hussarRedisTemplate;

    public void addInterceptors(@NonNull InterceptorRegistry registry) {
        if (Boolean.TRUE.equals(this.cacheProperties.getDaoPrefetch())) {
            SecurityDaoPrefetchInterceptor prefetchInterceptor = new SecurityDaoPrefetchInterceptor(this.tokenContext, this.cacheProperties, this.oauth2Template);
            prefetchInterceptor.setRedisTemplate(this.hussarRedisTemplate);
            registry.addInterceptor((HandlerInterceptor)prefetchInterceptor).addPathPatterns(new String[]{"/**"}).order(-101);
        }
    }
}

