/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.exceptionHandler;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.constants.enums.ExceptionCodeEnum;
import com.jxdinfo.hussar.support.log.trace.annotation.Trace;
import com.jxdinfo.hussar.support.security.core.exception.LoginCheckEncryptPwException;
import com.jxdinfo.hussar.support.security.core.exception.MaxSameAccountException;
import com.jxdinfo.hussar.support.security.core.exception.NotLoginException;
import com.jxdinfo.hussar.support.security.core.exception.NotPermissionException;
import com.jxdinfo.hussar.support.security.core.exception.NotRoleException;
import com.jxdinfo.hussar.support.security.core.exception.NotSafeException;
import com.jxdinfo.hussar.support.security.core.exception.SecurityTokenException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=1)
public class SecurityGlobalExceptionHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(SecurityGlobalExceptionHandler.class);

    @ExceptionHandler(value={NotLoginException.class})
    @Trace
    public ApiResponse<?> handlerException(NotLoginException e, HttpServletRequest request) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        e.printStackTrace();
        return ApiResponse.fail((int)ExceptionCodeEnum.NOTLOGIN_CODE.getCode(), (String)ExceptionCodeEnum.NOTLOGIN_CODE.getMessage());
    }

    @ExceptionHandler(value={NotPermissionException.class})
    @Trace
    public ApiResponse<?> handlerException(NotPermissionException e, HttpServletRequest request) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        e.printStackTrace();
        return ApiResponse.fail((int)ExceptionCodeEnum.NOTPERMISSION_CODE.getCode(), (String)ExceptionCodeEnum.NOTPERMISSION_CODE.getMessage());
    }

    @ExceptionHandler(value={NotRoleException.class})
    @Trace
    public ApiResponse<?> handlerException(NotRoleException e, HttpServletRequest request) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        e.printStackTrace();
        return ApiResponse.fail((int)ExceptionCodeEnum.NOTROLE_CODE.getCode(), (String)ExceptionCodeEnum.NOTROLE_CODE.getMessage());
    }

    @ExceptionHandler(value={SecurityTokenException.class})
    @Trace
    public ApiResponse<?> handlerException(SecurityTokenException e, HttpServletRequest request) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        e.printStackTrace();
        return ApiResponse.fail((int)ExceptionCodeEnum.UNKNOWN_AUTHENTICATION_EXCEPTION.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={MaxSameAccountException.class})
    @Trace
    public ApiResponse<?> handlerException(MaxSameAccountException e, HttpServletRequest request) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        e.printStackTrace();
        return ApiResponse.fail((int)ExceptionCodeEnum.MAX_SAME_ACCOUNT_CODE.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={NotSafeException.class})
    public ApiResponse<?> handlerException(NotSafeException e, HttpServletRequest request) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u8ba4\u8bc1\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        return ApiResponse.fail((int)ExceptionCodeEnum.NOT_SAFE.getCode(), (String)ExceptionCodeEnum.NOT_SAFE.getMessage());
    }

    @ExceptionHandler(value={LoginCheckEncryptPwException.class})
    public ApiResponse<?> handlerException(LoginCheckEncryptPwException e, HttpServletRequest request) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u767b\u5f55\u65f6\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u767b\u5f55\u65f6\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        e.printStackTrace();
        return ApiResponse.fail((int)ExceptionCodeEnum.PAGE_OVERDUE_TRY_LOGIN_AGAIN.getCode(), (String)ExceptionCodeEnum.PAGE_OVERDUE_TRY_LOGIN_AGAIN.getMessage());
    }
}

