/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.interceptor;

import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.exception.BackResultException;
import com.jxdinfo.hussar.support.security.core.exception.StopMatchException;
import com.jxdinfo.hussar.support.security.core.router.SecurityRouteFunction;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityRequestForServlet;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityResponseForServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class SecurityRouteInterceptor
implements HandlerInterceptor {
    private static Logger LOGGER = LoggerFactory.getLogger(SecurityRouteInterceptor.class);
    public SecurityRouteFunction function = (req, res, handler) -> SecurityUtil.checkLogin();

    public SecurityRouteInterceptor() {
    }

    public SecurityRouteInterceptor(SecurityRouteFunction function) {
        this.function = function;
    }

    public static SecurityRouteInterceptor newInstance(SecurityRouteFunction function) {
        return new SecurityRouteInterceptor(function);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            this.function.run((SecurityRequest)new SecurityRequestForServlet(request), (SecurityResponse)new SecurityResponseForServlet(response), handler);
        }
        catch (StopMatchException stopMatchException) {
        }
        catch (BackResultException e) {
            if (response.getContentType() == null) {
                response.setContentType("text/plain; charset=utf-8");
            }
            response.getWriter().print(e.getMessage());
            return false;
        }
        return true;
    }
}

