/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.filter;

import com.jxdinfo.hussar.support.security.core.exception.BackResultException;
import com.jxdinfo.hussar.support.security.core.exception.SecurityTokenException;
import com.jxdinfo.hussar.support.security.core.exception.StopMatchException;
import com.jxdinfo.hussar.support.security.core.filter.FilterAuthStrategy;
import com.jxdinfo.hussar.support.security.core.filter.FilterErrorStrategy;
import com.jxdinfo.hussar.support.security.core.router.SecurityRouter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.core.annotation.Order;

@Order(value=-100)
public class SecurityServletFilter
implements Filter {
    private List<String> includeList = new ArrayList<String>();
    private List<String> excludeList = new ArrayList<String>();
    public FilterAuthStrategy auth = r -> {};
    public FilterErrorStrategy error = e -> {
        throw new SecurityTokenException(e);
    };
    public FilterAuthStrategy beforeAuth = r -> {};

    public SecurityServletFilter addInclude(String ... paths) {
        this.includeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SecurityServletFilter addExclude(String ... paths) {
        this.excludeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SecurityServletFilter setIncludeList(List<String> pathList) {
        this.includeList = pathList;
        return this;
    }

    public SecurityServletFilter setExcludeList(List<String> pathList) {
        this.excludeList = pathList;
        return this;
    }

    public List<String> getIncludeList() {
        return this.includeList;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    public SecurityServletFilter setAuth(FilterAuthStrategy auth) {
        this.auth = auth;
        return this;
    }

    public SecurityServletFilter setError(FilterErrorStrategy error) {
        this.error = error;
        return this;
    }

    public SecurityServletFilter setBeforeAuth(FilterAuthStrategy beforeAuth) {
        this.beforeAuth = beforeAuth;
        return this;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            SecurityRouter.match(this.includeList).notMatch(this.excludeList).check(r -> {
                this.beforeAuth.run(null);
                this.auth.run(null);
            });
        }
        catch (StopMatchException stopMatchException) {
        }
        catch (Throwable e) {
            String result;
            String string = result = e instanceof BackResultException ? e.getMessage() : String.valueOf(this.error.run(e));
            if (response.getContentType() == null) {
                response.setContentType("text/plain; charset=utf-8");
            }
            response.getWriter().print(result);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

