/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.interceptor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.strategy.SecurityStrategy;
import com.jxdinfo.hussar.support.security.plugin.oauth2.enums.Auth2TypeEnum;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.handler.AbstractOauth2HandlerInterceptor;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityRequestForServlet;
import com.jxdinfo.hussar.support.security.servlet.model.SecurityResponseForServlet;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class SecurityAnnotationAuthorityInterceptor
extends AbstractOauth2HandlerInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        SecurityRequestForServlet securityRequest = new SecurityRequestForServlet(request);
        SecurityResponseForServlet securityResponse = new SecurityResponseForServlet(response);
        boolean prehandler = this.isPrehandler((SecurityRequest)securityRequest, (SecurityResponse)securityResponse, handler);
        if (prehandler) {
            return true;
        }
        Method method = ((HandlerMethod)handler).getMethod();
        SecurityStrategy.me.checkMethodAuthorityAnnotation.accept(method);
        return true;
    }

    public boolean extendPreHandler(SecurityRequest securityRequest, SecurityResponse securityResponse, Object handler) {
        TokenModel tokenModel = this.getTokenModel(securityRequest);
        if (HussarUtils.isEmpty((Object)tokenModel)) {
            return false;
        }
        Auth2TypeEnum auth2TypeEnumByType = Auth2TypeEnum.getAuth2TypeEnumByType(tokenModel.getClass());
        SecurityOAuth2Exception.throwBy((boolean)HussarUtils.isEmpty((Object)auth2TypeEnumByType), (String)"\u9274\u6743\u5931\u8d25\uff0c\u672a\u627e\u5230\u6b64\u8ba4\u8bc1\u65b9\u5f0f\u7684token");
        return !auth2TypeEnumByType.isEnableAuthority();
    }
}

