/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.service.impl;

import com.jxdinfo.hussar.encrypt.util.SM2Util;
import com.jxdinfo.hussar.platform.core.crypto.properties.HussarEncryptProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.core.dto.PasswordEncryptDTO;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2PasswordEncryptServiceImpl
implements PasswordEncryptService {
    protected Logger logger = LoggerFactory.getLogger(SM2PasswordEncryptServiceImpl.class);
    @Resource
    private HussarEncryptProperties hussarEncryptProperties;

    @Override
    public void initEncryptKey() {
        this.logger.info("\u5bc6\u7801\u52a0\u5bc6\u7b97\u6cd5\u4f7f\u7528sm2");
        String publicKey = (String)HussarFixedCacheUtil.get((String)"pw_encrypt_cache", (Object)"pw_encrypt_sm2_pub", String.class);
        String privateKey = (String)HussarFixedCacheUtil.get((String)"pw_encrypt_cache", (Object)"pw_encrypt_sm2_pri", String.class);
        if (HussarUtils.isNoneBlank((CharSequence[])new CharSequence[]{publicKey, privateKey})) {
            return;
        }
        Map sm2PubAndPriKey = SM2Util.generateKeyPair();
        publicKey = (String)sm2PubAndPriKey.get("pubKey");
        privateKey = (String)sm2PubAndPriKey.get("priKey");
        HussarFixedCacheUtil.put((String)"pw_encrypt_cache", (Object)"pw_encrypt_sm2_pub", (Object)publicKey);
        HussarFixedCacheUtil.put((String)"pw_encrypt_cache", (Object)"pw_encrypt_sm2_pri", (Object)privateKey);
    }

    @Override
    public PasswordEncryptDTO getPasswordEncryptInfo() {
        PasswordEncryptDTO dto = new PasswordEncryptDTO();
        dto.setEnabled(Boolean.valueOf(this.hussarEncryptProperties.isEnablePwEncryption()));
        dto.setEncryptType(this.hussarEncryptProperties.getPwEncryptionType());
        String sm2PubKey = (String)HussarFixedCacheUtil.get((String)"pw_encrypt_cache", (Object)"pw_encrypt_sm2_pub", String.class);
        dto.setEncryptKey(sm2PubKey);
        return dto;
    }

    @Override
    public String decrypt(String encryptPwd) {
        String pwd;
        try {
            String sm2PriKey = (String)HussarFixedCacheUtil.get((String)"pw_encrypt_cache", (Object)"pw_encrypt_sm2_pri", String.class);
            pwd = SM2Util.decrypt((String)encryptPwd, (String)sm2PriKey);
        }
        catch (Exception e) {
            throw new HussarException("\u767b\u5f55\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
        }
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)pwd), (String)"\u767b\u5f55\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
        return pwd;
    }
}

