/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.riskprotect.config;

import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.support.secure.riskprotect.filter.CsrfFilter;
import com.jxdinfo.hussar.support.secure.riskprotect.filter.XssFilter;
import com.jxdinfo.hussar.support.secure.riskprotect.properties.CorsProperties;
import com.jxdinfo.hussar.support.secure.riskprotect.properties.FirewallProperties;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FirewallConfig {
    @Resource
    private FirewallProperties firewallProperties;
    @Autowired
    AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Autowired
    private CorsProperties corsProperties;

    @Bean
    public FilterRegistrationBean<XssFilter> xssFilterRegistration() {
        XssFilter xssFilter = new XssFilter();
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)xssFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        xssFilter.setXssLevel(this.firewallProperties.getFirewallXssLevel());
        List<String> xssList = this.firewallProperties.getXssWhitelist();
        StringBuffer exclusions = new StringBuffer("/logout,/static/*,*.js,*.gif,*.jpg,*.png,*.css,*.ico");
        StringBuffer pathChecks = new StringBuffer("*/sqlnet.log,*/sqlnet.trc,*/status.cgi,*.cgi,*.dll,*.exe,*.sh,*.bat*,/servlet/viewsource.jsp,/cgi-bin/htgrep/*,*.asp,*.aspx,*php,*php5,*php4,*php3,*php2,*php1,*.swp");
        if (xssList != null && xssList.size() > 0) {
            for (String string : xssList) {
                exclusions.append(",");
                exclusions.append(string);
            }
        }
        registration.addInitParameter("exclusions", exclusions.toString());
        List<String> xssBlackList = this.firewallProperties.getXssBlacklist();
        if (xssBlackList != null && xssBlackList.size() > 0) {
            for (String string : xssBlackList) {
                pathChecks.append(",");
                pathChecks.append(string);
            }
        }
        registration.addInitParameter("pathChecks", pathChecks.toString());
        return registration;
    }

    @Bean
    public FilterRegistrationBean<CsrfFilter> csrfFilterRegistration() {
        String[] allowedOrigins;
        CsrfFilter csrfFilter = new CsrfFilter(this.abstractOTPCredentialsMatcher);
        csrfFilter.setCsrfcheck(this.firewallProperties.getCheckCsrfOpen());
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)csrfFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        StringBuffer exclusions = new StringBuffer("/logout,/static/*,/monitor,*.js,*.gif,*.jpg,*.png,*.css,*.ico");
        List<String> csrfList = this.firewallProperties.getCsrfWhitelist();
        if (csrfList != null && csrfList.size() > 0) {
            for (String string : csrfList) {
                exclusions.append(",");
                exclusions.append(string);
            }
        }
        StringBuffer referExclusions = new StringBuffer();
        List<String> referList = this.firewallProperties.getReferWhitelist();
        if (referList != null && referList.size() > 0) {
            for (String string : referList) {
                referExclusions.append(",");
                referExclusions.append(string);
            }
        } else {
            referExclusions.append("http://").append(",").append("https://");
        }
        for (String string : allowedOrigins = this.corsProperties.getAllowedOrigins()) {
            referExclusions.append(",");
            referExclusions.append(string);
        }
        csrfFilter.setRefererWhitelist(referExclusions.toString());
        registration.addInitParameter("exclusions", exclusions.toString());
        return registration;
    }
}

