/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.riskprotect.utils;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;

public class RiskProtectPluginUtils {
    public static final String DELEGATE_BOUNDSQL_SQL = "delegate.boundSql.sql";
    public static final String DELEGATE = "delegate";
    public static final String H_TARGET = "h.target";

    public static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return RiskProtectPluginUtils.realTarget(metaObject.getValue(H_TARGET));
        }
        return (T)target;
    }

    public static MPBoundSql mpBoundSql(BoundSql boundSql) {
        return new MPBoundSql(boundSql);
    }

    public static MPStatementHandler mpStatementHandler(StatementHandler statementHandler) {
        statementHandler = (StatementHandler)RiskProtectPluginUtils.realTarget(statementHandler);
        MetaObject object = SystemMetaObject.forObject((Object)statementHandler);
        return new MPStatementHandler(SystemMetaObject.forObject((Object)object.getValue(DELEGATE)));
    }

    public static MPExecutor mpExecutor(Executor executor) {
        executor = (Executor)RiskProtectPluginUtils.realTarget(executor);
        MetaObject object = SystemMetaObject.forObject((Object)executor);
        return new MPExecutor(SystemMetaObject.forObject((Object)object.getValue(DELEGATE)));
    }

    public static class MPExecutor {
        private final MetaObject executor;

        MPExecutor(MetaObject executor) {
            this.executor = executor;
        }

        public Configuration configuration() {
            return (Configuration)this.get("configuration");
        }

        private <T> T get(String property) {
            return (T)this.executor.getValue(property);
        }
    }

    public static class MPBoundSql {
        private final MetaObject boundSql;
        private final BoundSql delegate;

        MPBoundSql(BoundSql boundSql) {
            this.delegate = boundSql;
            this.boundSql = SystemMetaObject.forObject((Object)boundSql);
        }

        public String sql() {
            return this.delegate.getSql();
        }

        public void sql(String sql) {
            this.boundSql.setValue("sql", (Object)sql);
        }

        public List<ParameterMapping> parameterMappings() {
            List parameterMappings = this.delegate.getParameterMappings();
            return new ArrayList<ParameterMapping>(parameterMappings);
        }

        public void parameterMappings(List<ParameterMapping> parameterMappings) {
            this.boundSql.setValue("parameterMappings", Collections.unmodifiableList(parameterMappings));
        }

        public Object parameterObject() {
            return this.get("parameterObject");
        }

        public Map<String, Object> additionalParameters() {
            return (Map)this.get("additionalParameters");
        }

        public void additionalParameters(Map<String, Object> additionalParametersMap) {
            this.boundSql.setValue("additionalParameters", additionalParametersMap);
        }

        private <T> T get(String property) {
            return (T)this.boundSql.getValue(property);
        }
    }

    public static class MPStatementHandler {
        private final MetaObject statementHandler;

        MPStatementHandler(MetaObject statementHandler) {
            this.statementHandler = statementHandler;
        }

        public ParameterHandler parameterHandler() {
            return (ParameterHandler)this.get("parameterHandler");
        }

        public MappedStatement mappedStatement() {
            return (MappedStatement)this.get("mappedStatement");
        }

        public RowBounds rowBounds() {
            return (RowBounds)this.get("rowBounds");
        }

        public ResultSetHandler resultSetHandler() {
            return (ResultSetHandler)this.get("resultSetHandler");
        }

        public void resultSetHandler(ResultSetHandler resultSetHandler) {
            this.statementHandler.setValue("resultSetHandler", (Object)resultSetHandler);
        }

        public Executor executor() {
            return (Executor)this.get("executor");
        }

        public MPBoundSql mPBoundSql() {
            return new MPBoundSql(this.boundSql());
        }

        public BoundSql boundSql() {
            return (BoundSql)this.get("boundSql");
        }

        public Configuration configuration() {
            return (Configuration)this.get("configuration");
        }

        private <T> T get(String property) {
            return (T)this.statementHandler.getValue(property);
        }
    }
}

