/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.riskprotect.interceptor;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.jxdinfo.hussar.platform.core.utils.ClassUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.function.Func1;
import com.jxdinfo.hussar.platform.core.utils.regex.RegexUtil;
import com.jxdinfo.hussar.support.secure.riskprotect.properties.SecureRiskProtectProperties;
import com.jxdinfo.hussar.support.secure.riskprotect.utils.RiskProtectPluginUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HussarLikeEscapeInterceptor
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HussarLikeEscapeInterceptor.class);
    private static final String ROOT_SQL_NODE = "sqlSource.rootSqlNode";
    private static final String REGEX_LIKE = "(\\w+)\\s+LIKE\\s+#\\{ew\\.paramNameValuePairs\\.(MPGENVAL\\d+)}";
    private static final String REGTEX_LIKE_ESCAPE = "(\\w+)\\s+LIKE\\s+\\?";
    private static final String REGEX_LIKE_MARK = "#\\{ew\\.paramNameValuePairs\\.MPGENVAL\\d+}";
    private static final Character ESCAPE_SYMBOL = Character.valueOf('|');
    private static List<Character> SYMBOLS = CollectionUtil.ofImmutableList((Object[])new Character[]{Character.valueOf('%'), Character.valueOf('_')});
    private static final Pattern REGEX_LIKE_PATTERN = Pattern.compile("(\\w+)\\s+LIKE\\s+#\\{ew\\.paramNameValuePairs\\.(MPGENVAL\\d+)}", 2);
    private static final Pattern REGTEX_LIKE_ESCAPE_PATTERN = Pattern.compile("(\\w+)\\s+LIKE\\s+\\?", 2);
    private static final Pattern REGEX_LIKE_MARK_PATTERN = Pattern.compile("#\\{ew\\.paramNameValuePairs\\.MPGENVAL\\d+}", 2);
    private static final String ESCAPE_STATEMENT = "escape '|'";
    private static final Pattern SPECIAL_WORD_PATTERN = Pattern.compile("[%_]", 2);
    private static final Pattern ALREADY_RESOLVE = Pattern.compile("(\\\\%|\\\\_)+", 2);
    private SecureRiskProtectProperties secureRiskProtectProperties;

    public HussarLikeEscapeInterceptor(SecureRiskProtectProperties secureRiskProtectProperties) {
        this.secureRiskProtectProperties = secureRiskProtectProperties;
    }

    public HussarLikeEscapeInterceptor() {
    }

    public boolean willDoQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        RiskProtectPluginUtils.MPBoundSql mpBoundSql = RiskProtectPluginUtils.mpBoundSql(boundSql);
        try {
            if (!this.support(boundSql)) {
                return true;
            }
            this.doLikeEscapeService(executor, boundSql);
        }
        catch (Exception e) {
            log.error("like escape error", (Throwable)e);
        }
        return true;
    }

    private void doLikeEscapeService(Executor executor, BoundSql boundSql) {
        RiskProtectPluginUtils.MPExecutor mpExecutor = RiskProtectPluginUtils.mpExecutor(executor);
        MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)boundSql.getParameterObject();
        AbstractWrapper abstractWrapper = (AbstractWrapper)paramMap.get((Object)"ew");
        String sqlSegment = abstractWrapper.getSqlSegment();
        if (HussarUtils.isEmpty((Object)sqlSegment)) {
            return;
        }
        ArrayList columnsKeyList = new ArrayList();
        RegexUtil.replaceAll((CharSequence)sqlSegment, (Pattern)REGEX_LIKE_PATTERN, (Func1 & Serializable)matchResult -> {
            if (this.handleParameter(boundSql, matchResult.group(2))) {
                columnsKeyList.add(matchResult.group(1));
            }
            return matchResult.group(0);
        });
        if (HussarUtils.isEmpty(columnsKeyList)) {
            return;
        }
        String doSql = RegexUtil.replaceAll((CharSequence)boundSql.getSql(), (Pattern)REGTEX_LIKE_ESCAPE_PATTERN, (Func1 & Serializable)matchResult -> {
            String group = matchResult.group(0);
            if (columnsKeyList.contains(matchResult.group(1))) {
                return group + " " + ESCAPE_STATEMENT;
            }
            return group;
        });
        doSql = RegexUtil.replaceAll((CharSequence)doSql, (Pattern)REGEX_LIKE_MARK_PATTERN, (Func1 & Serializable)matchResult -> "?");
        RiskProtectPluginUtils.MPBoundSql mpBoundSql = RiskProtectPluginUtils.mpBoundSql(boundSql);
        mpBoundSql.sql(doSql);
    }

    public boolean handleParameter(BoundSql boundSql, String paramKey) {
        String parameter;
        Object parameterObject = boundSql.getParameterObject();
        MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
        AbstractWrapper abstractWrapper = (AbstractWrapper)paramMap.get((Object)"ew");
        Map paramNameValuePairs = abstractWrapper.getParamNameValuePairs();
        if (HussarUtils.isEmpty((Object)paramNameValuePairs)) {
            return false;
        }
        Object val = paramNameValuePairs.get(paramKey);
        if (val instanceof String && (parameter = val.toString()).length() > 2 && parameter.startsWith("%") && parameter.endsWith("%") && SPECIAL_WORD_PATTERN.matcher(parameter = parameter.substring(1, parameter.length() - 1)).find() && !ALREADY_RESOLVE.matcher(parameter).find()) {
            parameter = this.resolveParameter(parameter);
            paramNameValuePairs.put(paramKey, "%" + parameter + "%");
            return true;
        }
        return false;
    }

    public boolean support(BoundSql boundSql) {
        MapperMethod.ParamMap paramMap;
        String sql = boundSql.getSql();
        Object parameterObject = boundSql.getParameterObject();
        return this.secureRiskProtectProperties.isEnableEscape() && RegexUtil.contains((Pattern)REGTEX_LIKE_ESCAPE_PATTERN, (CharSequence)sql) && HussarUtils.isNotEmpty((Object)parameterObject) && ClassUtil.isAssignable(MapperMethod.ParamMap.class, parameterObject.getClass()) && (paramMap = (MapperMethod.ParamMap)parameterObject).containsKey((Object)"ew") && HussarUtils.isNotEmpty((Object)paramMap.get((Object)"ew")) && paramMap.get((Object)"ew") instanceof AbstractWrapper;
    }

    private String resolveParameter(String param) {
        StringBuffer sb = new StringBuffer();
        Character pre = Character.valueOf(' ');
        char[] cArray = param.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character cur = Character.valueOf(cArray[i]);
            if (SYMBOLS.contains(cur) && pre != ESCAPE_SYMBOL) {
                sb.append(ESCAPE_SYMBOL);
            }
            pre = cur;
            sb.append(cur);
        }
        return sb.toString();
    }
}

