/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.riskprotect.filter;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.secure.riskprotect.properties.SecureRiskProtectProperties;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ActuatorFilter
implements Filter {
    private SecureRiskProtectProperties secureRiskProtectProperties;

    public ActuatorFilter(SecureRiskProtectProperties secureRiskProtectProperties) {
        this.secureRiskProtectProperties = secureRiskProtectProperties;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String path = httpServletRequest.getRequestURI();
        if (path.startsWith("/actuator") && this.secureRiskProtectProperties.getActuatorAccessCheck().booleanValue()) {
            List<SecureRiskProtectProperties.IpSegment> ipSegments;
            String requestIp = IpUtils.getIp((HttpServletRequest)httpServletRequest);
            if (HussarUtils.isBlank((CharSequence)requestIp)) {
                throw new HussarException("\u83b7\u53d6\u8bf7\u6c42ip\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u8bbf\u95eeactuator\u7aef\u70b9");
            }
            List<String> ips = this.secureRiskProtectProperties.getActuatorAccessIps();
            if (HussarUtils.isAllEmpty((Object[])new Object[]{ips, ipSegments = this.secureRiskProtectProperties.getActuatorAccessIpSegments()})) {
                throw new HussarException("\u672a\u914d\u7f6e\u5141\u8bb8\u8bbf\u95eeactuator\u7aef\u70b9\u7684ip\uff0c\u8bf7\u6c42\u88ab\u62d2\u7edd");
            }
            Boolean valid = false;
            if (ips.contains(requestIp)) {
                valid = true;
            }
            if (!valid.booleanValue() && HussarUtils.isNotEmpty(ipSegments)) {
                Long ipValue = IpUtils.convertStrIpToLong((String)requestIp);
                valid = ipSegments.stream().anyMatch(ipSegment -> {
                    try {
                        Long start = IpUtils.convertStrIpToLong((String)ipSegment.getStartIp());
                        Long end = IpUtils.convertStrIpToLong((String)ipSegment.getEndIp());
                        return ipValue >= start && ipValue <= end;
                    }
                    catch (Exception e) {
                        throw new HussarException("\u5141\u8bb8\u8bbf\u95eeactuator\u7aef\u70b9\u7684ip\u6bb5\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u6c42\u88ab\u62d2\u7edd");
                    }
                });
            }
            if (!valid.booleanValue()) {
                throw new HussarException("\u8bf7\u6c42ip\u672a\u5728\u5141\u8bb8\u8bbf\u95ee\u540d\u5355\u5185\uff0cactuator\u7aef\u70b9\u8bf7\u6c42\u88ab\u62d2\u7edd");
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

