/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.riskprotect.config;

import com.jxdinfo.hussar.support.secure.riskprotect.config.CorsAutoConfiguration;
import com.jxdinfo.hussar.support.secure.riskprotect.config.FirewallConfig;
import com.jxdinfo.hussar.support.secure.riskprotect.filter.ActuatorFilter;
import com.jxdinfo.hussar.support.secure.riskprotect.filter.XssHandlerMappingPostProcessor;
import com.jxdinfo.hussar.support.secure.riskprotect.properties.CorsProperties;
import com.jxdinfo.hussar.support.secure.riskprotect.properties.SecureRiskProtectProperties;
import javax.servlet.Filter;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={CorsProperties.class})
@Import(value={CorsAutoConfiguration.class, FirewallConfig.class})
@ConditionalOnProperty(prefix="hussar.secure.risk-protect", name={"enable"}, havingValue="true", matchIfMissing=true)
public class RiskProtectConfig {
    @Bean
    public SecureRiskProtectProperties secureRiskProtectProperties() {
        return new SecureRiskProtectProperties();
    }

    @Bean
    public FilterRegistrationBean actuatorRegistrationBean() {
        FilterRegistrationBean actuatorRegistrationBean = new FilterRegistrationBean();
        actuatorRegistrationBean.setFilter(this.actuatorFilter(this.secureRiskProtectProperties()));
        actuatorRegistrationBean.addUrlPatterns(new String[]{"/actuator/*"});
        actuatorRegistrationBean.setOrder(Integer.MIN_VALUE);
        return actuatorRegistrationBean;
    }

    @Bean
    public Filter actuatorFilter(SecureRiskProtectProperties secureRiskProtectProperties) {
        return new ActuatorFilter(secureRiskProtectProperties);
    }

    @Bean
    public BeanPostProcessor xssHandlerMappingPostProcessor() {
        return new XssHandlerMappingPostProcessor();
    }
}

