/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.riskprotect.config;

import com.jxdinfo.hussar.support.secure.riskprotect.properties.CorsProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="hussar.cors", name={"enabled"}, havingValue="true")
public class CorsAutoConfiguration
extends WebMvcConfigurationSupport {
    @Autowired
    private CorsProperties properties;

    public void addCorsMappings(CorsRegistry registry) {
        CorsRegistration corsRegistration = registry.addMapping(this.properties.getPathPattern());
        corsRegistration.allowedOrigins(this.properties.getAllowedOrigins()).allowedHeaders(this.properties.getAllowedHeaders()).maxAge(this.properties.getMaxAge().longValue()).allowCredentials(this.properties.getAllowCredentials().booleanValue());
        if (this.properties.getAllowedMethods() != null) {
            corsRegistration.allowedMethods(this.properties.getAllowedMethods());
        }
        if (this.properties.getExposedHeaders() != null) {
            corsRegistration.exposedHeaders(this.properties.getExposedHeaders());
        }
    }
}

