/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.encrypt.support;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.secure.encrypt.properties.SecureEncryptProperties;
import com.jxdinfo.hussar.support.secure.encrypt.utils.EncryptUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.support.MultipartResolutionDelegate;

public class AbstractEncryptResolverAdvice {
    private final SecureEncryptProperties properties;

    protected boolean isEncrypted() {
        NativeWebRequest webRequest = EncryptUtils.getWebRequest();
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        boolean multipartRequest = MultipartResolutionDelegate.isMultipartRequest((HttpServletRequest)servletRequest);
        if (multipartRequest) {
            return false;
        }
        return this.matchPath(servletRequest.getRequestURI());
    }

    protected boolean matchPath(String path) {
        List<String> ignoreEncryptUrls = this.properties.getIgnoreEncryptUrls();
        if (HussarUtils.isEmpty(ignoreEncryptUrls)) {
            return true;
        }
        boolean flag = true;
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (String ignoreEncryptUrl : ignoreEncryptUrls) {
            boolean match = antPathMatcher.match(ignoreEncryptUrl, path);
            if (!match) continue;
            flag = false;
            break;
        }
        return flag;
    }

    protected AbstractEncryptResolverAdvice(SecureEncryptProperties properties) {
        this.properties = properties;
    }

    public SecureEncryptProperties getProperties() {
        return this.properties;
    }
}

