/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.rmi;

import com.jxdinfo.hussar.support.rmi.annotation.RmiApiScannerRegister;
import com.jxdinfo.hussar.support.rmi.core.config.RmiApiConfiguration;
import com.jxdinfo.hussar.support.rmi.core.config.RmiApiProperties;
import com.jxdinfo.hussar.support.rmi.core.converter.RmiApiConverter;
import com.jxdinfo.hussar.support.rmi.core.converter.json.RmiApiJsonConverter;
import com.jxdinfo.hussar.support.rmi.core.exceptions.RmiApiRuntimeException;
import com.jxdinfo.hussar.support.rmi.core.interceptor.InterceptorFactory;
import com.jxdinfo.hussar.support.rmi.core.logging.RmiApiLogHandler;
import com.jxdinfo.hussar.support.rmi.core.reflection.RmiApiObjectFactory;
import com.jxdinfo.hussar.support.rmi.core.utils.RmiApiDataType;
import com.jxdinfo.hussar.support.rmi.core.utils.StringUtils;
import com.jxdinfo.hussar.support.rmi.plugin.spring.config.SpringRmiApiProperties;
import com.jxdinfo.hussar.support.rmi.plugin.spring.interceptor.SpringInterceptorFactory;
import com.jxdinfo.hussar.support.rmi.plugin.spring.reflection.SpringRmiApiObjectFactory;
import com.jxdinfo.hussar.support.rmi.plugin.spring.scanner.ClassPathClientScanner;
import com.jxdinfo.hussar.support.rmi.plugin.spring.schema.RmiApiConfigurationBeanDefinitionParser;
import com.jxdinfo.hussar.support.rmi.plugin.spring.spring.ConverterBeanListener;
import com.jxdinfo.hussar.support.rmi.properties.RmiApiConfigurationProperties;
import com.jxdinfo.hussar.support.rmi.properties.RmiApiConvertProperties;
import com.jxdinfo.hussar.support.rmi.properties.RmiApiConverterItemProperties;
import com.jxdinfo.hussar.support.rmi.properties.RmiApiSSLKeyStoreProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class RmiApiBeanRegister
implements ResourceLoaderAware,
BeanPostProcessor {
    private final ConfigurableApplicationContext applicationContext;
    private ResourceLoader resourceLoader;
    private final SpringRmiApiProperties properties;
    private final SpringRmiApiObjectFactory rmiApiObjectFactory;
    private final SpringInterceptorFactory rmiApiInterceptorFactory;
    private RmiApiConfigurationProperties rmiApiConfigurationProperties;

    public RmiApiBeanRegister(ConfigurableApplicationContext applicationContext, RmiApiConfigurationProperties rmiApiConfigurationProperties, SpringRmiApiProperties properties, SpringRmiApiObjectFactory rmiApiObjectFactory, SpringInterceptorFactory rmiApiInterceptorFactory) {
        this.applicationContext = applicationContext;
        this.rmiApiConfigurationProperties = rmiApiConfigurationProperties;
        this.properties = properties;
        this.rmiApiObjectFactory = rmiApiObjectFactory;
        this.rmiApiConfigurationProperties = rmiApiConfigurationProperties;
        this.rmiApiInterceptorFactory = rmiApiInterceptorFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public RmiApiConfiguration registerRmiApiConfiguration() {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(RmiApiConfiguration.class);
        String id = this.rmiApiConfigurationProperties.getBeanId();
        if (StringUtils.isBlank((String)id)) {
            id = "rmiApiConfiguration";
        }
        Class<? extends RmiApiLogHandler> logHandlerClass = this.rmiApiConfigurationProperties.getLogHandler();
        RmiApiLogHandler logHandler = null;
        if (logHandlerClass != null) {
            try {
                logHandler = logHandlerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RmiApiRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new RmiApiRuntimeException((Throwable)e);
            }
        }
        beanDefinitionBuilder.addPropertyValue("maxAsyncThreadSize", (Object)this.rmiApiConfigurationProperties.getMaxAsyncThreadSize()).addPropertyValue("maxAsyncQueueSize", (Object)this.rmiApiConfigurationProperties.getMaxAsyncQueueSize()).addPropertyValue("maxConnections", (Object)this.rmiApiConfigurationProperties.getMaxConnections()).addPropertyValue("maxRouteConnections", (Object)this.rmiApiConfigurationProperties.getMaxRouteConnections()).addPropertyValue("timeout", (Object)this.rmiApiConfigurationProperties.getTimeout()).addPropertyValue("connectTimeout", (Object)this.rmiApiConfigurationProperties.getConnectTimeoutMillis()).addPropertyValue("readTimeout", (Object)this.rmiApiConfigurationProperties.getReadTimeoutMillis()).addPropertyValue("charset", (Object)this.rmiApiConfigurationProperties.getCharset()).addPropertyValue("retryer", (Object)this.rmiApiConfigurationProperties.getRetryer()).addPropertyValue("maxRetryCount", (Object)this.rmiApiConfigurationProperties.getMaxRetryCount()).addPropertyValue("maxRetryInterval", (Object)this.rmiApiConfigurationProperties.getMaxRetryInterval()).addPropertyValue("autoRedirection", (Object)this.rmiApiConfigurationProperties.isAutoRedirection()).addPropertyValue("logEnabled", (Object)this.rmiApiConfigurationProperties.isLogEnabled()).addPropertyValue("logRequest", (Object)this.rmiApiConfigurationProperties.isLogRequest()).addPropertyValue("logResponseStatus", (Object)this.rmiApiConfigurationProperties.isLogResponseStatus()).addPropertyValue("logResponseContent", (Object)this.rmiApiConfigurationProperties.isLogResponseContent()).addPropertyValue("logHandler", (Object)logHandler).addPropertyValue("backendName", (Object)this.rmiApiConfigurationProperties.getBackend()).addPropertyValue("baseAddressScheme", (Object)this.rmiApiConfigurationProperties.getBaseAddressScheme()).addPropertyValue("baseAddressHost", (Object)this.rmiApiConfigurationProperties.getBaseAddressHost()).addPropertyValue("baseAddressPort", (Object)this.rmiApiConfigurationProperties.getBaseAddressPort()).addPropertyValue("baseAddressSourceClass", this.rmiApiConfigurationProperties.getBaseAddressSource()).addPropertyValue("successWhenClass", this.rmiApiConfigurationProperties.getSuccessWhen()).addPropertyValue("retryWhenClass", this.rmiApiConfigurationProperties.getRetryWhen()).addPropertyValue("interceptors", this.rmiApiConfigurationProperties.getInterceptors()).addPropertyValue("sslProtocol", (Object)this.rmiApiConfigurationProperties.getSslProtocol()).addPropertyValue("variables", this.rmiApiConfigurationProperties.getVariables()).setLazyInit(false).setFactoryMethod("configuration");
        List<RmiApiSSLKeyStoreProperties> sslKeyStorePropertiesList = this.rmiApiConfigurationProperties.getSslKeyStores();
        ManagedMap sslKeystoreMap = new ManagedMap();
        for (RmiApiSSLKeyStoreProperties keyStoreProperties : sslKeyStorePropertiesList) {
            this.registerSSLKeyStoreBean((ManagedMap<String, BeanDefinition>)sslKeystoreMap, keyStoreProperties);
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.getPropertyValues().addPropertyValue("sslKeyStores", (Object)sslKeystoreMap);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        RmiApiConfiguration configuration = (RmiApiConfiguration)this.applicationContext.getBean(id, RmiApiConfiguration.class);
        configuration.setProperties((RmiApiProperties)this.properties);
        configuration.setRmiApiObjectFactory((RmiApiObjectFactory)this.rmiApiObjectFactory);
        configuration.setInterceptorFactory((InterceptorFactory)this.rmiApiInterceptorFactory);
        Map<String, Class> filters = this.rmiApiConfigurationProperties.getFilters();
        for (Map.Entry<String, Class> entry : filters.entrySet()) {
            String filterName = entry.getKey();
            Class filterClass = entry.getValue();
            configuration.registerFilter(filterName, filterClass);
        }
        RmiApiConvertProperties convertProperties = this.rmiApiConfigurationProperties.getConverters();
        if (convertProperties != null) {
            this.registerConverter(configuration, RmiApiDataType.TEXT, convertProperties.getText());
            this.registerConverter(configuration, RmiApiDataType.JSON, convertProperties.getJson());
            this.registerConverter(configuration, RmiApiDataType.XML, convertProperties.getXml());
            this.registerConverter(configuration, RmiApiDataType.BINARY, convertProperties.getBinary());
            this.registerConverter(configuration, RmiApiDataType.PROTOBUF, convertProperties.getProtobuf());
        }
        this.registerConverterBeanListener(configuration);
        return configuration;
    }

    public ConverterBeanListener registerConverterBeanListener(RmiApiConfiguration rmiApiConfiguration) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConverterBeanListener.class);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.getPropertyValues().addPropertyValue("rmiApiConfiguration", (Object)rmiApiConfiguration);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition("rmiApiConverterBeanListener", (BeanDefinition)beanDefinition);
        return (ConverterBeanListener)this.applicationContext.getBean("rmiApiConverterBeanListener", ConverterBeanListener.class);
    }

    private void registerConverter(RmiApiConfiguration configuration, RmiApiDataType dataType, RmiApiConverterItemProperties converterItemProperties) {
        if (converterItemProperties == null) {
            return;
        }
        Class<? extends RmiApiJsonConverter> type = converterItemProperties.getType();
        if (type != null) {
            RmiApiConverter converter = null;
            try {
                PropertyDescriptor[] descriptors;
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = type.getConstructors()) {
                    Parameter[] params = constructor.getParameters();
                    if (params.length == 0) {
                        converter = (RmiApiConverter)constructor.newInstance(new Object[0]);
                        break;
                    }
                    if (params.length != 1 || !RmiApiConfiguration.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
                    converter = (RmiApiConverter)constructor.newInstance(constructor);
                    break;
                }
                Map<String, Object> parameters = converterItemProperties.getParameters();
                for (PropertyDescriptor descriptor : descriptors = ReflectUtils.getBeanSetters(type)) {
                    String name = descriptor.getName();
                    Object value = parameters.get(name);
                    Method method = descriptor.getWriteMethod();
                    if (method == null) continue;
                    try {
                        method.invoke((Object)converter, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RmiApiRuntimeException("An error occurred during setting the property " + type.getName() + "." + name, (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RmiApiRuntimeException("An error occurred during setting the property " + type.getName() + "." + name, (Throwable)e);
                    }
                }
                configuration.getConverterMap().put(dataType, converter);
            }
            catch (InstantiationException e) {
                throw new RmiApiRuntimeException("[RmiApi] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new RmiApiRuntimeException("[RmiApi] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new RmiApiRuntimeException("[RmiApi] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
        }
    }

    public BeanDefinition registerSSLKeyStoreBean(ManagedMap<String, BeanDefinition> map, RmiApiSSLKeyStoreProperties sslKeyStoreProperties) {
        String id = sslKeyStoreProperties.getId();
        if (StringUtils.isBlank((String)id)) {
            throw new RmiApiRuntimeException("[RmiApi] Property 'id' of SSL keystore can not be empty or blank");
        }
        if (map.containsKey((Object)id)) {
            throw new RmiApiRuntimeException("[RmiApi] Duplicate SSL keystore id '" + id + "'");
        }
        BeanDefinition beanDefinition = RmiApiConfigurationBeanDefinitionParser.createSSLKeyStoreBean((String)id, (String)sslKeyStoreProperties.getType(), (String)sslKeyStoreProperties.getFile(), (String)sslKeyStoreProperties.getKeystorePass(), (String)sslKeyStoreProperties.getCertPass(), (String)sslKeyStoreProperties.getProtocols(), (String)sslKeyStoreProperties.getCipherSuites(), (String)sslKeyStoreProperties.getHostnameVerifier(), (String)sslKeyStoreProperties.getSslSocketFactoryBuilder());
        map.put((Object)id, (Object)beanDefinition);
        return beanDefinition;
    }

    public ClassPathClientScanner registerScanner() {
        List<String> basePackages = RmiApiScannerRegister.getBasePackages();
        String configurationId = RmiApiScannerRegister.getConfigurationId();
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        ClassPathClientScanner scanner = new ClassPathClientScanner(configurationId, registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        if (basePackages == null || basePackages.size() == 0) {
            return scanner;
        }
        scanner.doScan(org.springframework.util.StringUtils.toStringArray(basePackages));
        return scanner;
    }
}

