/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.plugin.minio.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.platform.core.utils.lang.MultiLangUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.dao.AttachmentManagerMapper;
import com.jxdinfo.hussar.support.oss.core.support.dto.AttachInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.dto.FileInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.entity.FileAddition;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.util.CheckUploadFileUtils;
import com.jxdinfo.hussar.support.oss.core.support.util.OssCascadeUtils;
import com.jxdinfo.hussar.support.oss.core.support.util.OssEncoderUtils;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.oss.core.support.vo.FileEncryptVo;
import com.jxdinfo.hussar.support.oss.core.support.vo.RangeDownloadVO;
import com.jxdinfo.hussar.support.oss.plugin.minio.properties.OssMinioProperties;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.errors.ErrorResponseException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import okhttp3.Headers;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@HussarDs(value="master")
public class MinioAttachmentManagerServiceImpl
extends HussarServiceImpl<AttachmentManagerMapper, AttachmentManagerModel>
implements AttachmentManagerService {
    private final OssMinioProperties ossMinioProperties;
    private final GetLoginUserService getLoginUserService;
    private final MinioClient minioClient;
    @Resource
    private OssProperties ossProperties;
    @Resource
    private SeqBuilder seqBuilder;
    private static final Logger logger = LogManager.getLogger(MinioAttachmentManagerServiceImpl.class);

    public MinioAttachmentManagerServiceImpl(OssMinioProperties ossMinioProperties, GetLoginUserService getLoginUserService, MinioClient minioClient) {
        this.ossMinioProperties = ossMinioProperties;
        this.getLoginUserService = getLoginUserService;
        this.minioClient = minioClient;
        try {
            boolean found = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(ossMinioProperties.getBucketName())).build());
            if (!found) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(ossMinioProperties.getBucketName())).build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(OssExceptionEnum.MINIO_CREATEBUCKET_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_CREATEBUCKET_EXCEPTION.getMessage());
        }
    }

    public Long saveAttachment(AttachmentManagerModel attachmentManagerModel) {
        this.save((BaseEntity)attachmentManagerModel);
        return attachmentManagerModel.getId();
    }

    public String findDirById(Long id) {
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentManagerModel)) {
            return "";
        }
        return attachmentManagerModel.getAttachmentDir();
    }

    public AttachmentManagerModelVo getByFileId(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        return this.getAttachmentVoById(fileId);
    }

    public List<AttachmentManagerModelVo> getByFileIds(String[] fileIds) {
        ArrayList<AttachmentManagerModelVo> attachmentManagerModelVos = new ArrayList<AttachmentManagerModelVo>();
        if (HussarUtils.isEmpty((Object[])fileIds)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        for (String fileId : fileIds) {
            if (!HussarUtils.isNotEmpty((Object)fileId)) continue;
            attachmentManagerModelVos.add(this.getAttachmentVoById(Long.parseLong(fileId)));
        }
        return attachmentManagerModelVos;
    }

    public ApiResponse<String> upload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file) || HussarUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties);
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fName = IdWorker.get32UUID() + suffix;
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(this.ossMinioProperties.getFileUploadPath() + fName)).stream(file.getInputStream(), -1L, 0xA00000L).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getMessage());
        }
        return ApiResponse.success((String)fName);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String securityLevel = multipartRequest.getParameter("securityLevel");
        String seq = multipartRequest.getParameter("seq");
        multipartRequest.setCharacterEncoding("UTF-8");
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)iterator.next();
        }
        if (HussarUtils.isNotEmpty(multipartFile)) {
            CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
            attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId, securityLevel, seq);
        }
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartFile multipartFile, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartFile)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
        return ApiResponse.success((Object)this.packageAttachmentVo(multipartFile, businessId, null, null));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<AttachmentManagerModelVo> uploadMultipleFile(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        ArrayList<AttachmentManagerModelVo> voList = new ArrayList<AttachmentManagerModelVo>();
        String securityLevel = multipartRequest.getParameter("securityLevel");
        String seq = multipartRequest.getParameter("seq");
        multipartRequest.setCharacterEncoding("UTF-8");
        Map map = multipartRequest.getFileMap();
        if (HussarUtils.isNotEmpty((Object)map)) {
            map.values().forEach(file -> CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties));
        }
        for (MultipartFile file2 : map.values()) {
            MultipartFile multipartFile = file2;
            if (!HussarUtils.isNotEmpty((Object)multipartFile)) continue;
            AttachmentManagerModelVo attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId, securityLevel, seq);
            voList.add(attachmentManagerModelVo);
        }
        return voList;
    }

    public void fileDownload(HttpServletResponse response, Long fileId) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = attachmentModel.getAttachmentName();
        String path = attachmentModel.getAttachmentDir() + attachmentModel.getId() + this.getSuffix(fileName);
        GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build();
        InputStream fileInputStream = null;
        String tmpFileName = OssCascadeUtils.getRandomFileName();
        try (GetObjectResponse stream = this.minioClient.getObject(args);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            response.reset();
            response.addHeader("Content-Disposition", OssEncoderUtils.buildContentDisposition((String)fileName));
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Length", stream.headers().get("Content-Length"));
            if (HussarUtils.isNotEmpty((Object)attachmentModel.getEncrypt())) {
                File realFile = OssCascadeUtils.decryptInputStreamToFile((String)tmpFileName, (String)this.getSuffix(fileName), (InputStream)stream, (String)attachmentModel.getEncrypt());
                response.addHeader("Content-Length", String.valueOf(realFile.length()));
                fileInputStream = new FileInputStream(realFile);
                IoUtil.copy((InputStream)fileInputStream, (OutputStream)out);
            } else {
                IoUtil.copy((InputStream)stream, (OutputStream)out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.MINIO_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_DOWN_EXCEPTION.getMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (HussarUtils.isNotEmpty((Object)attachmentModel.getEncrypt())) {
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.getTempPath() + tmpFileName + this.getSuffix(fileName)));
                }
            }
            catch (IOException e) {
                logger.error("\u5206\u4fdd: \u6587\u4ef6\u4e0b\u8f7d\u540e\u5220\u9664\u672c\u5730\u5b58\u50a8\u7684\u660e\u6587\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void batchDownload(String ids, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, String> files = new HashMap<String, String>();
        Arrays.stream(ids.split(",")).forEach(s -> {
            if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                files.put((String)s, (String)null);
            }
        });
        this.downloadZipfile(files, null, response);
    }

    public void batchDownloadByMaps(Map<String, String> files, String zipName, HttpServletResponse response) throws ServletException, IOException {
        this.downloadZipfile(files, zipName, response);
    }

    private void downloadZipfile(Map<String, String> files, String zipName, HttpServletResponse response) throws ServletException, IOException {
        if (HussarUtils.isEmpty(files) || HussarUtils.isEmpty((Object)response)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        ServletOutputStream os = response.getOutputStream();
        ArrayList<Long> fileIdList = new ArrayList<Long>();
        for (Map.Entry<String, String> entry : files.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            fileIdList.add(Long.parseLong(key));
        }
        List attachList = this.listByIds(fileIdList);
        ArrayList<String> needDeleteFilePaths = new ArrayList<String>();
        InputStream inputStream = null;
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)os);){
            String sourceFilePath = "\u6279\u91cf\u4e0b\u8f7d.zip";
            if (StringUtil.isNotEmpty((Object)zipName)) {
                sourceFilePath = zipName + ".zip";
            }
            response.setHeader("Content-Disposition", OssEncoderUtils.buildContentDisposition((String)sourceFilePath));
            response.setContentType("application/octet-stream");
            HashMap<String, Map> dirCounters = new HashMap<String, Map>();
            String tmpFileName = OssCascadeUtils.getRandomFileName();
            for (AttachmentManagerModel attach : attachList) {
                Long id = attach.getId();
                String fileName = attach.getAttachmentName();
                String path = attach.getAttachmentDir() + id + this.getSuffix(fileName);
                String folderName = files.get(Long.toString(id));
                String normalizedDir = StringUtil.isEmptyIfStr((Object)folderName) ? "" : OssCascadeUtils.formatDirectoryPath((String)folderName);
                Map counterMap = dirCounters.computeIfAbsent(normalizedDir, k -> new HashMap());
                int fileNameCount = counterMap.getOrDefault(fileName, 0);
                String uniqueName = fileNameCount == 0 ? fileName : OssCascadeUtils.generateCountedName((String)fileName, (int)fileNameCount);
                counterMap.put(fileName, fileNameCount + 1);
                String entryPath = normalizedDir.isEmpty() ? uniqueName : normalizedDir + uniqueName;
                inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build());
                ZipEntry zipEntry = new ZipEntry(entryPath);
                zos.putNextEntry(zipEntry);
                if (HussarUtils.isNotEmpty((Object)attach.getEncrypt())) {
                    String suffix = this.getSuffix(fileName);
                    File realFile = OssCascadeUtils.decryptInputStreamToFile((String)tmpFileName, (String)suffix, (InputStream)inputStream, (String)attach.getEncrypt());
                    inputStream = new FileInputStream(realFile);
                    needDeleteFilePaths.add(OssCascadeUtils.tempPath((String)tmpFileName, (String)suffix));
                }
                IoUtil.copy((InputStream)inputStream, (OutputStream)zos);
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (HussarUtils.isNotEmpty(needDeleteFilePaths)) {
                for (String path : needDeleteFilePaths) {
                    try {
                        FileUtils.forceDelete((File)new File(path));
                    }
                    catch (IOException e) {
                        logger.error("\u5206\u4fdd: \u591a\u6587\u4ef6\u4e0b\u8f7d\uff0c\u5220\u9664\u660e\u6587\u6587\u4ef6\u5931\u8d25\uff0cpath = {}", (Object)path, (Object)e);
                    }
                }
            }
        }
    }

    public ApiResponse<Object> deleteFile(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isNotEmpty((Object)attachmentManagerModel)) {
            Long id = attachmentManagerModel.getId();
            String suffix = this.getSuffix(attachmentManagerModel.getAttachmentName());
            String fileSavePath = attachmentManagerModel.getAttachmentDir() + id + suffix;
            try {
                this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(fileSavePath)).build());
            }
            catch (Exception e) {
                logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
                throw new HussarException(OssExceptionEnum.MINIO_DELETE_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_DELETE_EXCEPTION.getMessage());
            }
            this.removeById(id);
        }
        return ApiResponse.success((String)MultiLangUtil.trans((String)"\u5220\u9664\u6210\u529f", (String)"\u5220\u9664\u6210\u529f"));
    }

    public void showImage(HttpServletResponse response, Long id) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        response.setContentType("text/html; charset=UTF-8");
        AttachmentManagerModel image = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)image)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        if (!this.ossProperties.getSupportImageTypes().contains(image.getAttachmentType().toLowerCase())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_IMG.getExceptionCode(), OssExceptionEnum.FILE_NOT_IMG.getMessage());
        }
        response.setContentType("image/" + image.getAttachmentType());
        String path = image.getAttachmentDir() + image.getId() + this.getSuffix(image.getAttachmentName());
        FileInputStream fileInputStream = null;
        String tmpFileName = OssCascadeUtils.getRandomFileName();
        try (GetObjectResponse inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build());
             ServletOutputStream output = response.getOutputStream();){
            if (HussarUtils.isNotEmpty((Object)image.getEncrypt())) {
                File realFile = OssCascadeUtils.decryptInputStreamToFile((String)tmpFileName, (String)this.getSuffix(image.getAttachmentName()), (InputStream)inputStream, (String)image.getEncrypt());
                fileInputStream = new FileInputStream(realFile);
                IoUtil.copy((InputStream)fileInputStream, (OutputStream)output);
            } else {
                IoUtil.copy((InputStream)inputStream, (OutputStream)output);
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.MINIO_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_DOWN_EXCEPTION.getMessage());
        }
        finally {
            try {
                if (HussarUtils.isNotEmpty(fileInputStream)) {
                    fileInputStream.close();
                }
                if (HussarUtils.isNotEmpty((Object)image.getEncrypt())) {
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.tempPath((String)tmpFileName, (String)this.getSuffix(image.getAttachmentName()))));
                }
            }
            catch (IOException e) {
                logger.error("\u5206\u4fdd\uff1a\u56fe\u7247\u56de\u663e\uff0c\u5220\u9664\u89e3\u5bc6\u540e\u660e\u6587\u56fe\u7247\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public Page<AttachmentManagerModel> getAttachmentList(Page<AttachmentManagerModel> page, AttachInfoDto info) {
        if (HussarUtils.isEmpty(page)) {
            throw new HussarException(OssExceptionEnum.PAGEINFO_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.PAGEINFO_NOT_EMPTY.getMessage());
        }
        String attachmentName = info.getAttachmentName();
        LocalDateTime startDate = info.getStartDate();
        LocalDateTime endDate = info.getEndDate();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)attachmentName)) {
            queryWrapper.like(AttachmentManagerModel::getAttachmentName, (Object)attachmentName);
        }
        if (HussarUtils.isNotEmpty((Object)startDate)) {
            queryWrapper.ge(AttachmentManagerModel::getUploadDate, (Object)startDate);
        }
        if (HussarUtils.isNotEmpty((Object)endDate)) {
            queryWrapper.le(AttachmentManagerModel::getUploadDate, (Object)endDate);
        }
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    public ApiResponse<Long> backgroundUpload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossMinioProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        fileInfoDto.setFileSize(Long.valueOf(file.getSize()));
        AttachmentManagerModel attachmentManagerModel = this.saveFileManager(null, fileInfoDto);
        Long id = attachmentManagerModel.getId();
        String path = fileSavePath + id + suffix;
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).stream(file.getInputStream(), -1L, 0xA00000L).build());
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getMessage());
        }
        return ApiResponse.success((Object)id);
    }

    public ApiResponse<Long> backgroundUploadWithAddition(MultipartFile file, String additionContext) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        if (HussarUtils.isEmpty((Object)additionContext)) {
            return this.backgroundUpload(file);
        }
        try {
            FileAddition addition = (FileAddition)JsonUtil.parse((String)additionContext, FileAddition.class);
            AttachmentManagerModelVo vo = this.packageAttachmentVo(file, null, addition.getSecurityLevel(), addition.getSeq());
            return ApiResponse.success((Object)vo.getId());
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getMessage());
        }
    }

    public ApiResponse<Boolean> isExist(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir() + file.getId() + this.getSuffix(file.getAttachmentName());
        StatObjectArgs args = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build();
        try {
            this.minioClient.statObject(args);
        }
        catch (Exception e) {
            return ApiResponse.success((Object)Boolean.FALSE);
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    /*
     * Exception decompiling
     */
    public ApiResponse<byte[]> backgroundDownload(Long id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RangeDownloadVO rangeDownload(AttachmentManagerModel attachmentModel, Long start, Long end) {
        String path = attachmentModel.getAttachmentDir() + attachmentModel.getId() + this.getSuffix(attachmentModel.getAttachmentName());
        try {
            GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).offset(start)).length(Long.valueOf(end - start + 1L))).build();
            GetObjectResponse response = this.minioClient.getObject(args);
            return new RangeDownloadVO(Long.valueOf(this.getInstanceLength(response.headers())), IoUtil.readToByteArray((InputStream)response));
        }
        catch (Exception e) {
            logger.error("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new HussarException(MultiLangUtil.trans((String)"\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (String)"\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38"));
        }
    }

    private AttachmentManagerModelVo getAttachmentVoById(Long id) {
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return null;
        }
        String fileName = attachmentModel.getAttachmentName();
        String path = attachmentModel.getAttachmentDir() + id + this.getSuffix(fileName);
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        BeanUtil.copy((Object)attachmentModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        if (HussarUtils.isNotEmpty((Object)attachmentModel.getAttachmentSize())) {
            attachmentManagerModelVo.setBytes(String.valueOf(attachmentModel.getAttachmentSize()));
        } else {
            try (GetObjectResponse stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build());){
                attachmentManagerModelVo.setBytes(stream.headers().get("Content-Length"));
            }
            catch (Exception e) {
                logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
                throw new HussarException(OssExceptionEnum.MINIO_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_DOWN_EXCEPTION.getMessage());
            }
        }
        return attachmentManagerModelVo;
    }

    public AttachmentManagerModelVo packageAttachmentVo(MultipartFile multipartFile, Long businessId, String securityLevel, String seq) throws Exception {
        String fileName = multipartFile.getOriginalFilename();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossMinioProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        fileInfoDto.setFileSize(Long.valueOf(multipartFile.getSize()));
        fileInfoDto.setSecurityLevel(securityLevel);
        fileInfoDto.setSeq(seq);
        Long id = this.seqBuilder.build().nextValue();
        fileInfoDto.setFileId(id);
        InputStream inputStream = multipartFile.getInputStream();
        if (HussarUtils.isNotEmpty((Object)securityLevel) || this.ossProperties.getDefaultEncrypt().booleanValue()) {
            FileEncryptVo fileEncryptVo = OssCascadeUtils.encryptFileToInputStream((Long)id, (String)suffix, (MultipartFile)multipartFile);
            fileInfoDto.setEncryptKey(fileEncryptVo.getEncryptKey());
            inputStream = fileEncryptVo.getEncryptInputStream();
        }
        AttachmentManagerModel attachmentManagerModel = this.saveFileManager(businessId, fileInfoDto);
        String path = fileSavePath + attachmentManagerModel.getId() + suffix;
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).stream(inputStream, -1L, 0xA00000L).build());
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (HussarUtils.isNotEmpty((Object)fileInfoDto.getEncryptKey())) {
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.encryptFileTempPath((Long)id, (String)suffix)));
                }
            }
            catch (IOException e) {
                logger.error("\u5206\u4fdd: \u6587\u4ef6\u4e0a\u4f20\u7ed3\u675f\u540e\uff0c\u5220\u9664\u672c\u5730\u52a0\u5bc6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
        BeanUtil.copy((Object)attachmentManagerModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        attachmentManagerModelVo.setBytes(String.valueOf(fileInfoDto.getFileSize()));
        return attachmentManagerModelVo;
    }

    private byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    private boolean doesFolderExist(String bucketName, String objectName) {
        try {
            String folderPath = objectName.endsWith("/") ? objectName : objectName + "/";
            this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(folderPath)).build());
            return true;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().code().equals("NoSuchKey")) {
                return false;
            }
            throw new HussarException(OssExceptionEnum.MINIO_GETFOLDER_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_GETFOLDER_EXCEPTION.getMessage());
        }
        catch (Exception e) {
            throw new HussarException(OssExceptionEnum.MINIO_GETFOLDER_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_GETFOLDER_EXCEPTION.getMessage());
        }
    }

    private void createFolder(String bucketName, String folderName) {
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(folderName)).stream((InputStream)new ByteArrayInputStream(new byte[0]), 0L, -1L).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(OssExceptionEnum.MINIO_CREATEFOLDER_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_CREATEFOLDER_EXCEPTION.getMessage());
        }
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private GetObjectArgs getObjectArgs(AttachmentManagerModel file) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir() + file.getId() + this.getSuffix(file.getAttachmentName());
        return (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build();
    }

    private GetObjectArgs getObjectArgs(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir() + file.getId() + this.getSuffix(file.getAttachmentName());
        return (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build();
    }

    private long getInstanceLength(Headers headers) {
        int pos;
        String contentRange = headers.get("Content-Range");
        if (contentRange != null && (pos = contentRange.lastIndexOf("/")) >= 0) {
            return Long.parseLong(contentRange.substring(pos + 1));
        }
        String contentLength = headers.get("Content-Length");
        return HussarUtils.isNotEmpty((Object)contentLength) ? Long.parseLong(contentLength) : -1L;
    }
}

