/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.plugin.minio.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.dao.AttachmentManagerMapper;
import com.jxdinfo.hussar.support.oss.core.support.dto.AttachInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.dto.FileInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.util.CheckUploadFileUtils;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.oss.plugin.minio.properties.OssMinioProperties;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.messages.Item;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class MinioAttachmentManagerServiceImpl
extends HussarServiceImpl<AttachmentManagerMapper, AttachmentManagerModel>
implements AttachmentManagerService {
    private final OssMinioProperties ossMinioProperties;
    private final GetLoginUserService getLoginUserService;
    private final MinioClient minioClient;
    @Resource
    private OssProperties ossProperties;
    private static Logger logger = LogManager.getLogger(MinioAttachmentManagerServiceImpl.class);

    public MinioAttachmentManagerServiceImpl(OssMinioProperties ossMinioProperties, GetLoginUserService getLoginUserService, MinioClient minioClient) {
        this.ossMinioProperties = ossMinioProperties;
        this.getLoginUserService = getLoginUserService;
        this.minioClient = minioClient;
        try {
            boolean found = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(ossMinioProperties.getBucketName())).build());
            if (!found) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(ossMinioProperties.getBucketName())).build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(OssExceptionEnum.MINIO_CREATEBUCKET_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_CREATEBUCKET_EXCEPTION.getMessage());
        }
    }

    public Long saveAttachment(AttachmentManagerModel attachmentManagerModel) {
        this.save((BaseEntity)attachmentManagerModel);
        return attachmentManagerModel.getId();
    }

    public String findDirById(Long id) {
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentManagerModel)) {
            return "";
        }
        return attachmentManagerModel.getAttachmentDir();
    }

    public AttachmentManagerModelVo getByFileId(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        return this.getAttachmentVoById(fileId);
    }

    public List<AttachmentManagerModelVo> getByFileIds(String[] fileIds) {
        ArrayList<AttachmentManagerModelVo> attachmentManagerModelVos = new ArrayList<AttachmentManagerModelVo>();
        if (HussarUtils.isEmpty((Object[])fileIds)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        for (String fileId : fileIds) {
            if (!HussarUtils.isNotEmpty((Object)fileId)) continue;
            attachmentManagerModelVos.add(this.getAttachmentVoById(Long.parseLong(fileId)));
        }
        return attachmentManagerModelVos;
    }

    public ApiResponse<String> upload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file) || HussarUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties);
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fName = IdWorker.get32UUID() + suffix;
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(this.ossMinioProperties.getFileUploadPath() + fName)).stream(file.getInputStream(), -1L, 0xA00000L).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getMessage());
        }
        return ApiResponse.success((String)fName);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        multipartRequest.setCharacterEncoding("UTF-8");
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)iterator.next();
        }
        if (HussarUtils.isNotEmpty(multipartFile)) {
            CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
            attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId);
        }
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartFile multipartFile, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartFile)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
        return ApiResponse.success((Object)this.packageAttachmentVo(multipartFile, businessId));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<AttachmentManagerModelVo> uploadMultipleFile(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        ArrayList<AttachmentManagerModelVo> voList = new ArrayList<AttachmentManagerModelVo>();
        multipartRequest.setCharacterEncoding("UTF-8");
        Map map = multipartRequest.getFileMap();
        if (HussarUtils.isNotEmpty((Object)map)) {
            map.values().forEach(file -> CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties));
        }
        for (MultipartFile file2 : map.values()) {
            MultipartFile multipartFile = file2;
            if (!HussarUtils.isNotEmpty((Object)multipartFile)) continue;
            AttachmentManagerModelVo attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId);
            voList.add(attachmentManagerModelVo);
        }
        return voList;
    }

    public void fileDownload(HttpServletResponse response, Long fileId) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return;
        }
        String fileName = attachmentModel.getAttachmentName();
        String path = attachmentModel.getAttachmentDir() + attachmentModel.getId() + this.getSuffix(fileName);
        GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build();
        try (GetObjectResponse stream = this.minioClient.getObject(args);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            IoUtil.copy((InputStream)stream, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.MINIO_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_DOWN_EXCEPTION.getMessage());
        }
    }

    public void batchDownload(String ids, HttpServletResponse response) throws ServletException, IOException {
        if (HussarUtils.isEmpty((Object)ids) || HussarUtils.isEmpty((Object)response)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        ServletOutputStream os = response.getOutputStream();
        ArrayList fileIdList = new ArrayList();
        Arrays.stream(ids.split(",")).forEach(s -> {
            if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                fileIdList.add(Long.parseLong(s));
            }
        });
        List attachList = this.listByIds(fileIdList);
        try (InputStream inputStream = null;
             ZipOutputStream zos = new ZipOutputStream((OutputStream)os);){
            String sourceFilePath = "\u6279\u91cf\u4e0b\u8f7d.zip";
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(sourceFilePath, "UTF-8"));
            int count = 0;
            for (AttachmentManagerModel attach : attachList) {
                Long id = attach.getId();
                String fileName = attach.getAttachmentName();
                String path = attach.getAttachmentDir() + id + this.getSuffix(fileName);
                inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build());
                ZipEntry zipEntry = new ZipEntry(++count + "-" + fileName);
                zos.putNextEntry(zipEntry);
                IoUtil.copy((InputStream)inputStream, (OutputStream)zos);
            }
        }
    }

    public ApiResponse<Object> deleteFile(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isNotEmpty((Object)attachmentManagerModel)) {
            Long id = attachmentManagerModel.getId();
            String suffix = this.getSuffix(attachmentManagerModel.getAttachmentName());
            String fileSavePath = attachmentManagerModel.getAttachmentDir() + id + suffix;
            try {
                this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(fileSavePath)).build());
            }
            catch (Exception e) {
                logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
                throw new HussarException(OssExceptionEnum.MINIO_DELETE_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_DELETE_EXCEPTION.getMessage());
            }
            this.removeById(id);
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public void showImage(HttpServletResponse response, Long id) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        response.setContentType("text/html; charset=UTF-8");
        AttachmentManagerModel image = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)image)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        if (!"gif,jpg,jpeg,bmp,png".contains(image.getAttachmentType().toLowerCase())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_IMG.getExceptionCode(), OssExceptionEnum.FILE_NOT_IMG.getMessage());
        }
        response.setContentType("image/" + image.getAttachmentType());
        String path = image.getAttachmentDir() + image.getId() + this.getSuffix(image.getAttachmentName());
        try {
            GetObjectResponse inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build());
            ServletOutputStream output = response.getOutputStream();
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(image.getAttachmentName(), "UTF-8"));
            response.setCharacterEncoding("UTF-8");
            IoUtil.copy((InputStream)inputStream, (OutputStream)output);
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.MINIO_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_DOWN_EXCEPTION.getMessage());
        }
    }

    public Page<AttachmentManagerModel> getAttachmentList(Page<AttachmentManagerModel> page, AttachInfoDto info) {
        if (HussarUtils.isEmpty(page)) {
            throw new HussarException(OssExceptionEnum.PAGEINFO_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.PAGEINFO_NOT_EMPTY.getMessage());
        }
        String attachmentName = info.getAttachmentName();
        LocalDateTime startDate = info.getStartDate();
        LocalDateTime endDate = info.getEndDate();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)attachmentName)) {
            queryWrapper.like(AttachmentManagerModel::getAttachmentName, (Object)attachmentName);
        }
        if (HussarUtils.isNotEmpty((Object)startDate)) {
            queryWrapper.ge(AttachmentManagerModel::getUploadDate, (Object)startDate);
        }
        if (HussarUtils.isNotEmpty((Object)endDate)) {
            queryWrapper.le(AttachmentManagerModel::getUploadDate, (Object)endDate);
        }
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    public ApiResponse<Long> backgroundUpload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossMinioProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        AttachmentManagerModel attachmentManagerModel = this.saveFileManager(null, fileInfoDto);
        Long id = attachmentManagerModel.getId();
        String path = fileSavePath + id + suffix;
        try {
            if (!this.doesFolderExist(this.ossMinioProperties.getBucketName(), fileSavePath)) {
                this.createFolder(this.ossMinioProperties.getBucketName(), fileSavePath);
            }
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).stream(file.getInputStream(), -1L, 0xA00000L).build());
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getMessage());
        }
        return ApiResponse.success((Object)id);
    }

    public ApiResponse<Boolean> isExist(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir() + file.getId() + this.getSuffix(file.getAttachmentName());
        StatObjectArgs args = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build();
        try {
            this.minioClient.statObject(args);
        }
        catch (Exception e) {
            return ApiResponse.success((Object)Boolean.FALSE);
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<byte[]> backgroundDownload(Long id) {
        GetObjectArgs args = this.getObjectArgs(id);
        try (GetObjectResponse inputStream = this.minioClient.getObject(args);){
            ApiResponse apiResponse = ApiResponse.success((Object)IoUtil.readToByteArray((InputStream)inputStream));
            return apiResponse;
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.MINIO_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_DOWN_EXCEPTION.getMessage());
        }
    }

    private AttachmentManagerModel saveFileManager(Long businessId, FileInfoDto fileInfoDto) {
        AttachmentManagerModel attachment = new AttachmentManagerModel();
        attachment.setBusinessId(businessId);
        attachment.setAttachmentName(fileInfoDto.getFileName());
        attachment.setAttachmentType(fileInfoDto.getSuffix().replace(".", ""));
        UserDetails user = this.getLoginUserService.getCurrentUserDetail();
        if (user != null) {
            attachment.setUploadPer(user.getUserId());
        }
        attachment.setAttachmentDir(fileInfoDto.getFileSavePath());
        attachment.setUploadDate(LocalDateTime.now());
        this.save((BaseEntity)attachment);
        return attachment;
    }

    private AttachmentManagerModelVo getAttachmentVoById(Long id) {
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return null;
        }
        String fileName = attachmentModel.getAttachmentName();
        String path = attachmentModel.getAttachmentDir() + id + this.getSuffix(fileName);
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        try (GetObjectResponse stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build());){
            BeanUtil.copy((Object)attachmentModel, (Object)attachmentManagerModelVo);
            attachmentManagerModelVo.setFileName(fileName);
            attachmentManagerModelVo.setPath(path);
            attachmentManagerModelVo.setBytes(String.valueOf(this.toByteArray((InputStream)stream).length));
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.MINIO_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_DOWN_EXCEPTION.getMessage());
        }
        return attachmentManagerModelVo;
    }

    public AttachmentManagerModelVo packageAttachmentVo(MultipartFile multipartFile, Long businessId) throws Exception {
        String fileName = multipartFile.getOriginalFilename();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossMinioProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        AttachmentManagerModel attachmentManagerModel = this.saveFileManager(businessId, fileInfoDto);
        String path = fileSavePath + attachmentManagerModel.getId() + suffix;
        try {
            if (!this.doesFolderExist(this.ossMinioProperties.getBucketName(), fileSavePath)) {
                this.createFolder(this.ossMinioProperties.getBucketName(), fileSavePath);
            }
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).stream(multipartFile.getInputStream(), -1L, 0xA00000L).build());
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getMessage());
        }
        BeanUtil.copy((Object)attachmentManagerModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        attachmentManagerModelVo.setBytes(String.valueOf(multipartFile.getSize()));
        return attachmentManagerModelVo;
    }

    private byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    private boolean doesFolderExist(String bucketName, String objectName) {
        boolean exist = false;
        try {
            Iterable results = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(objectName).recursive(false).build());
            for (Result result : results) {
                Item item = (Item)result.get();
                if (!item.isDir() || !objectName.equals(item.objectName())) continue;
                exist = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(OssExceptionEnum.MINIO_GETFOLDER_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_GETFOLDER_EXCEPTION.getMessage());
        }
        return exist;
    }

    private void createFolder(String bucketName, String folderName) {
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(folderName)).stream((InputStream)new ByteArrayInputStream(new byte[0]), 0L, -1L).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(OssExceptionEnum.MINIO_CREATEFOLDER_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_CREATEFOLDER_EXCEPTION.getMessage());
        }
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private GetObjectArgs getObjectArgs(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir() + file.getId() + this.getSuffix(file.getAttachmentName());
        return (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossMinioProperties.getBucketName())).object(path)).build();
    }
}

