/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.plugin.minio.config;

import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.support.oss.plugin.minio.controller.MinIoAttachmentController;
import com.jxdinfo.hussar.support.oss.plugin.minio.properties.OssMinioProperties;
import com.jxdinfo.hussar.support.oss.plugin.minio.support.service.impl.CustomizeMinioAttachmentManagerServiceImpl;
import com.jxdinfo.hussar.support.oss.plugin.minio.support.service.impl.MinIoServiceImpl;
import io.minio.MinioClient;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OssMinioProperties.class})
@ConditionalOnProperty(prefix="hussar.oss", name={"oss-type"}, havingValue="minio-customize")
@MapperScan(value={"com.jxdinfo.hussar.support.oss.plugin.minio.dao"})
public class CustomizeMinioConfiguration {
    @Bean
    public CustomizeMinioAttachmentManagerServiceImpl attachmentManagerService(OssMinioProperties ossMinioProperties, GetLoginUserService getLoginUserService) {
        MinioClient minioClient = MinioClient.builder().endpoint(ossMinioProperties.getUrl()).credentials(ossMinioProperties.getAccessKey(), ossMinioProperties.getSecretKey()).build();
        return new CustomizeMinioAttachmentManagerServiceImpl(ossMinioProperties, getLoginUserService, minioClient);
    }

    @Bean
    public MinIoServiceImpl attachmentService() {
        return new MinIoServiceImpl();
    }

    @Bean
    public MinIoAttachmentController customizeAttachmentController() {
        return new MinIoAttachmentController();
    }
}

