/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.plugin.file.customize.properties;

import com.jxdinfo.hussar.platform.core.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="hussar.oss.file")
public class OssCustomizeFileProperties {
    public static final String PREFIX = "hussar.oss.file";
    private Boolean dateSplit = Boolean.TRUE;
    private String uploadPathWindows = "";
    private String uploadPathMac = "";
    private String uploadPathLinux = "";

    public Boolean getDateSplit() {
        return this.dateSplit;
    }

    public void setDateSplit(Boolean dateSplit) {
        this.dateSplit = dateSplit;
    }

    public String getUploadPathWindows() {
        return this.uploadPathWindows;
    }

    public void setUploadPathWindows(String uploadPathWindows) {
        this.uploadPathWindows = uploadPathWindows;
    }

    public String getUploadPathMac() {
        return this.uploadPathMac;
    }

    public void setUploadPathMac(String uploadPathMac) {
        this.uploadPathMac = uploadPathMac;
    }

    public String getUploadPathLinux() {
        return this.uploadPathLinux;
    }

    public void setUploadPathLinux(String uploadPathLinux) {
        this.uploadPathLinux = uploadPathLinux;
    }

    public String getFileUploadPath() {
        File file;
        String fileUploadPath = "";
        boolean fileDateSplit = this.getDateSplit();
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        if (os != null && os.toLowerCase().contains("linux")) {
            fileUploadPath = this.uploadPathLinux;
        } else if (os != null && os.toLowerCase().contains("windows")) {
            fileUploadPath = this.uploadPathWindows;
        } else if (os != null && os.toLowerCase().contains("mac")) {
            fileUploadPath = this.uploadPathMac;
        }
        if (HussarUtils.isEmpty((Object)fileUploadPath)) {
            fileUploadPath = FileUtil.getTempDirPath();
        }
        if (fileDateSplit) {
            String datePath = new SimpleDateFormat("yyyy/MM/dd").format(new Date()).replace("/", File.separator);
            fileUploadPath = fileUploadPath + File.separator + datePath;
        }
        if (!fileUploadPath.endsWith(File.separator)) {
            fileUploadPath = fileUploadPath + File.separator;
        }
        if (!(file = new File(fileUploadPath)).exists()) {
            file.mkdirs();
        }
        return fileUploadPath;
    }
}

