/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.plugin.fastdfs.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.tobato.fastdfs.domain.fdfs.FileInfo;
import com.github.tobato.fastdfs.domain.fdfs.StorePath;
import com.github.tobato.fastdfs.domain.proto.storage.DownloadByteArray;
import com.github.tobato.fastdfs.domain.proto.storage.DownloadCallback;
import com.github.tobato.fastdfs.domain.proto.storage.DownloadFileStream;
import com.github.tobato.fastdfs.exception.FdfsServerException;
import com.github.tobato.fastdfs.service.FastFileStorageClient;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.platform.core.utils.lang.MultiLangUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.dao.AttachmentManagerMapper;
import com.jxdinfo.hussar.support.oss.core.support.dto.AttachInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.dto.FileInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.entity.FileAddition;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.util.CheckUploadFileUtils;
import com.jxdinfo.hussar.support.oss.core.support.util.OssCascadeUtils;
import com.jxdinfo.hussar.support.oss.core.support.util.OssEncoderUtils;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.oss.core.support.vo.FileEncryptVo;
import com.jxdinfo.hussar.support.oss.core.support.vo.RangeDownloadVO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@HussarDs(value="master")
public class FastdfsAttachmentManagerServiceImpl
extends HussarServiceImpl<AttachmentManagerMapper, AttachmentManagerModel>
implements AttachmentManagerService {
    private final FastFileStorageClient storageClient;
    private final GetLoginUserService getLoginUserService;
    @Autowired
    private OssProperties ossProperties;
    @Resource
    private SeqBuilder seqBuilder;
    private static final Logger logger = LogManager.getLogger(FastdfsAttachmentManagerServiceImpl.class);

    public FastdfsAttachmentManagerServiceImpl(FastFileStorageClient storageClient, GetLoginUserService getLoginUserService) {
        this.storageClient = storageClient;
        this.getLoginUserService = getLoginUserService;
    }

    public Long saveAttachment(AttachmentManagerModel attachmentManagerModel) {
        this.save((BaseEntity)attachmentManagerModel);
        return attachmentManagerModel.getId();
    }

    public String findDirById(Long id) {
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentManagerModel)) {
            return "";
        }
        return attachmentManagerModel.getAttachmentDir();
    }

    public AttachmentManagerModelVo getByFileId(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        return this.getAttachmentVoById(fileId);
    }

    public List<AttachmentManagerModelVo> getByFileIds(String[] fileIds) {
        ArrayList<AttachmentManagerModelVo> attachmentManagerModelVos = new ArrayList<AttachmentManagerModelVo>();
        if (HussarUtils.isEmpty((Object[])fileIds)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        for (String fileId : fileIds) {
            if (!HussarUtils.isNotEmpty((Object)fileId)) continue;
            attachmentManagerModelVos.add(this.getAttachmentVoById(Long.parseLong(fileId)));
        }
        return attachmentManagerModelVos;
    }

    public ApiResponse<String> upload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file) || HussarUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties);
        String fileName = file.getOriginalFilename();
        String suffix = CheckUploadFileUtils.getExtension((String)fileName);
        String fName = IdWorker.get32UUID() + suffix;
        try {
            this.storageClient.uploadFile(file.getInputStream(), file.getSize(), suffix, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getMessage());
        }
        return ApiResponse.success((String)fName);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String securityLevel = multipartRequest.getParameter("securityLevel");
        String seq = multipartRequest.getParameter("seq");
        multipartRequest.setCharacterEncoding("UTF-8");
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)iterator.next();
        }
        if (HussarUtils.isNotEmpty(multipartFile)) {
            CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
            attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId, securityLevel, seq);
        }
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartFile multipartFile, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartFile)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
        return ApiResponse.success((Object)this.packageAttachmentVo(multipartFile, businessId, null, null));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<AttachmentManagerModelVo> uploadMultipleFile(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        ArrayList<AttachmentManagerModelVo> voList = new ArrayList<AttachmentManagerModelVo>();
        String securityLevel = multipartRequest.getParameter("securityLevel");
        String seq = multipartRequest.getParameter("seq");
        multipartRequest.setCharacterEncoding("UTF-8");
        Map map = multipartRequest.getFileMap();
        if (HussarUtils.isNotEmpty((Object)map)) {
            map.values().forEach(file -> CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties));
        }
        for (MultipartFile file2 : map.values()) {
            MultipartFile multipartFile = file2;
            if (!HussarUtils.isNotEmpty((Object)multipartFile)) continue;
            AttachmentManagerModelVo attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId, securityLevel, seq);
            voList.add(attachmentManagerModelVo);
        }
        return voList;
    }

    public void fileDownload(HttpServletResponse response, Long fileId) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = attachmentModel.getAttachmentName();
        String path = attachmentModel.getAttachmentDir();
        FileInputStream fileInputStream = null;
        String tmpFileName = OssCascadeUtils.getRandomFileName();
        try (BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            response.reset();
            response.addHeader("Content-Disposition", OssEncoderUtils.buildContentDisposition((String)fileName));
            response.setContentType("application/octet-stream");
            FileInfo fileInfo = this.getFileInfo(path);
            long fileSize = fileInfo.getFileSize();
            response.setContentLengthLong(fileSize);
            if (HussarUtils.isNotEmpty((Object)attachmentModel.getEncrypt())) {
                byte[] bytes = this.downFileByPath(path);
                File realFile = OssCascadeUtils.decryptInputStreamToFile((String)tmpFileName, (String)CheckUploadFileUtils.getExtension((String)fileName), (InputStream)new ByteArrayInputStream(bytes), (String)attachmentModel.getEncrypt());
                response.setContentLengthLong(realFile.length());
                fileInputStream = new FileInputStream(realFile);
                IoUtil.copy((InputStream)fileInputStream, (OutputStream)out);
            } else {
                this.downStreamByPath(path, out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)attachmentModel.getEncrypt())) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.tempPath((String)tmpFileName, (String)CheckUploadFileUtils.getExtension((String)fileName))));
                }
                catch (IOException e) {
                    logger.error("\u5206\u4fdd: \u6587\u4ef6\u4e0b\u8f7d\u540e\u5220\u9664\u672c\u5730\u5b58\u50a8\u7684\u660e\u6587\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public void batchDownload(String ids, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, String> files = new HashMap<String, String>();
        Arrays.stream(ids.split(",")).forEach(s -> {
            if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                files.put((String)s, (String)null);
            }
        });
        this.downloadZipfile(files, null, response);
    }

    public void batchDownloadByMaps(Map<String, String> files, String zipName, HttpServletResponse response) throws ServletException, IOException {
        this.downloadZipfile(files, zipName, response);
    }

    private void downloadZipfile(Map<String, String> files, String zipName, HttpServletResponse response) throws ServletException, IOException {
        if (HussarUtils.isEmpty(files) || HussarUtils.isEmpty((Object)response)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        ServletOutputStream os = response.getOutputStream();
        ArrayList<Long> fileIdList = new ArrayList<Long>();
        for (Map.Entry<String, String> entry : files.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            fileIdList.add(Long.parseLong(key));
        }
        List attachList = this.listByIds(fileIdList);
        ArrayList<String> needDeleteFilePaths = new ArrayList<String>();
        FileInputStream fileInputStream = null;
        String tmpFileName = OssCascadeUtils.getRandomFileName();
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)os);){
            String sourceFilePath = "\u6279\u91cf\u4e0b\u8f7d.zip";
            if (StringUtil.isNotEmpty((Object)zipName)) {
                sourceFilePath = zipName + ".zip";
            }
            response.setHeader("Content-Disposition", OssEncoderUtils.buildContentDisposition((String)sourceFilePath));
            response.setContentType("application/octet-stream");
            HashMap<String, Map> dirCounters = new HashMap<String, Map>();
            for (AttachmentManagerModel attach : attachList) {
                Long id = attach.getId();
                String fileName = attach.getAttachmentName();
                String path = attach.getAttachmentDir();
                String folderName = files.get(Long.toString(id));
                String normalizedDir = StringUtil.isEmptyIfStr((Object)folderName) ? "" : OssCascadeUtils.formatDirectoryPath((String)folderName);
                Map counterMap = dirCounters.computeIfAbsent(normalizedDir, k -> new HashMap());
                int fileNameCount = counterMap.getOrDefault(fileName, 0);
                String uniqueName = fileNameCount == 0 ? fileName : OssCascadeUtils.generateCountedName((String)fileName, (int)fileNameCount);
                counterMap.put(fileName, fileNameCount + 1);
                String entryPath = normalizedDir.isEmpty() ? uniqueName : normalizedDir + uniqueName;
                ZipEntry zipEntry = new ZipEntry(entryPath);
                zos.putNextEntry(zipEntry);
                if (HussarUtils.isNotEmpty((Object)attach.getEncrypt())) {
                    String suffix = CheckUploadFileUtils.getExtension((String)fileName);
                    byte[] bytes = this.downFileByPath(path);
                    File realFile = OssCascadeUtils.decryptInputStreamToFile((String)tmpFileName, (String)suffix, (InputStream)new ByteArrayInputStream(bytes), (String)attach.getEncrypt());
                    fileInputStream = new FileInputStream(realFile);
                    IoUtil.copy((InputStream)fileInputStream, (OutputStream)zos);
                    needDeleteFilePaths.add(OssCascadeUtils.tempPath((String)tmpFileName, (String)suffix));
                    continue;
                }
                this.downStreamByPath(path, zos);
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
        finally {
            if (HussarUtils.isNotEmpty(needDeleteFilePaths)) {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                for (String path : needDeleteFilePaths) {
                    try {
                        FileUtils.forceDelete((File)new File(path));
                    }
                    catch (IOException e) {
                        logger.error("\u5206\u4fdd: \u591a\u6587\u4ef6\u4e0b\u8f7d\uff0c\u5220\u9664\u660e\u6587\u6587\u4ef6\u5931\u8d25\uff0cpath = {}", (Object)path, (Object)e);
                    }
                }
            }
        }
    }

    public ApiResponse<Object> deleteFile(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isNotEmpty((Object)attachmentManagerModel)) {
            Long id = attachmentManagerModel.getId();
            String fileSavePath = attachmentManagerModel.getAttachmentDir();
            try {
                this.storageClient.deleteFile(fileSavePath);
            }
            catch (Exception e) {
                logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
                throw new HussarException(OssExceptionEnum.FAST_DELETE_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DELETE_EXCEPTION.getMessage());
            }
            this.removeById(id);
        }
        return ApiResponse.success((String)MultiLangUtil.trans((String)"\u5220\u9664\u6210\u529f", (String)"\u5220\u9664\u6210\u529f"));
    }

    public void showImage(HttpServletResponse response, Long id) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        response.setContentType("text/html; charset=UTF-8");
        AttachmentManagerModel image = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)image)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        if (!this.ossProperties.getSupportImageTypes().contains(image.getAttachmentType().toLowerCase())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_IMG.getExceptionCode(), OssExceptionEnum.FILE_NOT_IMG.getMessage());
        }
        response.setContentType("image/" + image.getAttachmentType());
        String path = image.getAttachmentDir();
        FileInputStream fileInputStream = null;
        String tmpFileName = OssCascadeUtils.getRandomFileName();
        try (ServletOutputStream output = response.getOutputStream();){
            if (HussarUtils.isNotEmpty((Object)image.getEncrypt())) {
                String suffix = CheckUploadFileUtils.getExtension((String)image.getAttachmentName());
                byte[] bytes = this.downFileByPath(path);
                File realFile = OssCascadeUtils.decryptInputStreamToFile((String)tmpFileName, (String)suffix, (InputStream)new ByteArrayInputStream(bytes), (String)image.getEncrypt());
                fileInputStream = new FileInputStream(realFile);
                IoUtil.copy((InputStream)fileInputStream, (OutputStream)output);
            } else {
                this.downStreamByPath(path, (OutputStream)output);
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (HussarUtils.isNotEmpty((Object)image.getEncrypt())) {
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.tempPath((String)tmpFileName, (String)CheckUploadFileUtils.getExtension((String)image.getAttachmentName()))));
                }
            }
            catch (IOException e) {
                logger.error("\u5206\u4fdd\uff1a\u56fe\u7247\u56de\u663e\uff0c\u5220\u9664\u89e3\u5bc6\u540e\u660e\u6587\u56fe\u7247\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public Page<AttachmentManagerModel> getAttachmentList(Page<AttachmentManagerModel> page, AttachInfoDto info) {
        if (HussarUtils.isEmpty(page)) {
            throw new HussarException(OssExceptionEnum.PAGEINFO_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.PAGEINFO_NOT_EMPTY.getMessage());
        }
        String attachmentName = info.getAttachmentName();
        LocalDateTime startDate = info.getStartDate();
        LocalDateTime endDate = info.getEndDate();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)attachmentName)) {
            queryWrapper.like(AttachmentManagerModel::getAttachmentName, (Object)attachmentName);
        }
        if (HussarUtils.isNotEmpty((Object)startDate)) {
            queryWrapper.ge(AttachmentManagerModel::getUploadDate, (Object)startDate);
        }
        if (HussarUtils.isNotEmpty((Object)endDate)) {
            queryWrapper.le(AttachmentManagerModel::getUploadDate, (Object)endDate);
        }
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    public ApiResponse<Long> backgroundUpload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = file.getOriginalFilename();
        String suffix = CheckUploadFileUtils.getExtension((String)fileName);
        try {
            StorePath storePath = this.storageClient.uploadFile(file.getInputStream(), file.getSize(), suffix, null);
            String fileSavePath = storePath.getFullPath();
            FileInfoDto fileInfoDto = new FileInfoDto();
            fileInfoDto.setFileName(fileName);
            fileInfoDto.setFileSavePath(fileSavePath);
            fileInfoDto.setSuffix(suffix);
            fileInfoDto.setFileSize(Long.valueOf(file.getSize()));
            AttachmentManagerModel attachmentManagerModel = this.saveFileManager(null, fileInfoDto);
            Long id = attachmentManagerModel.getId();
            return ApiResponse.success((Object)id);
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getMessage());
        }
    }

    public ApiResponse<Long> backgroundUploadWithAddition(MultipartFile file, String additionContext) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        if (HussarUtils.isEmpty((Object)additionContext)) {
            return this.backgroundUpload(file);
        }
        FileAddition addition = (FileAddition)JsonUtil.parse((String)additionContext, FileAddition.class);
        try {
            AttachmentManagerModelVo vo = this.packageAttachmentVo(file, null, addition.getSecurityLevel(), addition.getSeq());
            return ApiResponse.success((Object)vo.getId());
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getMessage());
        }
    }

    public ApiResponse<Boolean> isExist(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir();
        boolean flag = false;
        try {
            StorePath storePath = StorePath.parseFromUrl((String)path);
            FileInfo fileInfo = this.storageClient.queryFileInfo(storePath.getGroup(), storePath.getPath());
            if (HussarUtils.isNotEmpty((Object)fileInfo) && HussarUtils.isNotEmpty((Object)fileInfo.getSourceIpAddr())) {
                flag = true;
            }
        }
        catch (FdfsServerException e) {
            if (e.getErrorCode() != 2) {
                logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            }
            return ApiResponse.success((Object)Boolean.FALSE);
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            return ApiResponse.success((Object)Boolean.FALSE);
        }
        return ApiResponse.success((Object)flag);
    }

    public ApiResponse<byte[]> backgroundDownload(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir();
        FileInputStream fileInputStream = null;
        String tmpFileName = OssCascadeUtils.getRandomFileName();
        try {
            byte[] bytes = this.downFileByPath(path);
            if (HussarUtils.isNotEmpty((Object)file.getEncrypt())) {
                File realFile = OssCascadeUtils.decryptInputStreamToFile((String)tmpFileName, (String)CheckUploadFileUtils.getExtension((String)file.getAttachmentName()), (InputStream)new ByteArrayInputStream(bytes), (String)file.getEncrypt());
                fileInputStream = new FileInputStream(realFile);
                bytes = IOUtils.toByteArray((InputStream)fileInputStream);
            }
            ApiResponse apiResponse = ApiResponse.success((Object)bytes);
            return apiResponse;
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (HussarUtils.isNotEmpty((Object)file.getEncrypt())) {
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.tempPath((String)tmpFileName, (String)CheckUploadFileUtils.getExtension((String)file.getAttachmentName()))));
                }
            }
            catch (IOException e) {
                logger.error("\u5206\u4fdd: \u540e\u7aef\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3\uff0c\u5220\u9664\u672c\u5730\u660e\u6587\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public String backgroundDownload(Long id, OutputStream outputStream) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir();
        FileInputStream fileInputStream = null;
        String tmpFileName = OssCascadeUtils.getRandomFileName();
        try {
            byte[] bytes = this.downFileByPath(path);
            if (HussarUtils.isNotEmpty((Object)file.getEncrypt())) {
                File realFile = OssCascadeUtils.decryptInputStreamToFile((String)tmpFileName, (String)CheckUploadFileUtils.getExtension((String)file.getAttachmentName()), (InputStream)new ByteArrayInputStream(bytes), (String)file.getEncrypt());
                fileInputStream = new FileInputStream(realFile);
                IoUtil.copy((InputStream)fileInputStream, (OutputStream)outputStream);
            }
            String string = file.getAttachmentName();
            return string;
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (HussarUtils.isNotEmpty((Object)file.getEncrypt())) {
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.tempPath((String)tmpFileName, (String)CheckUploadFileUtils.getExtension((String)file.getAttachmentName()))));
                }
            }
            catch (IOException e) {
                logger.error("\u5206\u4fdd: \u540e\u7aef\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3\uff0c\u5220\u9664\u672c\u5730\u660e\u6587\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public RangeDownloadVO rangeDownload(AttachmentManagerModel attachmentModel, Long start, Long end) {
        try {
            String path = attachmentModel.getAttachmentDir();
            StorePath storePath = StorePath.parseFromUrl((String)path);
            FileInfo fileInfo = this.storageClient.queryFileInfo(storePath.getGroup(), storePath.getPath());
            long totalFileSize = fileInfo.getFileSize();
            byte[] bytes = (byte[])this.storageClient.downloadFile(storePath.getGroup(), storePath.getPath(), start.longValue(), end - start + 1L, (DownloadCallback)new DownloadByteArray());
            return new RangeDownloadVO(Long.valueOf(totalFileSize), bytes);
        }
        catch (Exception e) {
            logger.error("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new HussarException(MultiLangUtil.trans((String)"\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (String)"\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38"));
        }
    }

    private AttachmentManagerModelVo getAttachmentVoById(Long id) {
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return null;
        }
        String fileName = attachmentModel.getAttachmentName();
        String path = attachmentModel.getAttachmentDir();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        try {
            BeanUtil.copy((Object)attachmentModel, (Object)attachmentManagerModelVo);
            attachmentManagerModelVo.setFileName(fileName);
            attachmentManagerModelVo.setPath(path);
            if (HussarUtils.isNotEmpty((Object)attachmentModel.getAttachmentSize())) {
                attachmentManagerModelVo.setBytes(String.valueOf(attachmentModel.getAttachmentSize()));
            } else {
                FileInfo fileInfo = this.getFileInfo(path);
                attachmentManagerModelVo.setBytes(String.valueOf(fileInfo.getFileSize()));
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
        return attachmentManagerModelVo;
    }

    public AttachmentManagerModelVo packageAttachmentVo(MultipartFile multipartFile, Long businessId, String securityLevel, String seq) throws Exception {
        String fileName = multipartFile.getOriginalFilename();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        String suffix = CheckUploadFileUtils.getExtension((String)fileName);
        String path = "";
        AttachmentManagerModel attachmentManagerModel = new AttachmentManagerModel();
        InputStream inputStream = multipartFile.getInputStream();
        try {
            StorePath storePath;
            FileInfoDto fileInfoDto = new FileInfoDto();
            Long id = this.seqBuilder.build().nextValue();
            fileInfoDto.setFileId(id);
            fileInfoDto.setFileSize(Long.valueOf(multipartFile.getSize()));
            if (HussarUtils.isNotEmpty((Object)securityLevel) || this.ossProperties.getDefaultEncrypt().booleanValue()) {
                FileEncryptVo fileEncryptVo = OssCascadeUtils.encryptFileToInputStream((Long)id, (String)suffix, (MultipartFile)multipartFile);
                fileInfoDto.setEncryptKey(fileEncryptVo.getEncryptKey());
                File encryptFile = new File(OssCascadeUtils.encryptFileTempPath((Long)id, (String)suffix));
                inputStream = fileEncryptVo.getEncryptInputStream();
                storePath = this.storageClient.uploadFile(inputStream, encryptFile.length(), suffix, null);
            } else {
                storePath = this.storageClient.uploadFile(inputStream, multipartFile.getSize(), suffix, null);
            }
            String fileSavePath = storePath.getFullPath();
            fileInfoDto.setFileName(fileName);
            fileInfoDto.setFileSavePath(fileSavePath);
            fileInfoDto.setSuffix(suffix);
            fileInfoDto.setSecurityLevel(securityLevel);
            fileInfoDto.setSeq(seq);
            attachmentManagerModel = this.saveFileManager(businessId, fileInfoDto);
            path = fileSavePath;
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getMessage());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (HussarUtils.isNotEmpty((Object)attachmentManagerModel.getEncrypt())) {
                try {
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.encryptFileTempPath((Long)attachmentManagerModel.getId(), (String)suffix)));
                }
                catch (IOException e) {
                    logger.error("\u5206\u4fdd: \u6587\u4ef6\u4e0a\u4f20\u7ed3\u675f\u540e\uff0c\u5220\u9664\u672c\u5730\u52a0\u5bc6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                }
            }
        }
        BeanUtil.copy((Object)attachmentManagerModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        attachmentManagerModelVo.setBytes(String.valueOf(multipartFile.getSize()));
        return attachmentManagerModelVo;
    }

    private byte[] downFileByPath(String path) {
        StorePath storePath = StorePath.parseFromUrl((String)path);
        return (byte[])this.storageClient.downloadFile(storePath.getGroup(), storePath.getPath(), (DownloadCallback)new DownloadByteArray());
    }

    private FileInfo getFileInfo(String path) {
        StorePath storePath = StorePath.parseFromUrl((String)path);
        return this.storageClient.queryFileInfo(storePath.getGroup(), storePath.getPath());
    }

    private BufferedInputStream downStreamByPath(String path, OutputStream out) {
        StorePath storePath = StorePath.parseFromUrl((String)path);
        return (BufferedInputStream)this.storageClient.downloadFile(storePath.getGroup(), storePath.getPath(), (DownloadCallback)new DownloadFileStream(out, this.ossProperties.getDownloadBuffSize()));
    }
}

