/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.plugin.fastdfs.support.client;

import com.github.tobato.fastdfs.domain.conn.TrackerConnectionManager;
import com.github.tobato.fastdfs.domain.fdfs.StorageNode;
import com.github.tobato.fastdfs.domain.fdfs.StorageNodeInfo;
import com.github.tobato.fastdfs.domain.proto.FdfsCommand;
import com.github.tobato.fastdfs.domain.proto.tracker.TrackerGetFetchStorageCommand;
import com.github.tobato.fastdfs.domain.proto.tracker.TrackerGetStoreStorageCommand;
import com.github.tobato.fastdfs.service.DefaultTrackerClient;
import com.github.tobato.fastdfs.service.TrackerClient;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.plugin.fastdfs.properties.OssFastdfsProperties;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class HussarTrackerClient
extends DefaultTrackerClient
implements TrackerClient {
    private final OssFastdfsProperties ossFastdfsProperties;
    private final Map<String, String> mapping;
    @Autowired
    private TrackerConnectionManager trackerConnectionManager;

    public HussarTrackerClient(OssFastdfsProperties ossFastdfsProperties) {
        this.ossFastdfsProperties = ossFastdfsProperties;
        this.mapping = ossFastdfsProperties.getStorageIpMapping();
    }

    public StorageNode getStoreStorage() {
        TrackerGetStoreStorageCommand command = new TrackerGetStoreStorageCommand();
        StorageNode node = (StorageNode)this.trackerConnectionManager.executeFdfsTrackerCmd((FdfsCommand)command);
        this.mappingIp(node);
        return node;
    }

    public StorageNode getStoreStorage(String groupName) {
        TrackerGetStoreStorageCommand command = HussarUtils.isBlank((CharSequence)groupName) ? new TrackerGetStoreStorageCommand() : new TrackerGetStoreStorageCommand(groupName);
        StorageNode node = (StorageNode)this.trackerConnectionManager.executeFdfsTrackerCmd((FdfsCommand)command);
        this.mappingIp(node);
        return node;
    }

    public StorageNodeInfo getFetchStorage(String groupName, String filename) {
        TrackerGetFetchStorageCommand command = new TrackerGetFetchStorageCommand(groupName, filename, false);
        StorageNodeInfo nodeInfo = (StorageNodeInfo)this.trackerConnectionManager.executeFdfsTrackerCmd((FdfsCommand)command);
        this.mappingIp(nodeInfo);
        return nodeInfo;
    }

    public StorageNodeInfo getUpdateStorage(String groupName, String filename) {
        TrackerGetFetchStorageCommand command = new TrackerGetFetchStorageCommand(groupName, filename, true);
        StorageNodeInfo nodeInfo = (StorageNodeInfo)this.trackerConnectionManager.executeFdfsTrackerCmd((FdfsCommand)command);
        this.mappingIp(nodeInfo);
        return nodeInfo;
    }

    private void mappingIp(StorageNode node) {
        String mappingIp = this.mapping.get(node.getIp() + ":" + node.getPort());
        if (HussarUtils.isNotBlank((CharSequence)mappingIp)) {
            node.setIp(mappingIp.split(":")[0]);
            node.setPort(Integer.parseInt(mappingIp.split(":")[1]));
        }
    }

    private void mappingIp(StorageNodeInfo nodeInfo) {
        String mappingIp = this.mapping.get(nodeInfo.getIp() + ":" + nodeInfo.getPort());
        if (HussarUtils.isNotBlank((CharSequence)mappingIp)) {
            nodeInfo.setIp(mappingIp.split(":")[0]);
            nodeInfo.setPort(Integer.parseInt(mappingIp.split(":")[1]));
        }
    }
}

