/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.plugin.fastdfs.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.tobato.fastdfs.domain.fdfs.FileInfo;
import com.github.tobato.fastdfs.domain.fdfs.StorePath;
import com.github.tobato.fastdfs.domain.proto.storage.DownloadByteArray;
import com.github.tobato.fastdfs.domain.proto.storage.DownloadCallback;
import com.github.tobato.fastdfs.domain.proto.storage.DownloadFileStream;
import com.github.tobato.fastdfs.exception.FdfsServerException;
import com.github.tobato.fastdfs.service.FastFileStorageClient;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.lang.MultiLangUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.dao.AttachmentManagerMapper;
import com.jxdinfo.hussar.support.oss.core.support.dto.AttachInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.dto.FileInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.util.CheckUploadFileUtils;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.oss.core.support.vo.RangeDownloadVO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@HussarDs(value="master")
public class FastdfsAttachmentManagerServiceImpl
extends HussarServiceImpl<AttachmentManagerMapper, AttachmentManagerModel>
implements AttachmentManagerService {
    private final FastFileStorageClient storageClient;
    private final GetLoginUserService getLoginUserService;
    @Autowired
    private OssProperties ossProperties;
    private static Logger logger = LogManager.getLogger(FastdfsAttachmentManagerServiceImpl.class);

    public FastdfsAttachmentManagerServiceImpl(FastFileStorageClient storageClient, GetLoginUserService getLoginUserService) {
        this.storageClient = storageClient;
        this.getLoginUserService = getLoginUserService;
    }

    public Long saveAttachment(AttachmentManagerModel attachmentManagerModel) {
        this.save((BaseEntity)attachmentManagerModel);
        return attachmentManagerModel.getId();
    }

    public String findDirById(Long id) {
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentManagerModel)) {
            return "";
        }
        return attachmentManagerModel.getAttachmentDir();
    }

    public AttachmentManagerModelVo getByFileId(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        return this.getAttachmentVoById(fileId);
    }

    public List<AttachmentManagerModelVo> getByFileIds(String[] fileIds) {
        ArrayList<AttachmentManagerModelVo> attachmentManagerModelVos = new ArrayList<AttachmentManagerModelVo>();
        if (HussarUtils.isEmpty((Object[])fileIds)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        for (String fileId : fileIds) {
            if (!HussarUtils.isNotEmpty((Object)fileId)) continue;
            attachmentManagerModelVos.add(this.getAttachmentVoById(Long.parseLong(fileId)));
        }
        return attachmentManagerModelVos;
    }

    public ApiResponse<String> upload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file) || HussarUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties);
        String fileName = file.getOriginalFilename();
        String suffix = CheckUploadFileUtils.getExtension((String)fileName);
        String fName = IdWorker.get32UUID() + suffix;
        try {
            this.storageClient.uploadFile(file.getInputStream(), file.getSize(), suffix, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getMessage());
        }
        return ApiResponse.success((String)fName);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        multipartRequest.setCharacterEncoding("UTF-8");
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)iterator.next();
        }
        if (HussarUtils.isNotEmpty(multipartFile)) {
            CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
            attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId);
        }
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartFile multipartFile, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartFile)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
        return ApiResponse.success((Object)this.packageAttachmentVo(multipartFile, businessId));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<AttachmentManagerModelVo> uploadMultipleFile(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        ArrayList<AttachmentManagerModelVo> voList = new ArrayList<AttachmentManagerModelVo>();
        multipartRequest.setCharacterEncoding("UTF-8");
        Map map = multipartRequest.getFileMap();
        if (HussarUtils.isNotEmpty((Object)map)) {
            map.values().forEach(file -> CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties));
        }
        for (MultipartFile file2 : map.values()) {
            MultipartFile multipartFile = file2;
            if (!HussarUtils.isNotEmpty((Object)multipartFile)) continue;
            AttachmentManagerModelVo attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId);
            voList.add(attachmentManagerModelVo);
        }
        return voList;
    }

    public void fileDownload(HttpServletResponse response, Long fileId) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = attachmentModel.getAttachmentName();
        String path = attachmentModel.getAttachmentDir();
        try (BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            FileInfo fileInfo = this.getFileInfo(path);
            long fileSize = fileInfo.getFileSize();
            response.setContentLengthLong(fileSize);
            this.downStreamByPath(path, out);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
    }

    public void batchDownload(String ids, HttpServletResponse response) throws ServletException, IOException {
        if (HussarUtils.isEmpty((Object)ids) || HussarUtils.isEmpty((Object)response)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        ServletOutputStream os = response.getOutputStream();
        ArrayList fileIdList = new ArrayList();
        Arrays.stream(ids.split(",")).forEach(s -> {
            if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                fileIdList.add(Long.parseLong(s));
            }
        });
        List attachList = this.listByIds(fileIdList);
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)os);){
            String sourceFilePath = "\u6279\u91cf\u4e0b\u8f7d.zip";
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(sourceFilePath, "UTF-8"));
            int count = 0;
            for (AttachmentManagerModel attach : attachList) {
                Long id = attach.getId();
                String fileName = attach.getAttachmentName();
                String path = attach.getAttachmentDir();
                ZipEntry zipEntry = new ZipEntry(++count + "-" + fileName);
                zos.putNextEntry(zipEntry);
                this.downStreamByPath(path, zos);
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
    }

    public ApiResponse<Object> deleteFile(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isNotEmpty((Object)attachmentManagerModel)) {
            Long id = attachmentManagerModel.getId();
            String fileSavePath = attachmentManagerModel.getAttachmentDir();
            try {
                this.storageClient.deleteFile(fileSavePath);
            }
            catch (Exception e) {
                logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
                throw new HussarException(OssExceptionEnum.FAST_DELETE_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DELETE_EXCEPTION.getMessage());
            }
            this.removeById(id);
        }
        return ApiResponse.success((String)MultiLangUtil.trans((String)"\u5220\u9664\u6210\u529f", (String)"\u5220\u9664\u6210\u529f"));
    }

    public void showImage(HttpServletResponse response, Long id) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        response.setContentType("text/html; charset=UTF-8");
        AttachmentManagerModel image = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)image)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        if (!"gif,jpg,jpeg,bmp,png".contains(image.getAttachmentType().toLowerCase())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_IMG.getExceptionCode(), OssExceptionEnum.FILE_NOT_IMG.getMessage());
        }
        response.setContentType("image/" + image.getAttachmentType());
        String path = image.getAttachmentDir();
        try (ServletOutputStream output = response.getOutputStream();){
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(image.getAttachmentName(), "UTF-8"));
            response.setCharacterEncoding("UTF-8");
            FileInfo fileInfo = this.getFileInfo(path);
            response.setContentLengthLong(fileInfo.getFileSize());
            this.downStreamByPath(path, (OutputStream)output);
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
    }

    public Page<AttachmentManagerModel> getAttachmentList(Page<AttachmentManagerModel> page, AttachInfoDto info) {
        if (HussarUtils.isEmpty(page)) {
            throw new HussarException(OssExceptionEnum.PAGEINFO_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.PAGEINFO_NOT_EMPTY.getMessage());
        }
        String attachmentName = info.getAttachmentName();
        LocalDateTime startDate = info.getStartDate();
        LocalDateTime endDate = info.getEndDate();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)attachmentName)) {
            queryWrapper.like(AttachmentManagerModel::getAttachmentName, (Object)attachmentName);
        }
        if (HussarUtils.isNotEmpty((Object)startDate)) {
            queryWrapper.ge(AttachmentManagerModel::getUploadDate, (Object)startDate);
        }
        if (HussarUtils.isNotEmpty((Object)endDate)) {
            queryWrapper.le(AttachmentManagerModel::getUploadDate, (Object)endDate);
        }
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    public ApiResponse<Long> backgroundUpload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = file.getOriginalFilename();
        String suffix = CheckUploadFileUtils.getExtension((String)fileName);
        try {
            StorePath storePath = this.storageClient.uploadFile(file.getInputStream(), file.getSize(), suffix, null);
            String fileSavePath = storePath.getFullPath();
            FileInfoDto fileInfoDto = new FileInfoDto();
            fileInfoDto.setFileName(fileName);
            fileInfoDto.setFileSavePath(fileSavePath);
            fileInfoDto.setSuffix(suffix);
            fileInfoDto.setFileSize(Long.valueOf(file.getSize()));
            AttachmentManagerModel attachmentManagerModel = this.saveFileManager(null, fileInfoDto);
            Long id = attachmentManagerModel.getId();
            return ApiResponse.success((Object)id);
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getMessage());
        }
    }

    public ApiResponse<Boolean> isExist(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir();
        boolean flag = false;
        try {
            StorePath storePath = StorePath.parseFromUrl((String)path);
            FileInfo fileInfo = this.storageClient.queryFileInfo(storePath.getGroup(), storePath.getPath());
            if (HussarUtils.isNotEmpty((Object)fileInfo) && HussarUtils.isNotEmpty((Object)fileInfo.getSourceIpAddr())) {
                flag = true;
            }
        }
        catch (FdfsServerException e) {
            if (e.getErrorCode() != 2) {
                logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            }
            return ApiResponse.success((Object)Boolean.FALSE);
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            return ApiResponse.success((Object)Boolean.FALSE);
        }
        return ApiResponse.success((Object)flag);
    }

    public ApiResponse<byte[]> backgroundDownload(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir();
        try {
            return ApiResponse.success((Object)this.downFileByPath(path));
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
    }

    public RangeDownloadVO rangeDownload(AttachmentManagerModel attachmentModel, Long start, Long end) {
        try {
            String path = attachmentModel.getAttachmentDir();
            StorePath storePath = StorePath.parseFromUrl((String)path);
            FileInfo fileInfo = this.storageClient.queryFileInfo(storePath.getGroup(), storePath.getPath());
            long totalFileSize = fileInfo.getFileSize();
            byte[] bytes = (byte[])this.storageClient.downloadFile(storePath.getGroup(), storePath.getPath(), start.longValue(), end - start + 1L, (DownloadCallback)new DownloadByteArray());
            return new RangeDownloadVO(Long.valueOf(totalFileSize), bytes);
        }
        catch (Exception e) {
            logger.error("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new HussarException(MultiLangUtil.trans((String)"\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (String)"\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38"));
        }
    }

    private AttachmentManagerModel saveFileManager(Long businessId, FileInfoDto fileInfoDto) {
        AttachmentManagerModel attachment = new AttachmentManagerModel();
        attachment.setBusinessId(businessId);
        attachment.setAttachmentName(fileInfoDto.getFileName());
        attachment.setAttachmentType(fileInfoDto.getSuffix().replace(".", ""));
        attachment.setAttachmentSize(fileInfoDto.getFileSize());
        UserDetails user = this.getLoginUserService.getCurrentUserDetail();
        if (user != null) {
            attachment.setUploadPer(user.getUserId());
        }
        attachment.setAttachmentDir(fileInfoDto.getFileSavePath());
        attachment.setUploadDate(LocalDateTime.now());
        this.save((BaseEntity)attachment);
        return attachment;
    }

    private AttachmentManagerModelVo getAttachmentVoById(Long id) {
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return null;
        }
        String fileName = attachmentModel.getAttachmentName();
        String path = attachmentModel.getAttachmentDir();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        try {
            BeanUtil.copy((Object)attachmentModel, (Object)attachmentManagerModelVo);
            attachmentManagerModelVo.setFileName(fileName);
            attachmentManagerModelVo.setPath(path);
            if (HussarUtils.isNotEmpty((Object)attachmentModel.getAttachmentSize())) {
                attachmentManagerModelVo.setBytes(String.valueOf(attachmentModel.getAttachmentSize()));
            } else {
                FileInfo fileInfo = this.getFileInfo(path);
                attachmentManagerModelVo.setBytes(String.valueOf(fileInfo.getFileSize()));
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_DOWN_EXCEPTION.getMessage());
        }
        return attachmentManagerModelVo;
    }

    public AttachmentManagerModelVo packageAttachmentVo(MultipartFile multipartFile, Long businessId) throws Exception {
        String fileName = multipartFile.getOriginalFilename();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        String suffix = CheckUploadFileUtils.getExtension((String)fileName);
        String path = "";
        AttachmentManagerModel attachmentManagerModel = new AttachmentManagerModel();
        try {
            StorePath storePath = this.storageClient.uploadFile(multipartFile.getInputStream(), multipartFile.getSize(), suffix, null);
            String fileSavePath = storePath.getFullPath();
            FileInfoDto fileInfoDto = new FileInfoDto();
            fileInfoDto.setFileName(fileName);
            fileInfoDto.setFileSavePath(fileSavePath);
            fileInfoDto.setSuffix(suffix);
            fileInfoDto.setFileSize(Long.valueOf(multipartFile.getSize()));
            attachmentManagerModel = this.saveFileManager(businessId, fileInfoDto);
            path = fileSavePath;
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.FAST_UPLOAD_EXCEPTION.getMessage());
        }
        BeanUtil.copy((Object)attachmentManagerModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        attachmentManagerModelVo.setBytes(String.valueOf(multipartFile.getSize()));
        return attachmentManagerModelVo;
    }

    private byte[] downFileByPath(String path) {
        StorePath storePath = StorePath.parseFromUrl((String)path);
        return (byte[])this.storageClient.downloadFile(storePath.getGroup(), storePath.getPath(), (DownloadCallback)new DownloadByteArray());
    }

    private FileInfo getFileInfo(String path) {
        StorePath storePath = StorePath.parseFromUrl((String)path);
        return this.storageClient.queryFileInfo(storePath.getGroup(), storePath.getPath());
    }

    private BufferedInputStream downStreamByPath(String path, OutputStream out) {
        StorePath storePath = StorePath.parseFromUrl((String)path);
        return (BufferedInputStream)this.storageClient.downloadFile(storePath.getGroup(), storePath.getPath(), (DownloadCallback)new DownloadFileStream(out, this.ossProperties.getDownloadBuffSize()));
    }
}

