/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.plugin.cloud.support.impl;

import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.BosObject;
import com.baidubce.services.bos.model.GetObjectRequest;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.vo.RangeDownloadVO;
import com.jxdinfo.hussar.support.oss.plugin.cloud.properties.OssCloudProperties;
import com.jxdinfo.hussar.support.oss.plugin.cloud.support.CloudService;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StreamUtils;
import org.springframework.web.multipart.MultipartFile;

public class BosCloudServiceImpl
implements CloudService {
    private static final Logger LOGGER = LogManager.getLogger(BosCloudServiceImpl.class);
    private final BosClient bos;

    public BosCloudServiceImpl(OssCloudProperties ossCloudProperties) {
        try {
            this.bos = this.initClient(ossCloudProperties.getEndpoint(), ossCloudProperties.getAccessKey(), ossCloudProperties.getSecretKey());
        }
        catch (Exception e) {
            LOGGER.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_CLIENT_INIT_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_CLIENT_INIT_EXCEPTION.getMessage());
        }
    }

    public BosClient initClient(String endpoint, String accessKey, String secretKey) throws Exception {
        BosClientConfiguration configuration = new BosClientConfiguration();
        configuration.setCredentials((BceCredentials)new DefaultBceCredentials(accessKey, secretKey));
        configuration.setEndpoint(endpoint);
        return new BosClient(configuration);
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws Exception {
        return this.bos.doesBucketExist(bucketName);
    }

    @Override
    public void createBucket(String bucketName) throws Exception {
        this.bos.createBucket(bucketName);
    }

    @Override
    public void upload(String bucketName, String path, MultipartFile file) throws Exception {
        this.bos.putObject(bucketName, path, file.getInputStream());
    }

    @Override
    public void down(String bucketName, String path, OutputStream outputStream) {
        try (BosObject object = this.bos.getObject(bucketName, path);){
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            StreamUtils.copy((InputStream)object.getObjectContent(), (OutputStream)outputStream);
        }
        catch (Exception e) {
            LOGGER.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] down(String bucketName, String path) throws Exception {
        try (BosObject object = this.bos.getObject(bucketName, path);){
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            byte[] byArray = IoUtil.readToByteArray((InputStream)object.getObjectContent());
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
    }

    @Override
    public RangeDownloadVO rangeDown(String bucketName, String path, Long start, Long end) throws Exception {
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, path);
            getObjectRequest.setRange(start.longValue(), end.longValue());
            BosObject object = this.bos.getObject(getObjectRequest);
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            return new RangeDownloadVO(Long.valueOf(object.getObjectMetadata().getInstanceLength()), IoUtil.readToByteArray((InputStream)object.getObjectContent()));
        }
        catch (Exception e) {
            LOGGER.error("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new HussarException(OssExceptionEnum.CLOUD_RANGE_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_RANGE_DOWN_EXCEPTION.getMessage());
        }
    }

    @Override
    public boolean delete(String bucketName, String path) throws Exception {
        try {
            this.bos.deleteObject(bucketName, path);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DELETE_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DELETE_EXCEPTION.getMessage());
        }
    }

    @Override
    public boolean doesFileExist(String bucketName, String path) throws Exception {
        return this.bos.doesObjectExist(bucketName, path);
    }

    @Override
    public Long getContentLength(String bucketName, String path) throws Exception {
        ObjectMetadata metadata = this.bos.getObjectMetadata(bucketName, path);
        return metadata.getContentLength();
    }
}

