/*
 * Decompiled with CFR 0.152.
 */
package comjxdinfo.hussar.support.oss.plugin.cloud.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.dao.AttachmentManagerMapper;
import com.jxdinfo.hussar.support.oss.core.support.dto.AttachInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.dto.FileInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.entity.FileAddition;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.util.CheckUploadFileUtils;
import com.jxdinfo.hussar.support.oss.core.support.util.OssCascadeUtils;
import com.jxdinfo.hussar.support.oss.core.support.util.OssEncoderUtils;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.oss.core.support.vo.FileEncryptVo;
import com.jxdinfo.hussar.support.oss.core.support.vo.RangeDownloadVO;
import comjxdinfo.hussar.support.oss.plugin.cloud.properties.OssCloudProperties;
import comjxdinfo.hussar.support.oss.plugin.cloud.support.CloudService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@HussarDs(value="master")
public class CloudAttachmentManagerServiceImpl
extends HussarServiceImpl<AttachmentManagerMapper, AttachmentManagerModel>
implements AttachmentManagerService {
    private final OssCloudProperties ossCloudProperties;
    private final GetLoginUserService getLoginUserService;
    private final CloudService cloudServerService;
    private final String bucketName;
    @Resource
    private OssProperties ossProperties;
    @Resource
    private SeqBuilder seqBuilder;
    private static final Logger logger = LogManager.getLogger(CloudAttachmentManagerServiceImpl.class);

    public CloudAttachmentManagerServiceImpl(OssCloudProperties ossCloudProperties, GetLoginUserService getLoginUserService, CloudService cloudServerService) {
        this.ossCloudProperties = ossCloudProperties;
        this.getLoginUserService = getLoginUserService;
        this.cloudServerService = cloudServerService;
        try {
            this.bucketName = ossCloudProperties.getBucketName();
            if (!cloudServerService.doesBucketExist(this.bucketName)) {
                cloudServerService.createBucket(this.bucketName);
            }
        }
        catch (Exception e) {
            logger.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_CHECK_BUCKET_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_CHECK_BUCKET_EXCEPTION.getMessage());
        }
    }

    public Long saveAttachment(AttachmentManagerModel attachmentManagerModel) {
        this.save((BaseEntity)attachmentManagerModel);
        return attachmentManagerModel.getId();
    }

    public String findDirById(Long id) {
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentManagerModel)) {
            return "";
        }
        return attachmentManagerModel.getAttachmentDir();
    }

    public AttachmentManagerModelVo getByFileId(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        return this.getAttachmentVoById(fileId);
    }

    public List<AttachmentManagerModelVo> getByFileIds(String[] fileIds) {
        ArrayList<AttachmentManagerModelVo> attachmentManagerModelVos = new ArrayList<AttachmentManagerModelVo>();
        if (HussarUtils.isEmpty((Object[])fileIds)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        for (String fileId : fileIds) {
            if (!HussarUtils.isNotEmpty((Object)fileId)) continue;
            attachmentManagerModelVos.add(this.getAttachmentVoById(Long.parseLong(fileId)));
        }
        return attachmentManagerModelVos;
    }

    public ApiResponse<String> upload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file) || HussarUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties);
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fName = IdWorker.get32UUID() + suffix;
        try {
            this.cloudServerService.upload(this.bucketName, this.ossCloudProperties.getFileUploadPath() + fName, file);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(OssExceptionEnum.CLOUD_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_UPLOAD_EXCEPTION.getMessage());
        }
        return ApiResponse.success((String)fName);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String securityLevel = multipartRequest.getParameter("securityLevel");
        String seq = multipartRequest.getParameter("seq");
        multipartRequest.setCharacterEncoding("UTF-8");
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)iterator.next();
        }
        if (HussarUtils.isNotEmpty(multipartFile)) {
            CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
            attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId, securityLevel, seq);
        }
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartFile multipartFile, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartFile)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
        return ApiResponse.success((Object)this.packageAttachmentVo(multipartFile, businessId, null, null));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<AttachmentManagerModelVo> uploadMultipleFile(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        ArrayList<AttachmentManagerModelVo> voList = new ArrayList<AttachmentManagerModelVo>();
        String securityLevel = multipartRequest.getParameter("securityLevel");
        String seq = multipartRequest.getParameter("seq");
        multipartRequest.setCharacterEncoding("UTF-8");
        Map map = multipartRequest.getFileMap();
        if (HussarUtils.isNotEmpty((Object)map)) {
            map.values().forEach(file -> CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties));
        }
        for (MultipartFile file2 : map.values()) {
            MultipartFile multipartFile = file2;
            if (!HussarUtils.isNotEmpty((Object)multipartFile)) continue;
            AttachmentManagerModelVo attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId, securityLevel, seq);
            voList.add(attachmentManagerModelVo);
        }
        return voList;
    }

    public void fileDownload(HttpServletResponse response, Long fileId) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return;
        }
        String fileName = attachmentModel.getAttachmentName();
        String path = attachmentModel.getAttachmentDir() + attachmentModel.getId() + this.getSuffix(fileName);
        FileInputStream fileInputStream = null;
        try (BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            fileName = OssEncoderUtils.encode((String)fileName, (String)"UTF-8");
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            Long contentLength = this.cloudServerService.getContentLength(this.bucketName, path);
            if (HussarUtils.isNotEmpty((Object)contentLength)) {
                response.setContentLengthLong(contentLength.longValue());
            }
            if (HussarUtils.isNotEmpty((Object)attachmentModel.getEncrypt())) {
                byte[] bytes = this.cloudServerService.down(this.bucketName, path);
                File realFile = OssCascadeUtils.decryptInputStreamToFile((Long)fileId, (String)this.getSuffix(fileName), (InputStream)new ByteArrayInputStream(bytes), (String)attachmentModel.getEncrypt());
                response.setContentLengthLong(realFile.length());
                fileInputStream = new FileInputStream(realFile);
                IoUtil.copy((InputStream)fileInputStream, (OutputStream)out);
            } else {
                this.cloudServerService.down(this.bucketName, path, out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)attachmentModel.getEncrypt())) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.tempPath((Long)fileId, (String)this.getSuffix(fileName))));
                }
                catch (IOException e) {
                    logger.error("\u5206\u4fdd: \u6587\u4ef6\u4e0b\u8f7d\u540e\u5220\u9664\u672c\u5730\u5b58\u50a8\u7684\u660e\u6587\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public RangeDownloadVO rangeDownload(AttachmentManagerModel attachmentModel, Long start, Long end) {
        try {
            String fileName = attachmentModel.getAttachmentName();
            String path = attachmentModel.getAttachmentDir() + attachmentModel.getId() + this.getSuffix(fileName);
            return this.cloudServerService.rangeDown(this.bucketName, path, start, end);
        }
        catch (Exception e) {
            logger.error("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
    }

    public void batchDownload(String ids, HttpServletResponse response) throws ServletException, IOException {
        if (HussarUtils.isEmpty((Object)ids) || HussarUtils.isEmpty((Object)response)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        ServletOutputStream os = response.getOutputStream();
        ArrayList fileIdList = new ArrayList();
        Arrays.stream(ids.split(",")).forEach(s -> {
            if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                fileIdList.add(Long.parseLong(s));
            }
        });
        List attachList = this.listByIds(fileIdList);
        ArrayList<String> needDeleteFilePaths = new ArrayList<String>();
        FileInputStream fileInputStream = null;
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)os);){
            String sourceFilePath = "\u6279\u91cf\u4e0b\u8f7d.zip";
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(sourceFilePath, "UTF-8"));
            int count = 0;
            for (AttachmentManagerModel attach : attachList) {
                Long id = attach.getId();
                String fileName = attach.getAttachmentName();
                String path = attach.getAttachmentDir() + id + this.getSuffix(fileName);
                ZipEntry zipEntry = new ZipEntry(++count + "-" + fileName);
                zos.putNextEntry(zipEntry);
                if (HussarUtils.isNotEmpty((Object)attach.getEncrypt())) {
                    String suffix = this.getSuffix(fileName);
                    byte[] bytes = this.cloudServerService.down(this.bucketName, path);
                    File realFile = OssCascadeUtils.decryptInputStreamToFile((Long)id, (String)suffix, (InputStream)new ByteArrayInputStream(bytes), (String)attach.getEncrypt());
                    fileInputStream = new FileInputStream(realFile);
                    IoUtil.copy((InputStream)fileInputStream, (OutputStream)zos);
                    needDeleteFilePaths.add(OssCascadeUtils.tempPath((Long)id, (String)suffix));
                    continue;
                }
                this.cloudServerService.down(this.bucketName, path, zos);
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
        finally {
            if (HussarUtils.isNotEmpty(needDeleteFilePaths)) {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                for (String path : needDeleteFilePaths) {
                    try {
                        FileUtils.forceDelete((File)new File(path));
                    }
                    catch (IOException e) {
                        logger.error("\u5206\u4fdd: \u591a\u6587\u4ef6\u4e0b\u8f7d\uff0c\u5220\u9664\u660e\u6587\u6587\u4ef6\u5931\u8d25\uff0cpath = {}", (Object)path, (Object)e);
                    }
                }
            }
        }
    }

    public ApiResponse<Object> deleteFile(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isNotEmpty((Object)attachmentManagerModel)) {
            Long id = attachmentManagerModel.getId();
            String suffix = this.getSuffix(attachmentManagerModel.getAttachmentName());
            String fileSavePath = attachmentManagerModel.getAttachmentDir() + id + suffix;
            try {
                this.cloudServerService.delete(this.bucketName, fileSavePath);
            }
            catch (Exception e) {
                logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
                throw new HussarException(OssExceptionEnum.CLOUD_DELETE_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DELETE_EXCEPTION.getMessage());
            }
            this.removeById(id);
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public void showImage(HttpServletResponse response, Long id) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        response.setContentType("text/html; charset=UTF-8");
        AttachmentManagerModel image = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)image)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        if (!"gif,jpg,jpeg,bmp,png".contains(image.getAttachmentType().toLowerCase())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_IMG.getExceptionCode(), OssExceptionEnum.FILE_NOT_IMG.getMessage());
        }
        response.setContentType("image/" + image.getAttachmentType());
        String path = image.getAttachmentDir() + image.getId() + this.getSuffix(image.getAttachmentName());
        FileInputStream fileInputStream = null;
        try (ServletOutputStream output = response.getOutputStream();){
            if (HussarUtils.isNotEmpty((Object)image.getEncrypt())) {
                byte[] bytes = this.cloudServerService.down(this.bucketName, path);
                File realFile = OssCascadeUtils.decryptInputStreamToFile((Long)id, (String)this.getSuffix(image.getAttachmentName()), (InputStream)new ByteArrayInputStream(bytes), (String)image.getEncrypt());
                response.setContentLengthLong(realFile.length());
                fileInputStream = new FileInputStream(realFile);
                IoUtil.copy((InputStream)fileInputStream, (OutputStream)output);
            } else {
                this.cloudServerService.down(this.bucketName, path, (OutputStream)output);
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (HussarUtils.isNotEmpty((Object)image.getEncrypt())) {
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.tempPath((Long)id, (String)this.getSuffix(image.getAttachmentName()))));
                }
            }
            catch (IOException e) {
                logger.error("\u5206\u4fdd\uff1a\u56fe\u7247\u56de\u663e\uff0c\u5220\u9664\u89e3\u5bc6\u540e\u660e\u6587\u56fe\u7247\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public Page<AttachmentManagerModel> getAttachmentList(Page<AttachmentManagerModel> page, AttachInfoDto info) {
        if (HussarUtils.isEmpty(page)) {
            throw new HussarException(OssExceptionEnum.PAGEINFO_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.PAGEINFO_NOT_EMPTY.getMessage());
        }
        String attachmentName = info.getAttachmentName();
        LocalDateTime startDate = info.getStartDate();
        LocalDateTime endDate = info.getEndDate();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)attachmentName)) {
            queryWrapper.like(AttachmentManagerModel::getAttachmentName, (Object)attachmentName);
        }
        if (HussarUtils.isNotEmpty((Object)startDate)) {
            queryWrapper.ge(AttachmentManagerModel::getUploadDate, (Object)startDate);
        }
        if (HussarUtils.isNotEmpty((Object)endDate)) {
            queryWrapper.le(AttachmentManagerModel::getUploadDate, (Object)endDate);
        }
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    public ApiResponse<Long> backgroundUpload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossCloudProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        fileInfoDto.setFileSize(Long.valueOf(file.getSize()));
        AttachmentManagerModel attachmentManagerModel = this.saveFileManager(null, fileInfoDto);
        Long id = attachmentManagerModel.getId();
        String path = fileSavePath + id + suffix;
        try {
            if (!this.cloudServerService.doesFolderExist(this.bucketName, fileSavePath)) {
                this.cloudServerService.createFolder(this.bucketName, fileSavePath);
            }
            this.cloudServerService.upload(this.bucketName, path, file);
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.CLOUD_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_UPLOAD_EXCEPTION.getMessage());
        }
        return ApiResponse.success((Object)id);
    }

    public ApiResponse<Long> backgroundUploadWithAddition(MultipartFile file, String additionContext) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        if (HussarUtils.isEmpty((Object)additionContext)) {
            return this.backgroundUpload(file);
        }
        try {
            FileAddition addition = (FileAddition)JsonUtil.parse((String)additionContext, FileAddition.class);
            AttachmentManagerModelVo vo = this.packageAttachmentVo(file, null, addition.getSecurityLevel(), addition.getSeq());
            return ApiResponse.success((Object)vo.getId());
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.MINIO_UPLOAD_EXCEPTION.getMessage());
        }
    }

    public ApiResponse<Boolean> isExist(Long id) {
        boolean flag;
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir() + file.getId() + this.getSuffix(file.getAttachmentName());
        try {
            flag = this.cloudServerService.doesFileExist(this.bucketName, path);
        }
        catch (Exception e) {
            return ApiResponse.success((Object)Boolean.FALSE);
        }
        return ApiResponse.success((Object)flag);
    }

    public ApiResponse<byte[]> backgroundDownload(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String path = file.getAttachmentDir() + file.getId() + this.getSuffix(file.getAttachmentName());
        FileInputStream fileInputStream = null;
        try {
            byte[] bytes = this.cloudServerService.down(this.bucketName, path);
            if (HussarUtils.isNotEmpty((Object)file.getEncrypt())) {
                File realFile = OssCascadeUtils.decryptInputStreamToFile((Long)id, (String)this.getSuffix(file.getAttachmentName()), (InputStream)new ByteArrayInputStream(bytes), (String)file.getEncrypt());
                fileInputStream = new FileInputStream(realFile);
                ApiResponse apiResponse = ApiResponse.success((Object)IoUtil.readToByteArray((InputStream)fileInputStream));
                return apiResponse;
            }
            ApiResponse apiResponse = ApiResponse.success((Object)bytes);
            return apiResponse;
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (HussarUtils.isNotEmpty((Object)file.getEncrypt())) {
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.tempPath((Long)id, (String)this.getSuffix(file.getAttachmentName()))));
                }
            }
            catch (IOException e) {
                logger.error("\u5206\u4fdd: \u540e\u7aef\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3\uff0c\u5220\u9664\u672c\u5730\u660e\u6587\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private AttachmentManagerModel saveFileManager(Long businessId, FileInfoDto fileInfoDto) {
        AttachmentManagerModel attachment = new AttachmentManagerModel();
        attachment.setId(fileInfoDto.getFileId());
        attachment.setBusinessId(businessId);
        attachment.setAttachmentName(fileInfoDto.getFileName());
        attachment.setAttachmentType(fileInfoDto.getSuffix().replace(".", ""));
        attachment.setAttachmentSize(fileInfoDto.getFileSize());
        if (HussarUtils.isNotEmpty((Object)fileInfoDto.getSecurityLevel())) {
            attachment.setSecurityLevel(Integer.valueOf(Integer.parseInt(fileInfoDto.getSecurityLevel())));
        }
        if (HussarUtils.isNotEmpty((Object)fileInfoDto.getSeq())) {
            attachment.setSeq(Integer.valueOf(fileInfoDto.getSeq()));
        }
        attachment.setEncrypt(fileInfoDto.getEncryptKey());
        UserDetails user = this.getLoginUserService.getCurrentUserDetail();
        if (user != null) {
            attachment.setUploadPer(user.getUserId());
        }
        attachment.setAttachmentDir(fileInfoDto.getFileSavePath());
        attachment.setUploadDate(LocalDateTime.now());
        this.save((BaseEntity)attachment);
        return attachment;
    }

    private AttachmentManagerModelVo getAttachmentVoById(Long id) {
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return null;
        }
        String fileName = attachmentModel.getAttachmentName();
        String path = attachmentModel.getAttachmentDir() + id + this.getSuffix(fileName);
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        try {
            BeanUtil.copy((Object)attachmentModel, (Object)attachmentManagerModelVo);
            attachmentManagerModelVo.setFileName(fileName);
            attachmentManagerModelVo.setPath(path);
            if (HussarUtils.isNotEmpty((Object)attachmentModel.getAttachmentSize())) {
                attachmentManagerModelVo.setBytes(String.valueOf(attachmentModel.getAttachmentSize()));
            } else {
                attachmentManagerModelVo.setBytes(String.valueOf(this.cloudServerService.getContentLength(this.bucketName, path)));
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
        return attachmentManagerModelVo;
    }

    public AttachmentManagerModelVo packageAttachmentVo(MultipartFile multipartFile, Long businessId, String securityLevel, String seq) throws Exception {
        String fileName = multipartFile.getOriginalFilename();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossCloudProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        fileInfoDto.setFileSize(Long.valueOf(multipartFile.getSize()));
        fileInfoDto.setSecurityLevel(securityLevel);
        fileInfoDto.setSeq(seq);
        Long id = this.seqBuilder.build().nextValue();
        fileInfoDto.setFileId(id);
        InputStream inputStream = multipartFile.getInputStream();
        if (HussarUtils.isNotEmpty((Object)securityLevel)) {
            FileEncryptVo fileEncryptVo = OssCascadeUtils.encryptFileToInputStream((Long)id, (String)suffix, (MultipartFile)multipartFile);
            fileInfoDto.setEncryptKey(fileEncryptVo.getEncryptKey());
            inputStream = fileEncryptVo.getEncryptInputStream();
        }
        AttachmentManagerModel attachmentManagerModel = this.saveFileManager(businessId, fileInfoDto);
        String path = fileSavePath + attachmentManagerModel.getId() + suffix;
        try {
            if (!this.cloudServerService.doesFolderExist(this.bucketName, fileSavePath)) {
                this.cloudServerService.createFolder(this.bucketName, fileSavePath);
            }
            this.cloudServerService.upload(this.bucketName, path, inputStream);
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.CLOUD_UPLOAD_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_UPLOAD_EXCEPTION.getMessage());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (HussarUtils.isNotEmpty((Object)fileInfoDto.getEncryptKey())) {
                try {
                    FileUtils.forceDelete((File)new File(OssCascadeUtils.encryptFileTempPath((Long)id, (String)suffix)));
                }
                catch (IOException e) {
                    logger.error("\u5206\u4fdd: \u6587\u4ef6\u4e0a\u4f20\u7ed3\u675f\u540e\uff0c\u5220\u9664\u672c\u5730\u52a0\u5bc6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                }
            }
        }
        BeanUtil.copy((Object)attachmentManagerModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        attachmentManagerModelVo.setBytes(String.valueOf(multipartFile.getSize()));
        return attachmentManagerModelVo;
    }

    private byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }
}

