/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.core.support.enums;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Arrays;

public enum PlayableFileType {
    WEBM("webm", "video/webm", "WEBM\u89c6\u9891"),
    MP4("mp4", "video/mp4", "mp4\u89c6\u9891"),
    OGV("ogv", "video/ogg", "OGG\u89c6\u9891"),
    OGA("oga", "audio/ogg", "OGG\u97f3\u8baf"),
    MP3("mp3", "audio/mpeg", "MP3\u97f3\u9891"),
    WAV("wav", "audio/wav", "\u6ce2\u5f62\u97f3\u9891");

    private String suffix;
    private String contentType;
    private String desc;

    private PlayableFileType(String suffix, String contentType, String desc) {
        this.suffix = suffix;
        this.contentType = contentType;
        this.desc = desc;
    }

    public static Boolean check(String fileType) {
        if (HussarUtils.isEmpty((Object)fileType)) {
            return false;
        }
        return Arrays.stream(PlayableFileType.values()).anyMatch(playableFileType -> playableFileType.suffix.equals(fileType));
    }

    public static String getContentType(String fileType) {
        if (HussarUtils.isEmpty((Object)fileType)) {
            return "";
        }
        PlayableFileType target = Arrays.stream(PlayableFileType.values()).filter(playableFileType -> playableFileType.suffix.equals(fileType)).findFirst().orElse(null);
        return target == null ? "" : target.getContentType();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

