/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.Driver;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

public class OscarJDBCUtil {
    private static boolean equalOrGreaterJdbc4;
    private static boolean equalOrGreaterJdbc42;

    public static boolean isEqualOrGreaterJdbc4() {
        return equalOrGreaterJdbc4;
    }

    public static boolean isEqualOrGreaterJdbc42() {
        return equalOrGreaterJdbc42;
    }

    public static String stackTraceToString(Throwable ex) {
        StringBuilder traceBuf = new StringBuilder();
        traceBuf.append("Util.1");
        if (ex != null) {
            traceBuf.append(ex.getClass().getName());
            String message = ex.getMessage();
            if (message != null) {
                traceBuf.append("Util.2");
                traceBuf.append(message);
            }
            StringWriter out = new StringWriter();
            PrintWriter printOut = new PrintWriter(out);
            ex.printStackTrace(printOut);
            traceBuf.append("Util.3");
            traceBuf.append(out.toString());
        }
        traceBuf.append("Util.4");
        return traceBuf.toString();
    }

    public static final Object handleNewInstance(Constructor<?> ctor, Object[] args) throws SQLException {
        try {
            return ctor.newInstance(args);
        }
        catch (InvocationTargetException ex) {
            Driver.writeLog(ex);
            Throwable throwable = ex.getTargetException();
            if (throwable != null && throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new SQLException(throwable);
        }
        catch (Exception e) {
            Driver.writeLog(e);
            throw new SQLException(e);
        }
    }

    static {
        try {
            ClassLoader classLoader = OscarJDBCUtil.class.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            classLoader.loadClass("com.oscar.jdbc.Oscar42PreparedStatementV2");
            equalOrGreaterJdbc4 = true;
            equalOrGreaterJdbc42 = true;
        }
        catch (ClassNotFoundException e2) {
            equalOrGreaterJdbc42 = false;
            equalOrGreaterJdbc4 = true;
        }
    }
}

