/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.protocol;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.protocol.OSCARProtocol;
import com.oscar.protocol.OSCARProtocolV2;
import com.oscar.protocol.Packet;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.protocol.packets.AuthenticationPacket;
import com.oscar.protocol.packets.AuthenticationPacketV2;
import com.oscar.protocol.packets.AuthenticationPacketV3;
import com.oscar.protocol.packets.BackendKeyPacket;
import com.oscar.protocol.packets.BasePacket;
import com.oscar.protocol.packets.EndianTypePacket;
import com.oscar.protocol.packets.ErrorResponsePacket;
import com.oscar.protocol.packets.HdEncryptRequestPacket;
import com.oscar.protocol.packets.ListenerResponsePacket;
import com.oscar.protocol.packets.MessagePacket;
import com.oscar.protocol.packets.NoticeResponsePacket;
import com.oscar.protocol.packets.ReadyForQueryPacket;
import com.oscar.protocol.packets.SSLRequestPacket;
import com.oscar.protocol.packets.StartupPacket;
import com.oscar.protocol.packets.TerminatePacket;
import com.oscar.protocol.packets.UnencryptedPasswordPacket;
import com.oscar.protocol.stream.OSocket;
import com.oscar.protocol.stream.OStream;
import com.oscar.util.EncodeUtil;
import com.oscar.util.MD5Digest;
import com.oscar.util.OSQLException;
import com.oscar.util.VersionConfig;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;

public class ProtocolManager {
    private BaseConnection connection;
    private String host;
    private int port;
    private String database;
    private String db_user;
    private Properties info;
    private static final int ProtocolMajorVersion = 2;
    private static final int ProtocolMinorVersion = 0;
    private static final int AUTH_UNKNOW = -1;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_MD5 = 5;
    private int pid;
    private int ckey;
    private Packet pk = new Packet();
    private OStream oStream;
    private boolean logFlag = Driver.getLogLevel() >= 3;
    private int requestTimeOut = 0;

    public ProtocolManager(BaseConnection con, String _host, int _port, String _database, String user, Properties _info) throws ConnectException, IOException {
        this(con, _host, _port, _database, user, _info, 0);
    }

    public ProtocolManager(BaseConnection con, String _host, int _port, String _database, String user, Properties _info, int requestTimeOut) throws ConnectException, IOException {
        this.connection = con;
        this.host = _host;
        this.port = _port;
        if (Boolean.valueOf(_info.getProperty("NAMESENSITIVE")).booleanValue()) {
            this.database = _database;
            this.db_user = user;
        } else {
            this.database = OSCARProtocol.convertString(_database);
            this.db_user = OSCARProtocol.convertString(user);
        }
        this.info = _info;
        this.requestTimeOut = requestTimeOut;
        this.oStream = new OSocket(_host, _port, requestTimeOut, con, _info);
        this.oStream.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(boolean useSSL, boolean compatibleOldProtocal) throws SQLException {
        ProtocolManager protocolManager = this;
        synchronized (protocolManager) {
            try {
                ProtocolVersion config = new ProtocolVersion();
                config.setVersion(VersionConfig.getInstance());
                this.connection.setVersion(config);
                StartupPacket start = new StartupPacket(2, 0, this.database, this.db_user, this.info, this.connection.getClientEncoding(), this.connection.getVersion());
                start.setConnection(this.connection);
                start.setCompatibleOldProtocal(compatibleOldProtocal);
                boolean isEncrypted = false;
                if (this.info.getProperty("NOSSLVERSION", "t").equals("f")) {
                    BasePacket srp = null;
                    byte[] respondType = new byte[1];
                    boolean hdEncrypt = this.info.getProperty("HDENCRYPT", "f").equals("t");
                    srp = hdEncrypt ? new HdEncryptRequestPacket(this.connection, useSSL) : new SSLRequestPacket(useSSL);
                    srp.setConnection(this.connection);
                    this.sendMessage(this.oStream.getBufferedOutputStream(), srp);
                    this.oStream.getInputStream().read(respondType);
                    switch (respondType[0]) {
                        case 2: {
                            this.oStream.wrapEncryptStream();
                            isEncrypted = true;
                            break;
                        }
                        case 1: {
                            try {
                                if (this.info.getProperty("ssl_load_style", "SSL_LOAD_STYLE_FILE").equals("SSL_LOAD_STYLE_FILE")) {
                                    this.oStream.openWithSSL(this.info.getProperty("KEYFILE", "client.key"), this.info.getProperty("CERTFILE", "client.pem"), this.info.getProperty("KEYFILEPWD", "password"), this.info.getProperty("ROOTFILE", "root.pem"), this.info.getProperty("RANDOMFILE", "random.pem"), this.database, this.info.getProperty("CIPHERSSUITES", "TLS_AES_256_GCM_SHA384, TLS_AES_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, TLS_DHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, TLS_DHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, TLS_DHE_RSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_256_GCM_SHA384,TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA"));
                                } else if (this.info.getProperty("ssl_load_style", "SSL_LOAD_STYLE_FILE").equals("SSL_LOAD_STYLE_OSCARKEYSTORE")) {
                                    throw new SQLException("Not Supported");
                                }
                            }
                            catch (InternalError er) {
                                throw new SQLException(er.getMessage());
                            }
                            catch (Exception ex) {
                                throw new SQLException(ex.getMessage());
                            }
                            isEncrypted = true;
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case -1: {
                            throw new OSQLException("OSCAR-00111", "88888", 111);
                        }
                        case -2: {
                            throw new OSQLException("OSCAR-00112", "88888", 112);
                        }
                        case -3: {
                            throw new OSQLException("OSCAR-00117", "88888", 117);
                        }
                    }
                }
                this.sendMessage(this.oStream.getBufferedOutputStream(), start);
                int authPolicy = -1;
                BasePacket bk = null;
                do {
                    UnencryptedPasswordPacket uppsm3;
                    byte[] digest1;
                    UnencryptedPasswordPacket uppmd5;
                    byte[] digest;
                    byte[] md5Salt;
                    UnencryptedPasswordPacket upp;
                    byte[] bytePassword;
                    if ((bk = this.getMessage(this.oStream.getInputStream())) instanceof EndianTypePacket) {
                        EndianTypePacket etPacket = (EndianTypePacket)bk;
                        this.getMessage(this.oStream.getInputStream(), bk);
                        this.connection.setEndianType(etPacket.getEndianType());
                        continue;
                    }
                    if (bk instanceof ListenerResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), bk);
                        int dbPort = ((ListenerResponsePacket)bk).getDbPort();
                        TerminatePacket tp = new TerminatePacket();
                        this.sendMessage(this.oStream.getBufferedOutputStream(), tp);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.oStream.close();
                        if (dbPort == 0) {
                            throw new OSQLException("OSCAR-00212", "88888", 106);
                        }
                        this.port = dbPort;
                        this.oStream = new OSocket(this.host, this.port, this.info);
                        this.oStream.open();
                        this.startup(useSSL, compatibleOldProtocal);
                        continue;
                    }
                    if (bk instanceof AuthenticationPacket) {
                        config.setProtocolType(1);
                        byte[] byteUser = this.connection.getClientEncoding().encode(this.db_user);
                        bytePassword = this.connection.getClientEncoding().encode(this.getDbPassword());
                        this.getMessage(this.oStream.getInputStream(), bk);
                        authPolicy = ((AuthenticationPacket)bk).getAuthenPolicy();
                        switch (authPolicy) {
                            case 0: {
                                break;
                            }
                            case 3: {
                                if (isEncrypted) {
                                    upp = new UnencryptedPasswordPacket(bytePassword);
                                    upp.setConnection(this.connection);
                                    this.sendMessage(this.oStream.getBufferedOutputStream(), upp);
                                    break;
                                }
                                throw new OSQLException("OSCAR-00106", "08004", 106);
                            }
                            case 5: {
                                md5Salt = (byte[])((AuthenticationPacket)bk).getSalt();
                                digest = MD5Digest.encode(byteUser, bytePassword, md5Salt);
                                uppmd5 = new UnencryptedPasswordPacket(digest);
                                uppmd5.setConnection(this.connection);
                                this.sendMessage(this.oStream.getBufferedOutputStream(), uppmd5);
                                break;
                            }
                            case 7: {
                                md5Salt = (byte[])((AuthenticationPacket)bk).getSalt();
                                digest1 = MD5Digest.encodeWithSM3(byteUser, bytePassword, md5Salt);
                                uppsm3 = new UnencryptedPasswordPacket(digest1);
                                uppsm3.setConnection(this.connection);
                                this.sendMessage(this.oStream.getBufferedOutputStream(), uppsm3);
                                break;
                            }
                            case 10: 
                            case 11: 
                            case 12: {
                                ((AuthenticationPacket)bk).getScramSupport().setPassword(this.getDbPassword());
                                this.sendMessage(this.oStream.getBufferedOutputStream(), bk);
                                break;
                            }
                            default: {
                                throw new OSQLException("OSCAR-00106", "08004", 106);
                            }
                        }
                        continue;
                    }
                    if (bk instanceof AuthenticationPacketV2) {
                        config.setProtocolType(2);
                        byte[] byteUser = this.connection.getClientEncoding().encode(this.db_user);
                        bytePassword = this.connection.getClientEncoding().encode(this.getDbPassword());
                        this.getMessage(this.oStream.getInputStream(), bk);
                        authPolicy = ((AuthenticationPacketV2)bk).getAuthenPolicy();
                        switch (authPolicy) {
                            case 0: {
                                break;
                            }
                            case 3: {
                                if (isEncrypted) {
                                    upp = new UnencryptedPasswordPacket(bytePassword);
                                    upp.setConnection(this.connection);
                                    this.sendMessage(this.oStream.getBufferedOutputStream(), upp);
                                    break;
                                }
                                throw new OSQLException("OSCAR-00106", "08004", 106);
                            }
                            case 5: {
                                md5Salt = (byte[])((AuthenticationPacketV2)bk).getSalt();
                                digest = MD5Digest.encode(byteUser, bytePassword, md5Salt);
                                uppmd5 = new UnencryptedPasswordPacket(digest);
                                uppmd5.setConnection(this.connection);
                                this.sendMessage(this.oStream.getBufferedOutputStream(), uppmd5);
                                break;
                            }
                            default: {
                                throw new OSQLException("OSCAR-00106", "08004", 106);
                            }
                        }
                        continue;
                    }
                    if (bk instanceof ErrorResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), bk);
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)bk;
                        throw new OSQLException(errorPacket.getErrorCode(), EncodeUtil.tryDecode(errorPacket.getSQLState()), EncodeUtil.tryDecode(errorPacket.getErrorMessage()));
                    }
                    if (bk instanceof NoticeResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), bk);
                        this.connection.addWarning(EncodeUtil.tryDecode(((NoticeResponsePacket)bk).getNoticeMessage()), EncodeUtil.tryDecode(((NoticeResponsePacket)bk).getSQLState()));
                        continue;
                    }
                    if (bk instanceof AuthenticationPacketV3) {
                        byte[] byteUser = this.connection.getClientEncoding().encode(this.db_user);
                        bytePassword = this.connection.getClientEncoding().encode(this.getDbPassword());
                        this.getMessage(this.oStream.getInputStream(), bk);
                        authPolicy = ((AuthenticationPacketV3)bk).getAuthenPolicy();
                        switch (authPolicy) {
                            case 0: {
                                break;
                            }
                            case 3: {
                                if (isEncrypted) {
                                    upp = new UnencryptedPasswordPacket(bytePassword);
                                    upp.setConnection(this.connection);
                                    this.sendMessage(this.oStream.getBufferedOutputStream(), upp);
                                    break;
                                }
                                throw new OSQLException("OSCAR-00106", "08004", 106);
                            }
                            case 5: {
                                md5Salt = (byte[])((AuthenticationPacketV3)bk).getSalt();
                                digest = MD5Digest.encode(byteUser, bytePassword, md5Salt);
                                uppmd5 = new UnencryptedPasswordPacket(digest);
                                uppmd5.setConnection(this.connection);
                                this.sendMessage(this.oStream.getBufferedOutputStream(), uppmd5);
                                break;
                            }
                            case 7: {
                                if (isEncrypted && this.info.getProperty("HDENCRYPT", "f").equals("t")) {
                                    md5Salt = (byte[])((AuthenticationPacketV3)bk).getSalt();
                                    digest1 = MD5Digest.encodeWithHdEncrypt(byteUser, bytePassword, md5Salt);
                                    uppsm3 = new UnencryptedPasswordPacket(digest1);
                                    uppsm3.setConnection(this.connection);
                                    this.sendMessage(this.oStream.getBufferedOutputStream(), uppsm3);
                                    break;
                                }
                                throw new OSQLException("OSCAR-00106", "08004", 106);
                            }
                            case 10: 
                            case 11: 
                            case 12: {
                                ((AuthenticationPacketV3)bk).getScramSupport().setPassword(this.getDbPassword());
                                this.sendMessage(this.oStream.getBufferedOutputStream(), bk);
                                break;
                            }
                            default: {
                                throw new OSQLException("OSCAR-00106", "08004", 106);
                            }
                        }
                        config.setProtocolType(((AuthenticationPacketV3)bk).getVersionNum());
                        continue;
                    }
                    throw new OSQLException("OSCAR-00106", "08004", 106);
                } while (authPolicy != 0);
                do {
                    if ((bk = this.getMessage(this.oStream.getInputStream())) instanceof ReadyForQueryPacket) {
                        this.getMessage(this.oStream.getInputStream(), bk);
                        continue;
                    }
                    if (bk instanceof BackendKeyPacket) {
                        this.getMessage(this.oStream.getInputStream(), bk);
                        this.pid = ((BackendKeyPacket)bk).getPID();
                        this.ckey = ((BackendKeyPacket)bk).getCKey();
                        continue;
                    }
                    if (bk instanceof ErrorResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), bk);
                        throw new OSQLException(((ErrorResponsePacket)bk).getErrorCode(), EncodeUtil.tryDecode(((ErrorResponsePacket)bk).getSQLState()), EncodeUtil.tryDecode(((ErrorResponsePacket)bk).getErrorMessage()));
                    }
                    if (bk instanceof NoticeResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), bk);
                        this.connection.addWarning(EncodeUtil.tryDecode(((NoticeResponsePacket)bk).getNoticeMessage()), EncodeUtil.tryDecode(((NoticeResponsePacket)bk).getSQLState()));
                        continue;
                    }
                    if (bk instanceof MessagePacket) {
                        String serverVersion;
                        this.getMessage(this.oStream.getInputStream(), bk);
                        HashMap<String, String> maps = ((MessagePacket)bk).getMessageMap();
                        if (maps == null || (serverVersion = maps.get("server_version")) == null) continue;
                        if (serverVersion.equalsIgnoreCase("stmpp")) {
                            config.setMpp5(true);
                            continue;
                        }
                        if (!serverVersion.equalsIgnoreCase("kstore")) continue;
                        config.setKstore(true);
                        continue;
                    }
                    throw new OSQLException("OSCAR-00107", "08001", 107);
                } while (!(bk instanceof ReadyForQueryPacket));
                this.oStream.setSocketTimeOut(this.requestTimeOut);
            }
            catch (SocketTimeoutException e) {
                if (this.oStream != null) {
                    try {
                        this.oStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new OSQLException("OSCAR-00107", "08001", 107, e.getMessage(), e);
            }
            catch (IOException e) {
                throw new OSQLException("OSCAR-00107", "08001", 107, e.getMessage(), e);
            }
        }
    }

    private void sendMessage(BufferedOutputStream stream, BasePacket packet) throws IOException, SQLException {
        packet.sendTo(stream);
    }

    private BasePacket getMessage(InputStream stream) throws IOException, SQLException {
        byte[] tagTemp = new byte[1];
        stream.read(tagTemp, 0, 1);
        char tag = (char)tagTemp[0];
        if (this.logFlag) {
            if ('\uffa1' == tag) {
                Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), ProtocolManager.class + ", getMessage(InputStream stream)), return tag: 0xA1");
            } else {
                Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), ProtocolManager.class + ", getMessage(InputStream stream)), return tag: " + tag);
            }
        }
        return this.pk.getInstance(tag, this.connection);
    }

    private void getMessage(InputStream stream, BasePacket packet) throws IOException, SQLException {
        packet.receiveFrom(stream);
    }

    private String getDbPassword() {
        String dbwd = this.info.getProperty("PASSWORD");
        return dbwd == null ? "" : dbwd;
    }

    public OSCARProtocol createProtocol(boolean compatibleOldProtocal) throws IOException {
        OSCARProtocol protocol = null;
        if (compatibleOldProtocal) {
            this.connection.getProtocolVersion().setProtocolType(1);
        }
        if (this.connection.getProtocolVersion().getProtocolType() == 1) {
            protocol = new OSCARProtocol(this.connection, this.host, this.port, this.database, this.db_user, this.getDbPassword(), this.info, this.oStream);
        } else {
            this.oStream.reInitStream(true);
            protocol = new OSCARProtocolV2(this.connection, this.host, this.port, this.database, this.db_user, this.getDbPassword(), this.info, this.oStream);
        }
        if (protocol != null) {
            protocol.setPid(this.pid);
            protocol.setCkey(this.ckey);
        }
        return protocol;
    }

    public OStream getoStream() {
        return this.oStream;
    }
}

