/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.core.FieldMetadata;
import com.oscar.gis.OscarObject;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.util.OSQLException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class OscarResultSetMetaData
implements ResultSetMetaData {
    private Field[] fields;
    protected OscarJdbc2Connection connection;
    protected boolean rsDateWithHMS;
    protected final int compatableDbms;
    private boolean fieldInfoFetched = false;
    private boolean useColumnLabel = true;
    private boolean useAttributedef = false;

    public OscarResultSetMetaData(Field[] fields) {
        this.fields = fields == null ? new Field[0] : fields;
        this.compatableDbms = 0;
    }

    public OscarResultSetMetaData(Field[] fields, OscarJdbc2Connection connection) {
        this.fields = fields == null ? new Field[0] : fields;
        this.connection = connection;
        Properties properties = connection.getConnectionProperties();
        this.rsDateWithHMS = Boolean.parseBoolean(properties.getProperty("RSDATEWITHHMS", "false"));
        this.compatableDbms = Integer.parseInt(properties.getProperty("COMPATABLE_DBMS", "0"));
        this.useColumnLabel = Boolean.parseBoolean(properties.getProperty("USECOLUMNLABEL", "TRUE"));
        this.useAttributedef = Boolean.parseBoolean(properties.getProperty("USEATTRIBUTEDEF", "FALSE"));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.getFieldMetaData();
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata != null && metadata.isAutoIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFieldMetaData() throws SQLException {
        if (this.fieldInfoFetched) {
            return;
        }
        if (this.populateFieldsWithMetadata(this.connection.getFieldMetadataCache())) {
            return;
        }
        ProtocolVersion protocolVersion = this.connection.getProtocolVersion();
        StringBuilder sql = new StringBuilder("SELECT c.oid, a.attnum, a.attname, c.relname, n.nspname, t.typname, ");
        sql.append(this.useAttributedef ? "a.adsrc," : "d.adsrc, ").append(" a.attnotnull, ");
        if (!protocolVersion.isMpp5() && !protocolVersion.isKstore() && this.connection.isSupportAuto()) {
            sql.append(" a.attisauto ");
        } else {
            sql.append(" 'false' attisauto ");
        }
        sql.append("FROM INFO_SCHEM.v_sys_class c \n").append("JOIN INFO_SCHEM.v_sys_namespace n ON (c.relnamespace = n.oid) \n");
        if (this.useAttributedef) {
            sql.append("JOIN INFO_SCHEM.v_sys_attributedef a ON (c.oid = a.attrelid) \n");
            sql.append("JOIN INFO_SCHEM.v_sys_type t ON (a.atttypid = t.oid) \n");
        } else {
            sql.append("JOIN INFO_SCHEM.v_sys_attribute a ON (c.oid = a.attrelid) \n");
            sql.append("JOIN INFO_SCHEM.v_sys_type t ON (a.atttypid = t.oid) \n");
            sql.append("LEFT JOIN INFO_SCHEM.v_sys_attrdef d ON (d.adrelid = a.attrelid AND d.adnum = a.attnum) \n");
        }
        sql.append("WHERE c.oid in (");
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : this.fields) {
            String key;
            if (field.getMetadata() != null || fieldMap.containsKey(key = field.getSchemaName() + "_" + field.getTableName())) continue;
            fieldMap.put(key, field);
        }
        boolean hasSourceInfo = false;
        Set entrys = fieldMap.entrySet();
        for (Map.Entry entry : entrys) {
            if (hasSourceInfo) {
                sql.append(" , ");
            }
            Field field = (Field)entry.getValue();
            sql.append(this.getTableOid(field.getSchemaName(), field.getTableName()));
            if (hasSourceInfo) continue;
            hasSourceInfo = true;
        }
        sql.append(" ) AND a.attnum>0 AND ATTISDROPPED = false");
        if (!hasSourceInfo) {
            this.fieldInfoFetched = true;
            return;
        }
        HashMap<FieldMetadata.Key, FieldMetadata> md = new HashMap<FieldMetadata.Key, FieldMetadata>();
        try (BaseResultSet rs = null;){
            block21: {
                try {
                    rs = this.connection.execSQL(sql.toString());
                }
                catch (SQLException e) {
                    if (e.getMessage() == null) break block21;
                    if (e.getMessage().toUpperCase().contains("V_SYS_ATTRIBUTEDEF")) {
                        int start = sql.indexOf("INFO_SCHEM.v_sys_attributedef");
                        int end = sql.indexOf("WHERE c.oid");
                        sql.replace(sql.indexOf("a.adsrc"), sql.indexOf("a.adsrc") + "a.adsrc".length(), "d.adsrc");
                        sql.replace(start, end, "INFO_SCHEM.v_sys_attribute a ON (c.oid = a.attrelid) \n JOIN INFO_SCHEM.v_sys_type t ON (a.atttypid = t.oid) \nLEFT JOIN INFO_SCHEM.v_sys_attrdef d ON (d.adrelid = a.attrelid AND d.adnum = a.attnum) ");
                        rs = this.connection.execSQL(sql.toString());
                    }
                    if (e.getMessage() == null || !e.getMessage().toUpperCase().contains("ATTISAUTO")) break block21;
                    this.connection.setSupportAuto(false);
                    rs = this.connection.execSQL(sql.toString().replace("a.attisauto", "'false' attisauto"));
                }
            }
            if (rs != null) {
                while (rs.next()) {
                    String columnName = rs.getString(3);
                    String tableName = rs.getString(4);
                    String schemaName = rs.getString(5);
                    int nullable = rs.getBoolean(8) ? 0 : 1;
                    boolean autoIncrement = rs.getBoolean(9);
                    if (!autoIncrement) {
                        String def = rs.getString(7);
                        String typeName = rs.getString(6);
                        if (def != null && typeName != null && def.startsWith("NEXTVAL") && (typeName.equals("INT4") || typeName.equals("INT8"))) {
                            autoIncrement = true;
                        }
                    }
                    FieldMetadata fieldMetadata = new FieldMetadata(columnName, tableName, schemaName, nullable, autoIncrement);
                    FieldMetadata.Key key = new FieldMetadata.Key(schemaName, tableName, columnName);
                    md.put(key, fieldMetadata);
                }
            }
        }
        this.populateFieldsWithMetadata(md);
        this.connection.getFieldMetadataCache().putAll(md);
    }

    private boolean populateFieldsWithMetadata(Map<FieldMetadata.Key, FieldMetadata> metadata) {
        boolean allOk = true;
        for (Field field : this.fields) {
            if (field.getMetadata() != null) continue;
            FieldMetadata fieldMetadata = metadata.get(new FieldMetadata.Key(field.getSchemaName(), field.getTableName(), field.getAliasName()));
            if (fieldMetadata == null) {
                allOk = false;
                continue;
            }
            field.setMetadata(fieldMetadata);
        }
        this.fieldInfoFetched |= allOk;
        return allOk;
    }

    private String getTableOid(String schemaName, String tableName) {
        return "INFO_SCHEM.sys_get_relid('" + schemaName + "', '" + tableName + "')";
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: {
                return false;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getField(column).isNullable();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        Field f = this.getField(column);
        int typmod = f.getMod();
        switch (f.getSQLType()) {
            case -6: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 20;
            }
            case 7: {
                return 14;
            }
            case 6: 
            case 8: {
                return 24;
            }
            case -7: {
                if (typmod == -1) {
                    return 1;
                }
                return typmod;
            }
            case 16: {
                return 1;
            }
            case 2: 
            case 3: {
                int size = typmod >> 16 & 0xFFFF;
                return size + 2;
            }
            case 1: 
            case 12: {
                if (f.getOID() == 18) {
                    return typmod;
                }
                if (typmod == -1) {
                    return 8000;
                }
                return typmod - 4;
            }
            case -1: {
                return 8000;
            }
            case -3: 
            case -2: {
                if (typmod == -1) {
                    return 1;
                }
                return typmod - 4;
            }
            case -4: {
                return 8000;
            }
            case 2004: 
            case 2005: {
                return Integer.MAX_VALUE;
            }
            case 91: {
                return 10;
            }
            case 92: {
                if (typmod == -1) {
                    return 18;
                }
                return typmod;
            }
            case 93: {
                if (typmod == -1) {
                    return 29;
                }
                return typmod;
            }
        }
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getField(column).getAliasNameCase();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (this.useColumnLabel) {
            return this.getColumnLabel(column);
        }
        String columnName = this.getField(column).getNameCase();
        if (columnName == null || columnName.isEmpty()) {
            return this.getColumnLabel(column);
        }
        return columnName;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getField(column).getSchemaName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        Field f = this.getField(column);
        int sql_type = f.getSQLType();
        switch (sql_type) {
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 7: {
                return 8;
            }
            case 6: 
            case 8: {
                return 15;
            }
            case -7: {
                return f.getMod();
            }
            case 16: {
                return 0;
            }
            case 2: 
            case 3: {
                if (f.getMod() == -1) {
                    return this.compatableDbms == 1 ? 0 : 18;
                }
                return 0xFFFF & f.getMod() - 4 >> 16;
            }
            case 1: 
            case 12: {
                if (1186 == f.getOID() || 1188 == f.getOID()) {
                    return (0xFF00 & f.getMod()) >> 8;
                }
                return this.getColumnDisplaySize(column);
            }
            case -3: 
            case -2: {
                return this.getColumnDisplaySize(column);
            }
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                return 0;
            }
            case 91: {
                return 8;
            }
            case 92: {
                return 15;
            }
            case 93: {
                return 23;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        Field f = this.getField(column);
        int sql_type = f.getSQLType();
        switch (sql_type) {
            case 2: 
            case 3: {
                if (f.getMod() == -1) {
                    return 0;
                }
                return (short)(0xFFFF & f.getMod() - 4);
            }
            case 1188: {
                return 0xFF & f.getMod();
            }
        }
        if (1188 == f.getOID()) {
            return 0xFF & f.getMod();
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getField(column).getTableName();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int type = this.getField(column).getSQLType();
        return type == 91 && this.rsDateWithHMS ? 93 : type;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getField(column).getDBType();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return !this.isWritable(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.getField(column).isUpdatable();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    protected Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        return this.fields[columnIndex - 1];
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        switch (this.getField(column).getSQLType()) {
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case -7: 
            case 16: {
                return "java.lang.Boolean";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -4: 
            case -3: 
            case -2: {
                return "[B";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 2004: {
                return "java.sql.Blob";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 2002: {
                return "java.sql.Struct";
            }
            case 2006: {
                return "java.sql.Ref";
            }
            case 2003: {
                return "java.sql.Array";
            }
            case 70: {
                return "java.net.URL";
            }
            case 1111: {
                String columnTypeName = this.getColumnTypeName(column);
                Class<? extends OscarObject> oscarObject = this.connection.getOscarObject(columnTypeName);
                if (oscarObject != null) {
                    return oscarObject.getName();
                }
                return "java.lang.String";
            }
        }
        throw new OSQLException("OSCAR-00411", "88888", 411);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }
}

