/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.jdbc.EscapeProcessorResult;
import com.oscar.jdbc.EscapeTokenizer;
import com.oscar.jdbc.StringUtils;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.TimeUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

class EscapeProcessor {
    EscapeProcessor() {
    }

    public static final Object escapeSQL(String sql, boolean serverSupportsConvertFn) throws SQLException {
        int nextEndBrace;
        boolean replaceEscapeSequence = false;
        String escapeSequence = null;
        if (sql == null) {
            return null;
        }
        int beginBrace = sql.indexOf(123);
        int n = nextEndBrace = beginBrace == -1 ? -1 : sql.indexOf(125, beginBrace);
        if (nextEndBrace == -1) {
            return sql;
        }
        StringBuilder newSql = new StringBuilder();
        EscapeTokenizer escapeTokenizer = new EscapeTokenizer(sql);
        byte usesVariables = 0;
        while (escapeTokenizer.hasMoreTokens()) {
            String token = escapeTokenizer.nextToken();
            if (token.length() == 0) continue;
            if (token.charAt(0) == '{') {
                String collapsedToken;
                int nestedBrace;
                if (!token.endsWith("}")) {
                    throw new OSQLException("Not a valid escape sequence: " + token, "42000", 202);
                }
                if (token.length() > 2 && (nestedBrace = token.indexOf(123, 2)) != -1) {
                    StringBuffer buf = new StringBuffer(token.substring(0, 1));
                    Object remainingResults = EscapeProcessor.escapeSQL(token.substring(1, token.length() - 1), serverSupportsConvertFn);
                    String remaining = null;
                    if (remainingResults instanceof String) {
                        remaining = (String)remainingResults;
                    } else {
                        remaining = ((EscapeProcessorResult)remainingResults).escapedSql;
                        if (usesVariables != 1) {
                            usesVariables = ((EscapeProcessorResult)remainingResults).usesVariables;
                        }
                    }
                    buf.append(remaining);
                    buf.append('}');
                    token = buf.toString();
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken = EscapeProcessor.removeWhitespace(token), "{escape")) {
                    try {
                        StringTokenizer st = new StringTokenizer(token, " '");
                        st.nextToken();
                        escapeSequence = st.nextToken();
                        if (escapeSequence.length() < 3) {
                            newSql.append(token);
                            continue;
                        }
                        escapeSequence = escapeSequence.substring(1, escapeSequence.length() - 1);
                        replaceEscapeSequence = true;
                    }
                    catch (NoSuchElementException e) {
                        newSql.append(token);
                    }
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{fn")) {
                    int startPos = token.toLowerCase().indexOf("fn ") + 3;
                    int endPos = token.length() - 1;
                    String fnToken = token.substring(startPos, endPos);
                    newSql.append(OscarSqlProcessor.funcNameReplace(fnToken));
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{d")) {
                    int startPos = token.indexOf(39) + 1;
                    int endPos = token.lastIndexOf(39);
                    if (startPos == -1 || endPos == -1) {
                        newSql.append(token);
                        continue;
                    }
                    String argument = token.substring(startPos, endPos);
                    try {
                        StringTokenizer st = new StringTokenizer(argument, " -");
                        String year4 = st.nextToken();
                        String month2 = st.nextToken();
                        String day2 = st.nextToken();
                        String dateString = "'" + year4 + "-" + month2 + "-" + day2 + "'";
                        newSql.append(dateString);
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new OSQLException("Syntax error for DATE escape sequence '" + argument + "'", "42000", 202, e);
                    }
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{ts")) {
                    EscapeProcessor.processTimestampToken(TimeZone.getDefault(), newSql, token, true, true);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{t")) {
                    EscapeProcessor.processTimeToken(newSql, token, true);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{call") || StringUtils.startsWithIgnoreCase(collapsedToken, "{?=call")) {
                    newSql.append(token);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{oj")) {
                    int startPos = StringUtils.indexOfIgnoreCase(token, "OJ") + 2;
                    int endPos = token.lastIndexOf("}");
                    newSql.append(token.substring(startPos, endPos));
                    continue;
                }
                newSql.append(collapsedToken);
                continue;
            }
            newSql.append(token);
        }
        String escapedSql = newSql.toString();
        if (replaceEscapeSequence) {
            String currentSql = escapedSql;
            while (currentSql.indexOf(escapeSequence) != -1) {
                int escapePos = currentSql.indexOf(escapeSequence);
                String lhs = currentSql.substring(0, escapePos);
                String rhs = currentSql.substring(escapePos + 1, currentSql.length());
                currentSql = lhs + "\\" + rhs;
            }
            escapedSql = currentSql;
        }
        EscapeProcessorResult epr = new EscapeProcessorResult();
        epr.escapedSql = escapedSql;
        if (usesVariables != 1) {
            epr.usesVariables = escapeTokenizer.sawVariableUse() ? (byte)1 : 0;
        }
        return epr;
    }

    private static void processTimestampToken(TimeZone tz, StringBuilder newSql, String token, boolean serverSupportsFractionalSecond, boolean serverTruncatesFractionalSecond) throws SQLException {
        int startPos = token.indexOf(39) + 1;
        int endPos = token.lastIndexOf(39);
        if (startPos == -1 || endPos == -1) {
            newSql.append(token);
        } else {
            String argument = token.substring(startPos, endPos);
            try {
                Timestamp ts = Timestamp.valueOf(argument);
                ts = TimeUtil.adjustNanosPrecision(ts, 6, !serverTruncatesFractionalSecond);
                SimpleDateFormat tsdf = TimeUtil.getSimpleDateFormat(null, "''yyyy-MM-dd HH:mm:ss", tz);
                newSql.append(tsdf.format(ts));
                if (serverSupportsFractionalSecond && ts.getNanos() > 0) {
                    newSql.append('.');
                    newSql.append(TimeUtil.formatNanos(ts.getNanos(), 6));
                }
                newSql.append('\'');
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OSQLException("ERROR, parser: syntax error at or near '" + token + "'", "42000", 202);
            }
        }
    }

    private static void processTimeToken(StringBuilder newSql, String token, boolean serverSupportsFractionalSecond) throws SQLException {
        int startPos = token.indexOf(39) + 1;
        int endPos = token.lastIndexOf(39);
        if (startPos == -1 || endPos == -1) {
            newSql.append(token);
        } else {
            String argument = token.substring(startPos, endPos);
            try {
                StringTokenizer st = new StringTokenizer(argument, " :.");
                String hour = st.nextToken();
                String minute = st.nextToken();
                String second = st.nextToken();
                String fractionalSecond = "";
                if (serverSupportsFractionalSecond && st.hasMoreTokens()) {
                    fractionalSecond = "." + st.nextToken();
                }
                newSql.append("'");
                newSql.append(hour);
                newSql.append(":");
                newSql.append(minute);
                newSql.append(":");
                newSql.append(second);
                if (serverSupportsFractionalSecond) {
                    newSql.append(fractionalSecond);
                }
                newSql.append("'");
            }
            catch (NoSuchElementException e) {
                throw new OSQLException("ERROR, parser: syntax error at or near '" + token + "'", "42000", 202);
            }
        }
    }

    private static String removeWhitespace(String toCollapse) {
        if (toCollapse == null) {
            return null;
        }
        int length = toCollapse.length();
        StringBuffer collapsed = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = toCollapse.charAt(i);
            if (Character.isWhitespace(c)) continue;
            collapsed.append(c);
        }
        return collapsed.toString();
    }
}

