/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ae;

import com.oscar.Driver;
import com.oscar.ae.ColumnMasterKey;
import com.oscar.ae.EncryptionCommon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CmkManager {
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    private final Map<String, ColumnMasterKey> CMK_MAP = new ConcurrentHashMap<String, ColumnMasterKey>();
    private final SecureRandom secureRandom = new SecureRandom();
    private static final int CMK_FILE_PRIVATE_KEY = 1;
    private static final int CMK_FILE_PRIVATE_KEY_RAND = 2;
    private static final int CMK_FILE_PUBLIC_KEY = 3;
    private static final int CMK_FILE_PUBLIC_KEY_RAND = 4;
    private static final Map<Integer, String> CMK_FILE_POSTFIX_MAP = new HashMap<Integer, String>(){
        {
            this.put(1, ".pri");
            this.put(2, ".pri.rand");
            this.put(3, ".pub");
            this.put(4, ".pub.rand");
        }
    };

    private CmkManager() {
    }

    public static CmkManager singleton() {
        return SingletonHandler.INSTANCE;
    }

    public ColumnMasterKey getCmkOrFind(String cmkFilePath, Boolean privateExpected) throws Exception {
        ColumnMasterKey cmKey = null;
        if (cmkFilePath != null) {
            cmKey = this.CMK_MAP.get(cmkFilePath);
        }
        boolean valid = false;
        if (cmKey != null) {
            if (privateExpected == null) {
                valid = cmKey.getPrivateKeyInfo() != null && cmKey.getPublicKeyInfo() != null;
            } else {
                boolean bl = privateExpected.booleanValue() ? cmKey.getPrivateKeyInfo() != null : (valid = cmKey.getPublicKeyInfo() != null);
            }
        }
        if (valid) {
            return cmKey;
        }
        ColumnMasterKey localCmKey = this.findLocalCmk(cmkFilePath, privateExpected);
        if (localCmKey != null) {
            this.CMK_MAP.put(cmkFilePath, localCmKey);
            if (privateExpected != null && cmKey != null) {
                if (privateExpected.booleanValue()) {
                    localCmKey.setPublicKeyInfo(cmKey.getPublicKeyInfo());
                } else {
                    localCmKey.setPrivateKeyInfo(cmKey.getPrivateKeyInfo());
                }
            }
        }
        return localCmKey;
    }

    public ColumnMasterKey findLocalCmk(String cmkFilePath, Boolean privateKey) throws Exception {
        if (privateKey == null) {
            ColumnMasterKey privateCmkey = this.findLocalCmk(cmkFilePath, true);
            ColumnMasterKey publicCmkey = this.findLocalCmk(cmkFilePath, false);
            privateCmkey.setPublicKeyInfo(publicCmkey.getPublicKeyInfo());
            return privateCmkey;
        }
        return this.findLocalCmk(cmkFilePath, (boolean)privateKey);
    }

    public ColumnMasterKey findLocalCmk(String cmkFilePath, boolean privateKey) throws Exception {
        int keyInt = privateKey ? 1 : 3;
        File keyFile = new File(cmkFilePath + CMK_FILE_POSTFIX_MAP.get(keyInt));
        if (!keyFile.isFile() || !keyFile.exists()) {
            throw new FileNotFoundException(keyFile.getAbsolutePath());
        }
        int randInt = privateKey ? 2 : 4;
        File randFile = new File(cmkFilePath + CMK_FILE_POSTFIX_MAP.get(randInt));
        if (!randFile.isFile() || !randFile.exists()) {
            throw new FileNotFoundException(randFile.getAbsolutePath());
        }
        byte[] keyBites = CmkManager.readKeyFromFile(keyFile);
        if (this.logFlag) {
            Driver.writeLog("---------------\u8bfb\u51fa\u7684 " + (privateKey ? "private" : "public") + " key \u5bc6\u6587---------------");
            Driver.writeLog(Arrays.toString(keyBites));
        }
        byte[] secretAndIvBites = CmkManager.readKeyFromFile(randFile);
        byte[] ivBites = new byte[16];
        byte[] secretBites = new byte[secretAndIvBites.length - ivBites.length];
        System.arraycopy(secretAndIvBites, 0, secretBites, 0, secretBites.length);
        System.arraycopy(secretAndIvBites, secretBites.length, ivBites, 0, ivBites.length);
        if (this.logFlag) {
            Driver.writeLog("---------------\u8bfb\u51fa\u7684 " + (privateKey ? "private" : "public") + " rand---------------");
            Driver.writeLog(Arrays.toString(secretBites));
            Driver.writeLog(Arrays.toString(ivBites));
        }
        String password = new String(secretBites, EncryptionCommon.ISO_8859_1);
        byte[] key = EncryptionCommon.decryptKey_AES128_CBC_HMAC_SHA256(keyBites, password, ivBites);
        if (this.logFlag) {
            Driver.writeLog("---------------\u89e3\u5bc6\u7684 " + (privateKey ? "private" : "public") + " key---------------");
            Driver.writeLog(Arrays.toString(key));
        }
        ColumnMasterKey cmk = new ColumnMasterKey();
        if (privateKey) {
            cmk.setPrivateKeyInfo(secretBites, ivBites, key, keyBites);
        } else {
            cmk.setPublicKeyInfo(secretBites, ivBites, key, keyBites);
        }
        cmk.setPath(cmkFilePath);
        return cmk;
    }

    public ColumnMasterKey generateNew(Connection conn, String cmkFilePath, String cmkeyName, String keyStoreProviderName) throws Exception {
        ColumnMasterKey cmk = new ColumnMasterKey();
        cmk.setKeyName(cmkeyName);
        File cmkDir = new File(cmkFilePath);
        cmkDir.mkdirs();
        HashMap<Integer, File> fileMap = new HashMap<Integer, File>();
        for (Map.Entry<Integer, String> postfixEntry : CMK_FILE_POSTFIX_MAP.entrySet()) {
            File file = new File(cmkDir, cmkeyName + postfixEntry.getValue());
            if (file.isFile() && file.exists()) {
                throw new Exception("\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff1a" + file.getAbsolutePath());
            }
            fileMap.put(postfixEntry.getKey(), file);
        }
        for (File file : fileMap.values()) {
            if (file.exists() || file.createNewFile()) continue;
            this.deleteAllFile(fileMap);
            throw new Exception("\u6587\u4ef6\u521b\u5efa\u5931\u8d25:" + file);
        }
        this._generateKey(cmk);
        try {
            ColumnMasterKey.KeyInfo privateKeyInfo = cmk.getPrivateKeyInfo();
            ColumnMasterKey.KeyInfo publicKeyInfo = cmk.getPublicKeyInfo();
            CmkManager.saveKeyToFile(privateKeyInfo.getEncryptedValueBytes(), (File)fileMap.get(1));
            CmkManager.saveKeyToFile(publicKeyInfo.getEncryptedValueBytes(), (File)fileMap.get(3));
            int secretKeyLen = privateKeyInfo.getSecretKeyBytes().length;
            int ivLen = privateKeyInfo.getIvBytes().length;
            byte[] after = new byte[secretKeyLen + ivLen];
            System.arraycopy(privateKeyInfo.getSecretKeyBytes(), 0, after, 0, secretKeyLen);
            System.arraycopy(privateKeyInfo.getIvBytes(), 0, after, secretKeyLen, ivLen);
            CmkManager.saveKeyToFile(after, (File)fileMap.get(2));
            secretKeyLen = publicKeyInfo.getSecretKeyBytes().length;
            ivLen = publicKeyInfo.getIvBytes().length;
            after = new byte[secretKeyLen + ivLen];
            System.arraycopy(publicKeyInfo.getSecretKeyBytes(), 0, after, 0, secretKeyLen);
            System.arraycopy(publicKeyInfo.getIvBytes(), 0, after, secretKeyLen, ivLen);
            CmkManager.saveKeyToFile(after, (File)fileMap.get(4));
        }
        catch (Exception e) {
            if (this.logFlag) {
                Driver.writeLog(e);
            }
            this.deleteAllFile(fileMap);
            throw e;
        }
        File tmpFile = new File(cmkDir, cmkeyName);
        String absolutePath = tmpFile.getAbsolutePath();
        absolutePath = absolutePath.replaceAll("\\\\", "/");
        cmk.setPath(absolutePath);
        try {
            this.saveTo(conn, cmkeyName, keyStoreProviderName, absolutePath);
        }
        catch (Exception e) {
            if (this.logFlag) {
                Driver.writeLog(e);
            }
            this.deleteAllFile(fileMap);
            throw e;
        }
        return cmk;
    }

    private void deleteAllFile(Map<Integer, File> fileMap) {
        File file = null;
        file = fileMap.get(1);
        if (file != null) {
            file.delete();
        }
        if ((file = fileMap.get(2)) != null) {
            file.delete();
        }
        if ((file = fileMap.get(3)) != null) {
            file.delete();
        }
        if ((file = fileMap.get(4)) != null) {
            file.delete();
        }
        fileMap.clear();
    }

    protected String createPassword() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 16);
    }

    protected byte[] createBytes(int size) {
        byte[] tmp = new byte[size];
        this.secureRandom.nextBytes(tmp);
        return tmp;
    }

    private ColumnMasterKey _generateKey(ColumnMasterKey cmk) throws Exception {
        KeyPair keyPair = EncryptionCommon.generateKeyPair();
        this.encryptKey(cmk, keyPair.getPrivate());
        this.encryptKey(cmk, keyPair.getPublic());
        return cmk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTo(Connection conn, String cmkeyName, String keyStoreProviderName, String keyPath) throws SQLException {
        String sqlString = "CREATE COLUMN MASTER KEY %key_name%   \r\n    WITH (  \r\n        KEY_STORE_PROVIDER_NAME = '%KEY_STORE_PROVIDER_NAME%',  \r\n        KEY_PATH = '%KEY_PATH%'  \r\n         )";
        sqlString = sqlString.replaceFirst("%key_name%", cmkeyName);
        sqlString = sqlString.replaceFirst("%KEY_STORE_PROVIDER_NAME%", keyStoreProviderName);
        sqlString = sqlString.replaceFirst("%KEY_PATH%", keyPath);
        try (Statement stmt = null;){
            stmt = conn.createStatement();
            stmt.execute(sqlString);
        }
    }

    public void encryptKey(ColumnMasterKey cmk, PrivateKey key) throws Exception {
        String password = this.createPassword();
        byte[] ivOrSalt = this.createBytes(16);
        byte[] encryptedValue = EncryptionCommon.encryptKey_AES128_CBC_HMAC_SHA256(key.getEncoded(), password, ivOrSalt);
        cmk.setPrivateKeyInfo(password.getBytes(EncryptionCommon.ISO_8859_1), ivOrSalt, key.getEncoded(), encryptedValue);
        if (this.logFlag) {
            Driver.writeLog("cmk privatekey \u660e\u6587:" + Arrays.toString(cmk.getPrivateKeyInfo().getKeyValueRawBytes()));
            Driver.writeLog("cmk privatekey SecretKey:" + Arrays.toString(cmk.getPrivateKeyInfo().getSecretKeyBytes()));
            Driver.writeLog("cmk privatekey iv:" + Arrays.toString(cmk.getPrivateKeyInfo().getIvBytes()));
            Driver.writeLog("cmkprivatekey \u5bc6\u6587:" + Arrays.toString(cmk.getPrivateKeyInfo().getEncryptedValueBytes()));
        }
    }

    public void encryptKey(ColumnMasterKey cmk, PublicKey key) throws Exception {
        String password = this.createPassword();
        byte[] ivOrSalt = this.createBytes(16);
        byte[] encryptedValue = EncryptionCommon.encryptKey_AES128_CBC_HMAC_SHA256(key.getEncoded(), password, ivOrSalt);
        cmk.setPublicKeyInfo(password.getBytes(), ivOrSalt, key.getEncoded(), encryptedValue);
        if (this.logFlag) {
            Driver.writeLog("cmk publickey \u660e\u6587:" + Arrays.toString(cmk.getPublicKeyInfo().getKeyValueRawBytes()));
            Driver.writeLog("cmk publickey SecretKey:" + Arrays.toString(cmk.getPublicKeyInfo().getSecretKeyBytes()));
            Driver.writeLog("cmk publickey iv:" + Arrays.toString(cmk.getPublicKeyInfo().getIvBytes()));
            Driver.writeLog("cmk publickey \u5bc6\u6587:" + Arrays.toString(cmk.getPublicKeyInfo().getEncryptedValueBytes()));
        }
    }

    public static void saveKeyToFile(byte[] keyBites, File filename) throws IOException {
        try (FileOutputStream fileWriter = null;){
            fileWriter = new FileOutputStream(filename);
            fileWriter.write(keyBites);
            fileWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readKeyFromFile(File filename) throws IOException {
        try (FileInputStream fileReader = null;){
            fileReader = new FileInputStream(filename);
            byte[] data = new byte[fileReader.available()];
            fileReader.read(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropCmk(Connection conn, String cmkeyName, String keyFilePath) throws SQLException {
        String sqlString = "DROP COLUMN MASTER KEY " + cmkeyName;
        try (Statement stmt = null;){
            stmt = conn.createStatement();
            stmt.execute(sqlString);
        }
        HashMap<Integer, File> fileMap = new HashMap<Integer, File>();
        for (Map.Entry<Integer, String> postfixEntry : CMK_FILE_POSTFIX_MAP.entrySet()) {
            File file = new File(keyFilePath + postfixEntry.getValue());
            if (!file.isFile() || !file.exists()) continue;
            fileMap.put(postfixEntry.getKey(), file);
        }
        this.deleteAllFile(fileMap);
    }

    private static class SingletonHandler {
        private static final CmkManager INSTANCE = new CmkManager();

        private SingletonHandler() {
        }
    }
}

