/*
 * Decompiled with CFR 0.152.
 */
package com.oscar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Properties;

public class Config {
    private static String CLOB_ENCODING = System.getProperty("file.encoding");
    public static final String ENCODING = System.getProperty("file.encoding");
    private static Properties configProp;
    private static String configPath;
    private static String defultLogPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Properties pts = new Properties();
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/com/oscar/oscar.properties");
            pts.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            String path = null;
            try {
                URL url = Config.class.getProtectionDomain().getCodeSource().getLocation();
                path = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null).getPath();
                path = URLDecoder.decode(path, "utf-8");
            }
            catch (Exception e) {
                path = ".";
            }
            if (path != null) {
                if (path.endsWith("/") || path.endsWith("\\")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.endsWith(".jar")) {
                    int index = path.lastIndexOf("/");
                    if (index != -1) {
                        path = path.substring(0, index);
                    }
                    configPath = path + File.separator + "oscarconfig.properties";
                    defultLogPath = path + File.separator + "oscarJdbcLog";
                } else {
                    configPath = path + File.separator + ".." + File.separator + "oscarconfig.properties";
                    defultLogPath = path + File.separator + ".." + File.separator + "oscarJdbcLog";
                }
                File f = new File(configPath);
                if (f.exists()) {
                    is = new FileInputStream(f);
                    Properties tmpProp = new Properties();
                    tmpProp.load(is);
                    if (tmpProp != null) {
                        configProp = new Properties();
                        Object tmp = null;
                        String o = null;
                        Enumeration<Object> e = tmpProp.keys();
                        while (e.hasMoreElements()) {
                            tmp = e.nextElement();
                            o = ((String)tmp).toUpperCase();
                            configProp.put(o, tmpProp.get(tmp));
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            CLOB_ENCODING = pts.getProperty("CLOB_ENCODING", CLOB_ENCODING);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void msg(String msg) {
    }

    public static void msg(Exception e) {
    }

    public static void main(String[] args) {
        new Config().init();
        System.err.println("CLOB_ENCODING=" + CLOB_ENCODING);
        System.err.println("ENCODING=" + ENCODING);
    }

    public static Properties getConfigProp() {
        return configProp;
    }

    public static String getDefultLogPath() {
        return defultLogPath;
    }

    static {
        configPath = null;
        defultLogPath = null;
    }
}

