/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarParaMetaData;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarResultSetMetaData;
import com.oscar.jdbc.OscarStatement;
import com.oscar.util.OSQLException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class OscarPreparedStatement
extends OscarStatement
implements PreparedStatement {
    public OscarPreparedStatement(BaseConnection connection, String sql) throws SQLException {
        super(connection, sql);
        this.setStatementType(1);
    }

    @Override
    public BaseResultSet createResultSet(Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID) throws SQLException {
        return OscarResultSet.getInstance(this, fields, tuples, status, updateCount, insertOID, this.fetchSize, this.maxrows);
    }

    public void exitImplicitCacheToClose() throws SQLException {
        this.cacheState = (short)3;
        this.hardClose();
    }

    public void exitImplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws SQLException {
        String m_prepareSqlStatement;
        if (this.ddlSql) {
            m_prepareSqlStatement = this.m_sqlFragments[0];
            this.m_executeSqlFragments = new String[this.fragmentsCount];
            this.m_executeSqlFragments[0] = this.m_sqlFragments[0];
        } else {
            this.m_statementName = "J" + this.getNextPreparedCount();
            this.m_origSqlFragments = new String[this.m_sqlFragments.length];
            System.arraycopy(this.m_sqlFragments, 0, this.m_origSqlFragments, 0, this.m_sqlFragments.length);
            this.setSqlFragments();
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.append("PREPARE ");
                this.sbuf.append(this.m_statementName);
                this.sbuf.append(" AS ");
                this.sbuf.append(this.m_origSqlFragments[0]);
                m_prepareSqlStatement = this.sbuf.toString();
            }
        }
        if (this.connection.getVersion().isSendQueryNumForNotRealPrepare() && this.isNotRealPrepare() && !this.ddlSql) {
            this.setPrepareAndNotRealPrepare(true);
        }
        try {
            this.connection.execSQL(m_prepareSqlStatement, this);
        }
        catch (SQLException sqle) {
            this.m_statementName = null;
            throw sqle;
        }
        this.setPrepareAndNotRealPrepare(false);
        if (this.fragmentsCount > 1) {
            String getParamSQL = "GET PARAMINFO FOR " + this.m_statementName;
            this.connection.execSQL(getParamSQL);
            OscarParaMetaData pMetaDataTemp = (OscarParaMetaData)this.connection.getDefaultStatement().getParamInfo();
            this.pMetaData = new OscarParaMetaData(pMetaDataTemp.getParamInfor(), this);
            if (this instanceof CallableStatement && this.isResultNeeded) {
                OscarResultSetMetaData rsmd = (OscarResultSetMetaData)this.getMetaData();
                if (rsmd == null || rsmd.getColumnCount() == 0) {
                    throw new OSQLException("OSCAR-00401", "88888", 401);
                }
                Field f = rsmd.getField(1);
                Object[] returnParam = null;
                returnParam = this.connection.getVersion().isNewParamInfoPacket() ? new Object[6] : new Object[8];
                returnParam[0] = this.encoding.encode(f.getAliasName());
                returnParam[1] = f.getOID();
                returnParam[2] = (short)f.getLength();
                returnParam[3] = f.getMod();
                returnParam[4] = (byte)f.isNullable();
                returnParam[5] = (byte)2;
                this.pMetaData.addReturnParam(returnParam);
            }
        } else {
            this.pMetaData = new OscarParaMetaData(new Object[0][0], this);
        }
        this.m_sqlFragments = this.m_executeSqlFragments;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            List<StatementEventListener> listeners = this.connection.getStatementListeners();
            StatementEvent evt = null;
            StatementEventListener[] local = listeners.toArray(new StatementEventListener[listeners.size()]);
            for (int i = 0; i < local.length; ++i) {
                StatementEventListener listener = local[i];
                if (evt == null) {
                    evt = new StatementEvent(this.connection.getPc(), this);
                }
                listener.statementClosed(evt);
            }
        }
        super.close();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, (Clob)value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }
}

