/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.jdbc.OscarBulkInsertPrepareStatement;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.util.OscarSqlProcessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public class OscarJdbc2BulkConnection
extends OscarJdbc2Connection
implements BaseConnection,
Connection {
    private int bufferSize = 30;

    @Override
    public void openConnection(String host, int port, Properties info, String database, String url, Driver driver) throws SQLException {
        super.openConnection(host, port, info, database, url, driver);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String tmpSql = sql.trim();
        OscarSqlProcessor.ParseResult pResult = OscarSqlProcessor.parsingWithCheck(tmpSql = tmpSql.replaceAll("\r\n", " ").replaceAll("\n", " "), true);
        if (this.isInsertSql(pResult, tmpSql)) {
            tmpSql = pResult.getTransSql();
            OscarBulkInsertPrepareStatement s = new OscarBulkInsertPrepareStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, pResult, tmpSql);
            return s;
        }
        return super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    private boolean isInsertSql(OscarSqlProcessor.ParseResult pResult, String sql) {
        if (sql == null || sql.length() <= 0) {
            return false;
        }
        if (pResult != null) {
            return pResult.isInsertSql();
        }
        String tmpSql = sql.trim().toUpperCase();
        return tmpSql.matches("^\\s*INSERT\\s+INTO\\s+.+VALUES.+");
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

