/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Encoding;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.util.OSQLException;
import com.oscar.util.TableNameParser;
import com.oscar.util.converter.NumberConverter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class OscarDatabaseMetaData
implements DatabaseMetaData {
    private static final String keywords = "abort,absolute,access,accessed,action,add,admin,after,aggregate,all,alter,analyse,analyze,analyzer,and,any,archive,archivelog,array,as,asc,assertion,assignment,async,at,attributes,audit,auditfile,authid,authorization,auto_increment,autoextend,backup,backward,basicanalyzer,batchsize,before,begin,between,bigint,binary,binlog,bit,block,body,boolean,both,bpchar,buffer_pool,build,bulk,by,cache,call,called,cascade,cascaded,case,cast,cdc,chain,char,character,characteristics,cheat,check,check_constraints,checkpoint,chineseanalyzer,chunk,cjkanalyzer,class,clean,close,cluster,coalesce,codepage,collate,column,columns,comment,commit,committed,compile,complete,compress,configuration,connect,connect_by_iscycle,connect_by_isleaf,connect_by_root,constraint,constraints,constructor,content,context,controlfile,conversion,convert,copy,create,cross,csv,current,current_time,current_timestamp,current_user,cursor,cycle,data,database,databaselink,datafile,datafiletype,dateformat,day,dba,deallocate,debug,dec,decimal,declare,decode,decrypt,default,deferrable,deferred,definer,delete,delimiter,delimiters,demand,dense_rank,desc,description,deterministic,directory,disable,distinct,do,document,domain,double,drop,dump,each,else,enable,encoding,encrypt,encrypted,end,errors,escalation,escape,events,except,exchange,excluding,exclusive,exec,execute,exists,explain,export,external,externally,extract,false,fast,fetch,fieldterminator,file,filesize,fill,fire_triggers,first,firstrow,flashback,float,following,for,force,foreign,foreignkey_constraints,forever,formatfile,forward,freelists,freepools,from,full,fulltext,function,get,getaconststr,getclobval,global,global_name,globally,grant,greatest,group,guarantee,handler,hash,having,header,heap,hour,identified,if,ignore,ilike,immediate,immutable,implicit,import,import_polcol,in,including,increment,index,indexes,inherits,init,initial,initialized,initially,initrans,inner,inout,input,insensitive,insert,instead,int,integer,intersect,interval,into,invalidate,invisible,invoker,is,isnull,isolation,join,keep,keepidentity,keepnulls,key,kill,kilobytes_per_batch,kstore,lancompiler,language,last,lastrow,lc_collate,lc_ctype,leading,leak,least,left,less,level,lifetime,like,limit,list,listen,load,lob,local,localtime,localtimestamp,location,lock,log,logfile,logging,logical,long,loop,lsn,maintain_index,maintenance,match,matched,materialized,max,maxerrors,maxextends,maxsize,maxtrans,maxvalue,member,merge,min,minextends,minus,minute,minvalue,mod,mode,modify,month,mount,move,multicolumn,multiple,name,names,national,natural,nchar,never,new,next,nextval,no,noarchivelog,noaudit,nocache,nocompress,nocopy,nocycle,node,noguarantee,nologging,nomaxvalue,nominvalue,nomount,none,norecompute,normal,not,nothing,notify,notnull,novalidate,null,nullif,nulls,number,numeric,nvarchar2,nvl,nvl2,object,of,off,offline,offset,oids,old,on,online,only,open,operator,optimize,optimize_kscache,option,or,oracle,order,ordinality,organization,oscar,out,outer,over,overflow,overlaps,overlay,owner,package,pagesize,parameter,paraminfo,partial,partition,partitions,passing,password,path,pctfree,pctincrease,pctthreshold,pctused,pctversion,pendant,percent,petention,pfile,pipelined,placing,pls_integer,port,position,preceding,precision,prepare,preserve,preval,primary,prior,priority,privileges,procedural,procedure,public,purge,qu,query,quick,quote,range,raw,read,reads,real,rebuild,recheck,recovery,recycle,recyclebin,references,referencing,refresh,reject,relative,remove,rename,repeatable,replace,reset,resize,restart,restore,restrict,resume,retention,return,returning,returns,reuse,reverse,revoke,rewrite,right,role,rollback,row,rowdescription,rowid,rows,rows_per_batch,rowterminator,rowtype,rule,savepoint,scan,schema,scroll,second,security,segment,select,sequence,serializable,session,set,setof,share,show,shrink,shrinklog,shutdown,siblings,silently,similar,simple,single,singlerow,size,smallint,some,specification,split,stable,standalone,standardanalyzer,start,startfile,startpos,starttime,startup,statement,static,statistics,stdin,stdout,stopfile,stoppos,stoptime,stopwords,storage,store,strict,subpartition,subpartitions,substring,successful,suspend,switchover,sync,synonym,sys_connect_by_path,sysaux,sysid,system,table,tablespace,tablock,temp,tempfile,template,temporary,than,then,time,times,timestamp,timezone,tinyint,to,toast,top,trace,trail,trailing,transaction,transactional,treat,trigger,triggers,trim,true,truncate,trusted,tuple,type,unbounded,uncommitted,undo,unencrypted,union,unique,unknown,unlimited,unlisten,unlock,unmaintenance,until,unusable,up,update,updatelabel,updatexml,usage,use,user,using,vacuum,valid,validate,validation,validator,value,values,varbinary,varchar,varchar2,varying,verbose,version,view,visible,volatile,weight,when,whenever,where,window,with,without,work,write,xml,xmlattributes,xmlconcat,xmlelement,xmlforest,xmlparse,xmlpi,xmlroot,xmlserialize,xmltable,year,yes,zone,convert,";
    protected OscarJdbc2Connection connection;
    protected Encoding encoding;
    private static String databaseName = "OSCAR";
    private String databaseVersion;
    private static final String JDBC_NAME = "OSCAR JDBC DRIVER";
    private static final int JDBC_MAJOR_VERSION = 4;
    private static final int JDBC_MINOR_VERSION = 0;
    private static final String[] clientDes = new String[]{"The name of the application currently utilizing the connection.", "The name of the user currently utilizing the connection.", "The name of the Host currently utilizing the connection."};
    private Map<String, Integer> dbProps;
    private final int compatableDbms;
    private static final Hashtable<String, Map<String, String>> tableTypeClauses = new Hashtable();
    protected static String[] TYPE_NAME;
    protected static int[] DATA_TYPE;

    public OscarDatabaseMetaData(OscarJdbc2Connection conn) {
        this.connection = conn;
        this.encoding = conn.getEncoding();
        this.dbProps = new HashMap<String, Integer>();
        this.compatableDbms = Integer.parseInt(conn.getConnectionProperties().getProperty("COMPATABLE_DBMS", "0"));
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        boolean isReadOnly = this.connection.isReadOnly();
        return isReadOnly;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.getValue("nullsAreSortedLoworHigh") == 1;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.getValue("nullsAreSortedLoworHigh") == 0;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.getValue("nullsAreSortedAtStartorEnd") == 1;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.getValue("nullsAreSortedAtStartorEnd") == 2;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return databaseName;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (this.databaseVersion == null) {
            BaseResultSet resultSet = null;
            try {
                resultSet = this.connection.execSQL("select version();");
                if (resultSet.next()) {
                    this.databaseVersion = resultSet.getString(1);
                }
            }
            catch (SQLException e) {
                this.databaseVersion = "7.1";
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return this.databaseVersion;
    }

    @Override
    public String getDriverName() throws SQLException {
        return JDBC_NAME;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return Driver.getVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return this.connection.getDriver().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.connection.getDriver().getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.getValue("usesLocalFiles") != 0;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.getValue("usesLocalFilePerTable") != 0;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.getValue("storesUpperCaseIdentifiers") != 0;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.getValue("storesLowerCaseIdentifiers") != 0;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.getValue("storesMixedCaseIdentifiers") != 0;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.getValue("storesUpperCaseQuotedIdentifiers") != 0;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.getValue("storesLowerCaseQuotedIdentifiers") != 0;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getValue("storesMixedCaseQuotedIdentifiers") != 0;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return keywords;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CONCAT,DIFFERENCE,INSERT_TEXT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "DATABASE,IFNULL,USER";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case -1: 
            case 1: 
            case 12: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case -4: 
            case -3: 
            case -2: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case 2004: {
                switch (toType) {
                    case 2004: {
                        return true;
                    }
                }
                return false;
            }
            case 2005: {
                switch (toType) {
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 2003: {
                switch (toType) {
                    case 2003: {
                        return true;
                    }
                }
                return false;
            }
            case 2006: {
                switch (toType) {
                    case 2006: {
                        return true;
                    }
                }
                return false;
            }
            case 70: {
                switch (toType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 70: {
                        return true;
                    }
                }
                return false;
            }
            case 2002: {
                switch (toType) {
                    case 2002: {
                        return true;
                    }
                }
                return false;
            }
            case 1111: {
                switch (toType) {
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return true;
            }
            case 2000: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.getValue("isCatalogAtStart") != 0;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getValue("MaxBinaryLiteralLength");
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.getValue("MaxCharLiteralLength");
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getValue("MaxColumnNameLength");
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getValue("MaxColumnsInGroupBy");
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getValue("MaxColumnsInIndex");
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getValue("MaxColumnsInOrderBy");
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.getValue("MaxColumnsInSelect");
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.getValue("MaxColumnsInTable");
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getValue("MaxCursorNameLength");
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.getValue("MaxIndexLength");
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getValue("MaxSchemaNameLength");
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getValue("MaxProcedureNameLength");
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getValue("MaxCatalogNameLength");
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.getValue("MaxRowSize");
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.getValue("MaxStatementLength");
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.getValue("MaxStatements");
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getValue("MaxTableNameLength");
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.getValue("MaxTablesInSelect");
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getValue("MaxUserNameLength");
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 8 || level == 2;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.getValue("dataDefinitionCausesTransactionCommit") != 0;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.getValue("dataDefinitionIgnoredInTransactions") != 0;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedurePattern) throws SQLException {
        StringBuffer sql = new StringBuffer(50);
        sql.append("SELECT PROCEDURE_CAT,PROCEDURE_SCHEM,PROCEDURE_NAME,NUM_INPUT_PARAMS,NUM_OUTPUT_PARAMS,NUM_RESULT_SETS,REMARKS,PROCEDURE_TYPE FROM V_SYS_PROCEDURE");
        if (procedurePattern == null) {
            procedurePattern = "%";
        }
        sql.append(" WHERE PROCEDURE_NAME LIKE ").append(TableNameParser.orgStringToQueryString(procedurePattern));
        if (schemaPattern != null && schemaPattern.trim().length() > 0) {
            sql.append(" AND PROCEDURE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schemaPattern));
        }
        if (catalog != null && catalog.trim().length() > 0) {
            sql.append(" AND PROCEDURE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        sql.append(" ORDER BY PROCEDURE_SCHEM");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedurePattern, String columnPattern) throws SQLException {
        StringBuffer sql = new StringBuffer(150);
        sql.append("SELECT A.PROCEDURE_CAT,A.PROCEDURE_SCHEM,A.PROCEDURE_NAME,A.COLUMN_NAME,");
        sql.append("A.COLUMN_TYPE,A.DATA_TYPE,A.TYPE_NAME,");
        sql.append("A.COLUMN_SIZE AS \"PRECISION\",A.BUFFER_LENGTH AS LENGTH,");
        sql.append("A.DECIMAL_DIGITS AS SCALE,A.NUM_PREC_RADIX AS RADIX,A.NULLABLE,A.REMARKS");
        sql.append(" FROM V_SYS_PROCEDURE_PARAMS A");
        sql.append(" WHERE A.ORDINAL_POSITION >0 AND A.PROCEDURE_NAME LIKE ");
        sql.append(TableNameParser.orgStringToQueryString(procedurePattern));
        if (columnPattern != null && columnPattern.trim().length() > 0) {
            sql.append(" AND A.COLUMN_NAME LIKE ").append(TableNameParser.orgStringToQueryString(columnPattern));
        }
        if (schemaPattern != null && schemaPattern.trim().length() > 0) {
            sql.append(" AND A.PROCEDURE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schemaPattern));
        }
        if (catalog != null && catalog.trim().length() > 0) {
            sql.append(" AND A.PROCEDURE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        sql.append(" ORDER BY A.PROCEDURE_SCHEM,A.PROCEDURE_NAME,A.ORDINAL_POSITION");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuffer sql = new StringBuffer(50);
        sql.append("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, CASE WHEN (TABLE_TYPE='KSTORE') THEN 'TABLE' ELSE TABLE_TYPE END TABLE_TYPE, REMARKS, TYPE_CAT, NULL TYPE_SCHEM, TYPE_NAME, SELF_REFERENCING_COL_NAME, REF_GENERATION FROM V_SYS_TABLES");
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        sql.append(" WHERE TABLE_NAME LIKE ").append(TableNameParser.orgStringToQueryString(tableNamePattern));
        if (schemaPattern != null) {
            sql.append(" AND TABLE_SCHEM LIKE ");
            if (schemaPattern.trim().equals("")) {
                sql.append("NULL");
            } else {
                sql.append(TableNameParser.orgStringToQueryString(schemaPattern));
            }
        } else if (this.compatableDbms == 2) {
            sql.append(" AND TABLE_SCHEM = ").append(TableNameParser.orgStringToQueryString(this.getUserName()));
        }
        if (catalog != null && catalog.trim().length() != 0) {
            sql.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        if (types != null && types.length > 0) {
            int i;
            ProtocolVersion protocolVersion = this.connection.getProtocolVersion();
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.addAll(Arrays.asList(types));
            if ((protocolVersion.isKstore() || protocolVersion.isMpp5()) && typeList.contains("TABLE")) {
                typeList.add("KSTORE");
            }
            sql.append(" AND (");
            for (i = 0; i < typeList.size() - 1; ++i) {
                sql.append(" TABLE_TYPE LIKE ").append(TableNameParser.orgStringToQueryString((String)typeList.get(i))).append(" OR");
            }
            sql.append(" TABLE_TYPE LIKE ").append(TableNameParser.orgStringToQueryString((String)typeList.get(i))).append(")");
        }
        sql.append(" ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String sql = "SELECT * FROM V_SYS_SCHEMAS";
        return this.resetColumnName(this.connection.execSQL(sql));
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String sql = " SELECT (CURRENT_DATABASE())::character varying(64) AS TABLE_CAT;";
        return this.resetColumnName(this.connection.execSQL(sql));
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String sql = "SELECT * FROM V_SYS_TABLE_TYPES";
        return this.resetColumnName(this.connection.execSQL(sql));
    }

    @Override
    public ResultSet getColumns(String catalogPattern, String schemaPattern, String tablePattern, String columnPattern) throws SQLException {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT A.TABLE_CAT, A.TABLE_SCHEM, A.TABLE_NAME, A.COLUMN_NAME,");
        sql.append(" B.SQL_CONCISE_TYPE as DATA_TYPE, B.TYPE_NAME, A.COLUMN_SIZE, A.BUFFER_LENGTH,");
        sql.append(" A.DECIMAL_DIGITS, A.NUM_PREC_RADIX, A.NULLABLE, A.REMARKS, A.COLUMN_DEF,");
        sql.append(" B.SQL_DATA_TYPE, B.SQL_DATETIME_SUB, A.CHAR_OCTET_LENGTH,");
        sql.append(" A.ORDINAL_POSITION, A.IS_NULLABLE, A.SCOPE_CATALOG AS SCOPE_CATLOG, A.SCOPE_SHEMA SCOPE_SCHEMA, A.SCOPE_TABLE, A.SOURCE_DATA_TYPE,");
        String auto = "CASE WHEN (SELECT ATTISAUTO FROM V_SYS_ATTRIBUTE WHERE A.COLUMN_NAME = ATTNAME AND ATTRELID = sys_get_relid(A.TABLE_SCHEM, A.TABLE_NAME)) then 'YES' else 'NO' end IS_AUTOINCREMENT ";
        ProtocolVersion protocolVersion = this.connection.getProtocolVersion();
        if (!protocolVersion.isMpp5() && !protocolVersion.isKstore() && this.connection.isSupportAuto()) {
            sql.append(auto).append(" , ");
        } else {
            sql.append(" 'NO' IS_AUTOINCREMENT,");
        }
        String generated = "CASE WHEN (SELECT ATTGENERATED FROM V_SYS_ATTRIBUTE WHERE A.COLUMN_NAME = ATTNAME AND ATTRELID = sys_get_relid(A.TABLE_SCHEM, A.TABLE_NAME))  in ('v','s') then 'YES' else 'NO' end  IS_GENERATEDCOLUMN ";
        if (!protocolVersion.isMpp5() && !protocolVersion.isKstore() && this.connection.isSupportGenerated()) {
            sql.append(generated);
        } else {
            sql.append(" 'NO' IS_GENERATEDCOLUMN ");
        }
        sql.append(" FROM INFO_SCHEM.V_SYS_COLUMNS A ");
        sql.append(" LEFT JOIN INFO_SCHEM.V_SYS_TYPE_INFO B ON A.DATA_TYPE = B.DATA_TYPE");
        sql.append(" WHERE A.ORDINAL_POSITION > 0");
        if (tablePattern != null && tablePattern.trim().length() > 0) {
            sql.append(" AND A.TABLE_NAME LIKE ").append(TableNameParser.orgStringToQueryString(tablePattern));
        }
        if (columnPattern != null && columnPattern.trim().length() > 0) {
            sql.append(" AND A.COLUMN_NAME LIKE ").append(TableNameParser.orgStringToQueryString(columnPattern));
        }
        if (schemaPattern != null && schemaPattern.trim().length() > 0) {
            sql.append(" AND A.TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schemaPattern));
        } else if (this.compatableDbms == 2) {
            sql.append(" AND A.TABLE_SCHEM = ").append(TableNameParser.orgStringToQueryString(this.getUserName()));
        }
        if (catalogPattern != null && catalogPattern.trim().length() > 0) {
            sql.append(" AND A.TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalogPattern));
        }
        sql.append(" ORDER BY A.TABLE_SCHEM,A.TABLE_NAME,A.ORDINAL_POSITION");
        try {
            return this.resetColumnName(this.connection.execSQL(sql.toString()));
        }
        catch (SQLException e) {
            String tempSql = sql.toString();
            if (e.getMessage().contains("ATTISAUTO")) {
                this.connection.setSupportAuto(false);
                tempSql = tempSql.replace(auto, "'NO' IS_AUTOINCREMENT ");
                try {
                    return this.resetColumnName(this.connection.execSQL(tempSql));
                }
                catch (SQLException ex) {
                    e = ex;
                }
            }
            if (e.getMessage().contains("ATTGENERATED")) {
                this.connection.setSupportGenerated(false);
                tempSql = tempSql.replace(generated, "'NO' IS_GENERATEDCOLUMN ");
                return this.resetColumnName(this.connection.execSQL(tempSql));
            }
            throw e;
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalogPattern, String schemaPattern, String table, String columnNamePattern) throws SQLException {
        StringBuffer sql = new StringBuffer(50);
        sql.append("SELECT TABLE_CAT,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,GRANTOR,GRANTEE,PRIVILEGE,IS_GRANTABLE FROM V_SYS_COLUMN_PRIVILEGES");
        sql.append(" WHERE TABLE_NAME LIKE ");
        if (table == null || table.trim().length() == 0) {
            sql.append("'%'");
        } else {
            sql.append(TableNameParser.orgStringToQueryString(table));
        }
        sql.append(" AND COLUMN_NAME LIKE ");
        if (columnNamePattern == null || columnNamePattern.trim().length() == 0) {
            sql.append("'%'");
        } else {
            sql.append(TableNameParser.orgStringToQueryString(columnNamePattern));
        }
        if (schemaPattern != null && schemaPattern.trim().length() > 0) {
            sql.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schemaPattern));
        }
        if (catalogPattern != null && catalogPattern.trim().length() > 0) {
            sql.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalogPattern));
        }
        sql.append(" ORDER BY COLUMN_NAME,PRIVILEGE");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        StringBuffer sql = new StringBuffer(150);
        sql.append("SELECT TABLE_CAT,TABLE_SCHEM,TABLE_NAME,GRANTOR,GRANTEE,");
        sql.append("PRIVILEGE,IS_GRANTABLE FROM V_SYS_TABLE_PRIVILEGES");
        sql.append(" WHERE TABLE_NAME LIKE ");
        if (tableNamePattern == null) {
            sql.append("'%'");
        } else {
            sql.append(TableNameParser.orgStringToQueryString(tableNamePattern));
        }
        if (schemaPattern != null && schemaPattern.trim().length() > 0) {
            sql.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schemaPattern));
        }
        if (catalog != null && catalog.trim().length() > 0) {
            sql.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        sql.append(" ORDER BY TABLE_SCHEM,TABLE_NAME,PRIVILEGE");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        StringBuffer sql = new StringBuffer(50);
        sql.append("SELECT SCOPE, A.COLUMN_NAME, B.DATA_TYPE, B.TYPE_NAME, ");
        sql.append(" A.COLUMN_SIZE, A.BUFFER_LENGTH, A.DECIMAL_DIGITS, A.PSEUDO_COLUMN");
        sql.append(" FROM V_SYS_BESTROWIDENTIFIER A, V_SYS_TYPE_INFO B, V_SYS_TABLES C");
        sql.append(" WHERE A.DATA_TYPE = B.DATA_TYPE");
        sql.append(" AND TABLE_NAME LIKE ");
        if (table == null) {
            sql.append("'%'");
        } else {
            sql.append(TableNameParser.orgStringToQueryString(table));
        }
        sql.append(" AND SCOPE =").append(scope);
        sql.append(" AND TABLE_TYPE IN ('TABLE', 'SYSTEM TABLE')");
        if (schema != null && schema.trim().length() > 0) {
            sql.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schema));
        }
        if (catalog != null && catalog.trim().length() > 0) {
            sql.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        sql.append(" ORDER BY SCOPE");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        StringBuffer sql = new StringBuffer(50);
        sql.append("SELECT SCOPE, A.COLUMN_NAME, B.DATA_TYPE, B.TYPE_NAME, ");
        sql.append(" A.COLUMN_SIZE, A.BUFFER_LENGTH, A.DECIMAL_DIGITS, A.PSEUDO_COLUMN");
        sql.append(" FROM V_SYS_VERSIONCOLUMNS A, V_SYS_TYPE_INFO B, V_SYS_TABLES C");
        sql.append(" WHERE A.DATA_TYPE = B.DATA_TYPE");
        sql.append(" AND TABLE_NAME LIKE ").append(TableNameParser.orgStringToQueryString(table));
        sql.append(" AND TABLE_TYPE IN ('TABLE', 'SYSTEM TABLE')");
        if (schema != null && schema.trim().length() > 0) {
            sql.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schema));
        }
        if (catalog != null && catalog.trim().length() > 0) {
            sql.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer sql = new StringBuffer(50);
        sql.append("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, KEY_SEQ, PK_NAME FROM V_SYS_PRIMARY_KEYS");
        sql.append(" WHERE TABLE_NAME LIKE ");
        if (table == null || table.trim().length() == 0) {
            sql.append("'%'");
        } else {
            sql.append(TableNameParser.orgStringToQueryString(table));
        }
        if (schema != null && schema.trim().length() > 0) {
            sql.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schema));
        } else if (this.compatableDbms == 2) {
            sql.append(" AND TABLE_SCHEM = ").append(TableNameParser.orgStringToQueryString(this.getUserName()));
        }
        if (catalog != null && catalog.trim().length() > 0) {
            sql.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        sql.append(" ORDER BY KEY_SEQ");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer sql = new StringBuffer(50);
        sql.append("SELECT PKTABLE_CAT,PKTABLE_SCHEM,PKTABLE_NAME,PKCOLUMN_NAME,FKTABLE_CAT,FKTABLE_SCHEM,FKTABLE_NAME,FKCOLUMN_NAME,KEY_SEQ,UPDATE_RULE,DELETE_RULE,FK_NAME,PK_NAME,DEFERRABILITY");
        sql.append("  FROM V_SYS_FOREIGN_KEYS WHERE FKTABLE_NAME LIKE ");
        if (table == null) {
            sql.append("'%'");
        } else {
            sql.append(TableNameParser.orgStringToQueryString(table));
        }
        if (schema != null && schema.trim().length() > 0) {
            sql.append(" AND FKTABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schema));
        }
        if (catalog != null && catalog.trim().length() > 0) {
            sql.append(" AND FKTABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        sql.append(" ORDER BY KEY_SEQ");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer sql = new StringBuffer(50);
        sql.append("SELECT PKTABLE_CAT,PKTABLE_SCHEM,PKTABLE_NAME,PKCOLUMN_NAME,FKTABLE_CAT,FKTABLE_SCHEM,FKTABLE_NAME,FKCOLUMN_NAME,KEY_SEQ,UPDATE_RULE,DELETE_RULE,FK_NAME,PK_NAME,DEFERRABILITY ");
        sql.append(" FROM V_SYS_FOREIGN_KEYS WHERE PKTABLE_NAME LIKE ");
        if (table == null) {
            sql.append("'%'");
        } else {
            sql.append(TableNameParser.orgStringToQueryString(table));
        }
        if (schema != null && schema.trim().length() > 0) {
            sql.append(" AND PKTABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schema));
        }
        if (catalog != null && catalog.trim().length() > 0) {
            sql.append(" AND PKTABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        sql.append(" ORDER BY KEY_SEQ");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        StringBuffer sql = new StringBuffer(50);
        sql.append("SELECT PKTABLE_CAT,PKTABLE_SCHEM,PKTABLE_NAME,PKCOLUMN_NAME,FKTABLE_CAT,FKTABLE_SCHEM,FKTABLE_NAME,FKCOLUMN_NAME,KEY_SEQ,UPDATE_RULE,DELETE_RULE,FK_NAME,PK_NAME,DEFERRABILITY ");
        sql.append(" FROM V_SYS_FOREIGN_KEYS WHERE PKTABLE_NAME LIKE ");
        if (primaryTable == null) {
            sql.append("'%'");
        } else {
            sql.append(TableNameParser.orgStringToQueryString(primaryTable));
        }
        sql.append(" AND FKTABLE_NAME LIKE ");
        if (foreignTable == null) {
            sql.append("'%'");
        } else {
            sql.append(TableNameParser.orgStringToQueryString(foreignTable));
        }
        if (primarySchema != null && primarySchema.trim().length() > 0) {
            sql.append(" AND PKTABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(primarySchema));
        }
        if (primaryCatalog != null && primaryCatalog.trim().length() > 0) {
            sql.append(" AND PKTABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(primaryCatalog));
        }
        if (foreignSchema != null && foreignSchema.trim().length() > 0) {
            sql.append(" AND FKTABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(foreignSchema));
        }
        if (foreignCatalog != null && foreignCatalog.trim().length() > 0) {
            sql.append(" AND FKTABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(foreignCatalog));
        }
        sql.append(" ORDER BY KEY_SEQ");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        String sql = "SELECT TYPE_NAME,SQL_CONCISE_TYPE AS DATA_TYPE,\"PRECISION\",LITERAL_PREFIX,LITERAL_SUFFIX,CREATE_PARAMS,NULLABLE,CASE_SENSITIVE,SEARCHABLE,UNSIGNED_ATTRIBUTE,FIXED_PREC_SCALE,AUTO_INCREMENT,LOCAL_TYPE_NAME,MINIMUM_SCALE,MAXIMUM_SCALE,SQL_DATA_TYPE,SQL_DATETIME_SUB,NUM_PREC_RADIX FROM V_SYS_TYPE_INFO ORDER BY DATA_TYPE";
        return this.resetColumnName(this.connection.execSQL(sql));
    }

    @Override
    public ResultSet getIndexInfo(String catalogPattern, String schemaPattern, String table, boolean unique, boolean approximate) throws SQLException {
        if (table == null) {
            throw new OSQLException("OSCAR-00904", "88888", 904);
        }
        StringBuffer sql = new StringBuffer(50);
        sql.append("SELECT * FROM V_SYS_INDEX_STATISTICS");
        sql.append(" WHERE TABLE_NAME LIKE ").append(TableNameParser.orgStringToQueryString(table));
        if (unique) {
            sql.append(" AND (NON_UNIQUE = 0 OR NON_UNIQUE IS NULL)");
        }
        if (schemaPattern != null && schemaPattern.trim().length() > 0) {
            sql.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schemaPattern));
        } else if (this.compatableDbms == 2) {
            sql.append(" AND TABLE_SCHEM = ").append(TableNameParser.orgStringToQueryString(this.getUserName()));
        }
        if (catalogPattern != null && catalogPattern.trim().length() > 0) {
            sql.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalogPattern));
        }
        sql.append(" ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION");
        BaseResultSet rs = this.connection.execSQL(sql.toString());
        this.resetColumnName(rs);
        return (ResultSet)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler((OscarResultSet)rs));
    }

    protected BaseResultSet resetColumnName(BaseResultSet brs) {
        Field[] fields = brs.getFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].resetName();
        }
        return brs;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1005) {
            return false;
        }
        if (concurrency == 1008) {
            return true;
        }
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return type != 1003;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        if (type == 1003) {
            return Boolean.valueOf(this.connection.getConnectionProperties().getProperty("USESENSITIVECURSOR", "true"));
        }
        return type == 1005;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return type != 1003;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT NULL AS TYPE_CAT, NSPNAME AS TYPE_SCHEM, NAME AS TYPE_NAME, NULL AS CLASS_NAME, '2002' AS DATA_TYPE, '2002' AS BASE_TYPE\uff0c NULL AS REMARKS  ").append("FROM INFO_SCHEM.SYS_PL_OBJ T LEFT JOIN INFO_SCHEM.V_SYS_NAMESPACE N  ON N.OID = TYPNAMESPACE WHERE 1 = 1");
        String[] localObject = new String[1];
        String[] arrayOfString = new String[1];
        if (typeNamePattern != null && typeNamePattern.trim().length() != 0) {
            if (TableNameParser.parse(typeNamePattern, localObject, arrayOfString)) {
                sql.append(" AND NAME LIKE ").append(TableNameParser.orgStringToQueryString(arrayOfString[0]));
                sql.append(" AND N.NSPNAME LIKE ").append(TableNameParser.orgStringToQueryString(localObject[0]));
            } else {
                sql.append(" AND NAME LIKE ").append(TableNameParser.orgStringToQueryString(arrayOfString[0]));
            }
        }
        if (localObject[0] == null && schemaPattern != null && schemaPattern.trim().length() != 0) {
            sql.append(" AND N.NSPNAME LIKE ").append(TableNameParser.orgStringToQueryString(schemaPattern));
        }
        sql.append(" ORDER BY TYPE_SCHEM, TYPE_NAME");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean rowChangesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean rowChangesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.resetColumnName(this.connection.execSQL("select * from v_sys_super_types"));
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TABLE_CAT", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TABLE_SCHEM", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TABLE_NAME", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "SUPERTABLE_NAME", "", "", 0)};
        return this.connection.getDefaultStatement().createResultSet(fields, new ArrayList<byte[][]>(), null, 0L, 0L);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TYPE_CAT", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TYPE_SCHEM", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TYPE_NAME", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "ATTR_NAME", "", "", 0), new Field((BaseConnection)this.connection, "", 21, 32, 0, "DATA_TYPE", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "ATTR_TYPE_NAME", "", "", 0), new Field((BaseConnection)this.connection, "", 23, 32, 0, "ATTR_SIZE", "", "", 0), new Field((BaseConnection)this.connection, "", 23, 32, 0, "DECIMAL_DIGITS", "", "", 0), new Field((BaseConnection)this.connection, "", 23, 32, 0, "NUM_PREC_RADIX", "", "", 0), new Field((BaseConnection)this.connection, "", 23, 32, 0, "NULLABLE", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "REMARKS", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "ATTR_DEF", "", "", 0), new Field((BaseConnection)this.connection, "", 23, 32, 0, "SQL_DATA_TYPE", "", "", 0), new Field((BaseConnection)this.connection, "", 23, 32, 0, "SQL_DATETIME_SUB", "", "", 0), new Field((BaseConnection)this.connection, "", 23, 32, 0, "CHAR_OCTET_LENGTH", "", "", 0), new Field((BaseConnection)this.connection, "", 23, 32, 0, "ORDINAL_POSITION", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "IS_NULLABLE", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "SCOPE_CATALOG", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "SCOPE_SCHEMA", "", "", 0), new Field((BaseConnection)this.connection, "", 1042, 32, 0, "SCOPE_TABLE", "", "", 0), new Field((BaseConnection)this.connection, "", 21, 32, 0, "SOURCE_DATA_TYPE", "", "", 0)};
        return this.connection.getDefaultStatement().createResultSet(fields, new ArrayList<byte[][]>(), null, 0L, 0L);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return true;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getVersion().getDBMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getVersion().getDBMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 1;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getValue(String columnName) throws SQLException {
        if (this.dbProps.get(columnName) == null) {
            PreparedStatement psmt = null;
            ResultSet rs = null;
            try {
                psmt = this.connection.prepareStatement("select NAME, VALUE  from v_sys_limits");
                psmt.setFetchSize(0);
                rs = psmt.executeQuery();
                while (rs.next()) {
                    if (rs.getString(1).equalsIgnoreCase("MaxKstoreDPDataSize")) continue;
                    this.dbProps.put(rs.getString(1), rs.getInt(2));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (psmt != null) {
                    psmt.close();
                }
            }
        }
        return this.dbProps.get(columnName);
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        if (paramClass.isAssignableFrom(this.getClass())) {
            return paramClass.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + paramClass.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return paramClass.isAssignableFrom(this.getClass());
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TABLE_SCHEM, TABLE_CATALOG FROM V_SYS_SCHEMAS");
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        sql.append(" WHERE TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schemaPattern));
        if (catalog != null && !catalog.trim().isEmpty()) {
            sql.append(" AND TABLE_CATALOG LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        sql.append(" order by TABLE_CATALOG ,TABLE_SCHEM");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String[] clientPro;
        Field[] f = new Field[]{new Field(this.connection, "NAME", this.connection.getDBTypeOid("VARCHAR"), 127, "NAME"), new Field(this.connection, "MAX_LEN", this.connection.getDBTypeOid("INT4"), 4, "MAX_LEN"), new Field(this.connection, "DEFAULT_VALUE", this.connection.getDBTypeOid("VARCHAR"), 127, "DEFAULT_VALUE"), new Field(this.connection, "DESCRIPTION", this.connection.getDBTypeOid("VARCHAR"), 127, "DESCRIPTION")};
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        for (String name : clientPro = this.connection.getClientpro()) {
            byte[][] tuple = new byte[][]{this.connection.getEncoding().encode(name), this.connection.getEncoding().encode(Integer.toString(127)), this.connection.getEncoding().encode(""), this.connection.getEncoding().encode(clientDes[v.size()])};
            v.add(tuple);
        }
        return this.connection.getDefaultStatement().createResultSet(f, v, "OK", 3L, 0L);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from (SELECT (CURRENT_DATABASE())::character varying(128) AS FUNCTION_CAT, N.NSPNAME AS FUNCTION_SCHEM, P.PRONAME AS FUNCTION_NAME, D.\"DESCRIPTION\" AS REMARKS,").append("CASE WHEN (P.PRORETTYPE = (2278)::OID) THEN 1 ELSE 2 END AS FUNCTION_TYPE, NULL as SPECIFIC_NAME   FROM ((INFO_SCHEM.V_SYS_PROC P ").append("LEFT JOIN INFO_SCHEM.V_SYS_DESCRIPTION D ON ((P.OID = D.OBJOID))) JOIN INFO_SCHEM.V_SYS_LANGUAGE L ON ((L.OID = P.PROLANG))), ").append("INFO_SCHEM.V_SYS_NAMESPACE N WHERE (((L.LANNAME = 'ploscar'::\"NAME\") AND (N.OID = P.PRONAMESPACE)) AND (P.PROISFUNC = 1)))");
        if (functionNamePattern == null) {
            functionNamePattern = "%";
        }
        sql.append(" WHERE FUNCTION_NAME  LIKE ").append(TableNameParser.orgStringToQueryString(functionNamePattern));
        if (schemaPattern != null && schemaPattern.trim().length() > 0) {
            sql.append(" AND FUNCTION_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schemaPattern));
        }
        if (catalog != null && catalog.trim().length() > 0) {
            sql.append(" AND FUNCTION_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        sql.append(" order by FUNCTION_CAT, FUNCTION_SCHEM ,FUNCTION_NAME");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from (SELECT (CURRENT_DATABASE())::character varying(128) AS FUNCTION_CAT, N.NSPNAME AS FUNCTION_SCHEM, PROC.PRONAME AS FUNCTION_NAME, ").append("IFNULL(PARAMS.PARAMNAME, ' '::\"NAME\") AS COLUMN_NAME, ").append("CASE WHEN (PARAMS.PARAMINOUT = 0) THEN 0 WHEN (PARAMS.PARAMINOUT = 1) THEN 1 WHEN (PARAMS.PARAMINOUT = 2) THEN 4 WHEN (PARAMS.PARAMINOUT = 3) THEN 2 ELSE NULL END AS COLUMN_TYPE, ").append("PARAMS.PARAMTYP AS DATA_TYPE, T.TYPNAME AS TYPE_NAME,").append("CASE WHEN (PARAMS.PARAMTYP = (16)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (17)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (18)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (19)::OID) THEN 128 WHEN (PARAMS.PARAMTYP = (20)::OID) THEN 19 WHEN (PARAMS.PARAMTYP = (21)::OID) THEN 5 WHEN (PARAMS.PARAMTYP = (23)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (25)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (26)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (700)::OID) THEN 24 WHEN (PARAMS.PARAMTYP = (701)::OID) THEN 53 WHEN (PARAMS.PARAMTYP = (702)::OID) THEN 22 WHEN (PARAMS.PARAMTYP = (972)::OID) THEN 3 WHEN (PARAMS.PARAMTYP = (1042)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1043)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1082)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (1083)::OID) THEN 8 WHEN (PARAMS.PARAMTYP = (1114)::OID) THEN 19 WHEN (PARAMS.PARAMTYP = (1184)::OID) THEN 22 WHEN (PARAMS.PARAMTYP = (1186)::OID) THEN 33 WHEN (PARAMS.PARAMTYP = (1365)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1700)::OID) THEN (PARAMS.TYPMOD >> 16) WHEN (PARAMS.PARAMTYP = (2174)::OID) THEN 24 WHEN (PARAMS.PARAMTYP = (2175)::OID) THEN 53 WHEN (PARAMS.PARAMTYP = (2315)::OID) THEN (PARAMS.TYPMOD >> 16) WHEN (PARAMS.PARAMTYP = (3100)::OID) THEN (PARAMS.TYPMOD - 4) ELSE NULL END AS PRECISION, ").append("CASE WHEN (PARAMS.PARAMTYP = (16)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (17)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (18)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (19)::OID) THEN 128 WHEN (PARAMS.PARAMTYP = (20)::OID) THEN 8 WHEN (PARAMS.PARAMTYP = (21)::OID) THEN 2 WHEN (PARAMS.PARAMTYP = (23)::OID) THEN 4 WHEN (PARAMS.PARAMTYP = (25)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (26)::OID) THEN 4 WHEN (PARAMS.PARAMTYP = (700)::OID) THEN 4 WHEN (PARAMS.PARAMTYP = (701)::OID) THEN 8 WHEN (PARAMS.PARAMTYP = (702)::OID) THEN 22 WHEN (PARAMS.PARAMTYP = (972)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (1042)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1043)::OID) THEN (PARAMS.TYPMOD - 4) WHEN").append("(PARAMS.PARAMTYP = (1082)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (1083)::OID) THEN 8 WHEN (PARAMS.PARAMTYP = (1114)::OID) THEN 19 WHEN (PARAMS.PARAMTYP = (1184)::OID) THEN 22 WHEN (PARAMS.PARAMTYP = (1186)::OID) THEN 33 WHEN (PARAMS.PARAMTYP = (1365)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1700)::OID) THEN (PARAMS.TYPMOD >> 16) WHEN (PARAMS.PARAMTYP = (2174)::OID) THEN 4 WHEN (PARAMS.PARAMTYP = (2175)::OID) THEN 8 WHEN (PARAMS.PARAMTYP = (2315)::OID) THEN (PARAMS.TYPMOD >> 16) WHEN (PARAMS.PARAMTYP = (3100)::OID) THEN (PARAMS.TYPMOD - 4) ELSE NULL END AS LENGTH, ").append("CASE WHEN (PARAMS.PARAMTYP = (1700)::OID) THEN ((PARAMS.TYPMOD & 65535) - 4) WHEN (PARAMS.PARAMTYP = (2315)::OID) THEN ((PARAMS.TYPMOD & 65535) - 4) ELSE NULL END AS SCALE,").append("CASE WHEN (PARAMS.PARAMTYP = (20)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (21)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (23)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (26)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (700)::OID) THEN 2 WHEN (PARAMS.PARAMTYP = (701)::OID) THEN 2 WHEN (PARAMS.PARAMTYP = (972)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (1700)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (2174)::OID) THEN 2 WHEN (PARAMS.PARAMTYP = (2175)::OID) THEN 2 WHEN (PARAMS.PARAMTYP = (2315)::OID) THEN 10 ELSE NULL END AS RADIX, ").append("CASE WHEN (PARAMS.NULLABLE = TRUE) THEN 1::smallint WHEN (PARAMS.NULLABLE = FALSE) THEN 0::smallint ELSE 2::smallint END AS NULLABLE, ").append("D.\"DESCRIPTION\" AS REMARKS, CASE WHEN (PARAMS.PARAMTYP = (17)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (18)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (25)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (1042)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1043)::OID) THEN (PARAMS.TYPMOD - 4) ELSE NULL END AS CHAR_OCTET_LENGTH, ").append("PARAMS.\"SEQUENCE\" AS ORDINAL_POSITION, (CASE WHEN (PARAMS.NULLABLE = TRUE) THEN 'YES' WHEN (PARAMS.NULLABLE = FALSE) THEN 'NO' ELSE '' END)::character varying(3) AS IS_NULLABLE, NULL AS SPECIFIC_NAME").append(" FROM ((INFO_SCHEM.V_SYS_PROC PROC JOIN INFO_SCHEM.V_SYS_PROC_PARAMS PARAMS ON ((PROC.OID = PARAMS.PROCOID))) LEFT JOIN INFO_SCHEM.V_SYS_DESCRIPTION D ON (((PARAMS.PROCOID = D.OBJOID) AND (PARAMS.\"SEQUENCE\" = D.OBJSUBID)))), ").append("INFO_SCHEM.V_SYS_NAMESPACE N, INFO_SCHEM.V_SYS_TYPE T WHERE ((PROC.PRONAMESPACE = N.OID) AND (T.OID = PARAMS.PARAMTYP) AND (PROC.PROISFUNC = 1)))");
        if (functionNamePattern == null) {
            functionNamePattern = "%";
        }
        sql.append(" WHERE FUNCTION_NAME  LIKE ").append(TableNameParser.orgStringToQueryString(functionNamePattern));
        if (schemaPattern != null && schemaPattern.trim().length() > 0) {
            sql.append(" AND FUNCTION_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(schemaPattern));
        }
        if (catalog != null && catalog.trim().length() > 0) {
            sql.append(" AND FUNCTION_CAT LIKE ").append(TableNameParser.orgStringToQueryString(catalog));
        }
        if (columnNamePattern != null && columnNamePattern.trim().length() > 0) {
            sql.append(" AND COLUMN_NAME LIKE ").append(TableNameParser.orgStringToQueryString(columnNamePattern));
        }
        sql.append(" order by FUNCTION_CAT, FUNCTION_SCHEM ,FUNCTION_NAME,ORDINAL_POSITION");
        return this.resetColumnName(this.connection.execSQL(sql.toString()));
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    static {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        tableTypeClauses.put("TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname NOT LIKE 'pg\\\\_%'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname NOT LIKE 'pg\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'INFO_SCHEM'");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname NOT LIKE 'pg\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname NOT LIKE 'pg\\\\_%'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname NOT LIKE 'pg\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("SEQUENCE", ht);
        ht.put("SCHEMAS", "c.relkind = 'S'");
        ht.put("NOSCHEMAS", "c.relkind = 'S'");
        ht = new Hashtable();
        tableTypeClauses.put("SYSTEM TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'INFO_SCHEM'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_%' AND c.relname NOT LIKE 'pg\\\\_toast\\\\_%' AND c.relname NOT LIKE 'pg\\\\_temp\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("SYSTEM TOAST TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'sys_toast'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_toast\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("SYSTEM TOAST INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'sys_toast'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'pg\\\\_toast\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("SYSTEM VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname = 'INFO_SCHEM' ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'pg\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("SYSTEM INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'INFO_SCHEM'");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'pg\\\\_%' AND c.relname NOT LIKE 'pg\\\\_toast\\\\_%' AND c.relname NOT LIKE 'pg\\\\_temp\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("TEMPORARY TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname LIKE 'pg\\\\_temp\\\\_%' ");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_temp\\\\_%' ");
        ht = new Hashtable();
        tableTypeClauses.put("TEMPORARY INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname LIKE 'pg\\\\_temp\\\\_%' ");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'pg\\\\_temp\\\\_%' ");
        TYPE_NAME = new String[]{"ARRAY", "BIGINT", "BINARY", "BIT", "BLOB", "BOOLEAN", "CHAR", "CLOB", "DATALINK", "DATE", "DECIMAL", "DISTINCT", "DOUBLE", "FLOAT", "INTEGER", "JAVA_OBJECT", "LONBINARY", "LONGVARCHAR", "NULL", "NUMERIC", "OTHER", "REAL", "REF", "SMALLINT", "STRUCT", "TIME", "TIMESTAMP", "TINYINT", "VARBINARY", "VARCHAR"};
        DATA_TYPE = new int[]{2003, -5, -2, -7, 2004, 16, 1, 2005, 70, 91, 3, 2001, 8, 6, 4, 2000, -4, -1, 0, 2, 1111, 7, 2006, 5, 2002, 92, 93, -6, -3, 12};
    }

    private class ResultSetInvocationHandler
    implements InvocationHandler {
        private static final int indexNonunique = 3;
        private final OscarResultSet resultSet;

        ResultSetInvocationHandler(OscarResultSet resultSet) {
            this.resultSet = resultSet;
            try {
                this.convertValue(this.resultSet);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args != null && args.length == 1 && ("NON_UNIQUE".equalsIgnoreCase(args[0].toString()) || String.valueOf(3).equals(args[0].toString())) && "getBoolean".equals(method.getName()) && this.resultSet.this_row[3] == null) {
                return true;
            }
            Object res = method.invoke((Object)this.resultSet, args);
            return res;
        }

        private void convertValue(BaseResultSet rs) throws NumberFormatException, SQLException {
            List<byte[][]> tuples = rs.getTuples();
            for (byte[][] tup : tuples) {
                if (tup[3] == null) continue;
                int nonunique = -1;
                nonunique = OscarDatabaseMetaData.this.connection.compatibleOldProtocol || OscarDatabaseMetaData.this.connection.netDataByStr ? Integer.parseInt(OscarDatabaseMetaData.this.encoding.decode(tup[3])) : NumberConverter.convertBytesToInt(tup[3]);
                if (nonunique < 0) continue;
                tup[3] = OscarDatabaseMetaData.this.encoding.encode(String.valueOf(nonunique == 1));
            }
            rs.getFields()[3].setOID(16);
        }
    }
}

