/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.cluster;

import com.oscar.cluster.Node;
import com.oscar.cluster.core.DataImportStream;
import com.oscar.cluster.core.ImportStrategy;
import java.sql.SQLException;
import java.util.List;

public class RobinImportStrategy
implements ImportStrategy {
    private Node[] importNodes;
    private int currentImportIndex = 0;
    private Node currentNode;

    @Override
    public DataImportStream nextStream() throws SQLException {
        if (this.importNodes == null || this.importNodes.length == 0) {
            throw new SQLException("import node is null");
        }
        Node node = this.importNodes[this.currentImportIndex % this.importNodes.length];
        ++this.currentImportIndex;
        this.currentNode = node;
        return node;
    }

    @Override
    public DataImportStream currentStream() throws SQLException {
        if (this.currentNode == null) {
            this.nextStream();
        }
        return this.currentNode;
    }

    @Override
    public void setImportNodes(List<Node> nodes) throws SQLException {
        if (nodes == null || nodes.size() <= 0) {
            throw new SQLException("import node is null");
        }
        this.importNodes = new Node[nodes.size()];
        nodes.toArray(this.importNodes);
        this.currentNode = null;
    }
}

