/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.rac.executor;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.Field;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.jdbc.OscarCallableStatementV2;
import com.oscar.jdbc.OscarJdbc2RacConnection;
import com.oscar.jdbc.OscarResultSetV2;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.List;

public class RacCallableStatementV2
extends OscarCallableStatementV2
implements CallableStatement {
    private boolean hasConnect = false;

    public RacCallableStatementV2(BaseConnection connection, String sql) throws SQLException {
        super(connection, sql);
    }

    public BaseResultSet createResultSet(Field[] fields, List tuples, String status, int updateCount, long insertOID) throws SQLException {
        return new OscarResultSetV2((BaseStatement)this, fields, (List<byte[][]>)tuples, status, (long)updateCount, insertOID, this.fetchSize, this.maxrows);
    }

    @Override
    protected boolean executeStatement() throws SQLException {
        try {
            return super.executeStatement();
        }
        catch (SQLException e) {
            if (this.connection.getAutoCommit() && this.hasConnect) {
                return this.executeStatement();
            }
            throw e;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            long[] resultSize = super.executeLargeBatch();
            super.handleBatch();
            return resultSize;
        }
        catch (SQLException e) {
            if (this.connection.getAutoCommit() && this.hasConnect) {
                return this.executeLargeBatch();
            }
            throw e;
        }
    }

    @Override
    public void executeBatchAsyn(List asynBatch) throws SQLException {
        try {
            super.executeBatchAsyn(asynBatch);
        }
        catch (SQLException e) {
            if (this.connection.getAutoCommit() && this.hasConnect) {
                this.executeBatchAsyn(asynBatch);
            }
            throw e;
        }
    }

    @Override
    protected void checkConnectionClosed(Exception e) {
        switch (ExceptionUtil.isConnectionClosed(e)) {
            case 1: 
            case 2: {
                try {
                    this.hasConnect = false;
                    this.reConnect();
                    this.hasConnect = true;
                }
                catch (Exception ex) {
                    Driver.writeLog("rac change connection fail:" + ex.getMessage());
                }
                break;
            }
            default: {
                this.hasConnect = false;
            }
        }
    }

    @Override
    public void handleBatch() {
        if (!this.hasConnect) {
            super.handleBatch();
        }
    }

    private void reConnect() throws SQLException {
        ((OscarJdbc2RacConnection)this.connection).reConnect(this.connection.getConnectionProperties());
        this.initParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initParams() {
        this.batchPacketV2 = null;
        if (this.m_prepareSqlStatement == null) {
            if (this.m_statementName == null) {
                this.m_statementName = "J" + this.getNextPreparedCount();
            }
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.append("PREPARE ");
                this.sbuf.append(this.m_statementName);
                this.sbuf.append(" AS ");
                this.sbuf.append(this.m_origSqlFragments[0]);
                this.m_prepareSqlStatement = this.sbuf.toString();
            }
        }
    }
}

