/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class OscarSQLXML
implements SQLXML {
    private DOMResult domResult;
    private StringWriter stringWriter;
    private boolean freed;
    private boolean initialized;
    private boolean active;
    private ByteArrayOutputStream byteArrayOutputStream;
    private String data;
    private BaseConnection conn;

    public OscarSQLXML(BaseConnection conn) {
        this(conn, null, false);
    }

    public OscarSQLXML(BaseConnection conn, String data) {
        this(conn, data, true);
    }

    private OscarSQLXML(BaseConnection conn, String data, boolean initialized) {
        this.conn = conn;
        this.data = data;
        this.initialized = initialized;
        this.active = false;
        this.freed = false;
    }

    @Override
    public void free() throws SQLException {
        this.freed = true;
        this.data = null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        if (this.data == null) {
            return null;
        }
        return new ByteArrayInputStream(this.conn.getEncoding().encode(this.data));
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        this.checkFreed();
        this.initialize();
        this.active = true;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        return this.byteArrayOutputStream;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        if (this.data == null) {
            return null;
        }
        return new StringReader(this.data);
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        this.checkFreed();
        this.initialize();
        this.active = true;
        this.stringWriter = new StringWriter();
        return this.stringWriter;
    }

    @Override
    public String getString() throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        return this.data;
    }

    @Override
    public void setString(String paramString) throws SQLException {
        this.checkFreed();
        this.initialize();
        this.data = paramString;
    }

    public Source getSource(Class sourceClass) throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        if (this.data == null) {
            return null;
        }
        try {
            if (sourceClass == null || DOMSource.class.equals((Object)sourceClass)) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(new NonPrintingErrorHandler());
                InputSource input = new InputSource(new StringReader(this.data));
                return new DOMSource(builder.parse(input));
            }
            if (SAXSource.class.equals((Object)sourceClass)) {
                InputSource is = new InputSource(new StringReader(this.data));
                return new SAXSource(is);
            }
            if (StreamSource.class.equals((Object)sourceClass)) {
                return new StreamSource(new StringReader(this.data));
            }
            if (StAXSource.class.equals((Object)sourceClass)) {
                XMLInputFactory xif = XMLInputFactory.newInstance();
                XMLStreamReader xsr = xif.createXMLStreamReader(new StringReader(this.data));
                return new StAXSource(xsr);
            }
        }
        catch (Exception e) {
            throw new SQLException("Unable to decode xml data.");
        }
        throw new SQLException("Unknown XML Source class: {0}");
    }

    public synchronized Result setResult(Class paramClass) throws SQLException {
        this.checkFreed();
        this.initialize();
        if (paramClass == null || DOMResult.class.equals((Object)paramClass)) {
            this.domResult = new DOMResult();
            this.active = true;
            return this.domResult;
        }
        if (SAXResult.class.equals((Object)paramClass)) {
            try {
                SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                TransformerHandler transformerHandler = transformerFactory.newTransformerHandler();
                this.stringWriter = new StringWriter();
                transformerHandler.setResult(new StreamResult(this.stringWriter));
                this.active = true;
                return new SAXResult(transformerHandler);
            }
            catch (TransformerException te) {
                throw new SQLException("Unable to create SAXResult for SQLXML.");
            }
        }
        if (StreamResult.class.equals((Object)paramClass)) {
            this.stringWriter = new StringWriter();
            this.active = true;
            return new StreamResult(this.stringWriter);
        }
        if (StAXResult.class.equals((Object)paramClass)) {
            this.stringWriter = new StringWriter();
            try {
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                XMLStreamWriter xsw = xof.createXMLStreamWriter(this.stringWriter);
                this.active = true;
                return new StAXResult(xsw);
            }
            catch (XMLStreamException xse) {
                throw new SQLException("Unable to create StAXResult for SQLXML");
            }
        }
        throw new SQLException("Unknown XML Result class: {0}");
    }

    private void checkFreed() throws SQLException {
        if (this.freed) {
            throw new SQLException("This SQLXML object has already been freed.");
        }
    }

    private void initialize() throws SQLException {
        if (this.initialized) {
            throw new SQLException("This SQLXML object has already been initialized, so you cannot manipulate it further.");
        }
        this.initialized = true;
    }

    private void ensureInitialized() throws SQLException {
        if (!this.initialized) {
            throw new SQLException("This SQLXML object has not been initialized, so you cannot retrieve data from it.");
        }
        if (!this.active) {
            return;
        }
        if (this.byteArrayOutputStream != null) {
            try {
                this.data = this.conn.getEncoding().decode(this.byteArrayOutputStream.toByteArray());
            }
            finally {
                this.byteArrayOutputStream = null;
                this.active = false;
            }
        }
        if (this.stringWriter != null) {
            this.data = this.stringWriter.toString();
            this.stringWriter = null;
            this.active = false;
        } else if (this.domResult != null) {
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                DOMSource domSource = new DOMSource(this.domResult.getNode());
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                transformer.transform(domSource, streamResult);
                this.data = stringWriter.toString();
            }
            catch (TransformerException te) {
                throw new SQLException("Unable to convert DOMResult SQLXML data to a string.");
            }
            finally {
                this.domResult = null;
                this.active = false;
            }
        }
    }

    static class NonPrintingErrorHandler
    implements ErrorHandler {
        NonPrintingErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) {
        }

        @Override
        public void fatalError(SAXParseException e) {
        }

        @Override
        public void warning(SAXParseException e) {
        }
    }
}

