/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import com.oscar.core.BaseStatement;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarSQLXML;
import com.oscar.r2dbc.R2dbcNextPredicate;
import com.oscar.util.OSQLException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class OscarCursorResultSet
implements ResultSet,
R2dbcNextPredicate {
    private String cursorName = null;
    private int fetchSize = 1000;
    private ResultSet resultset = null;
    private BaseConnection conn;
    private Statement stmt = null;
    private String fetchSql = null;
    private int current_row = 0;

    public OscarCursorResultSet(String cursorName, int fetchSize, BaseConnection conn) throws SQLException {
        this.cursorName = this.formatCursor(cursorName);
        this.conn = conn;
        this.fetchSize = fetchSize == 0 ? 1 : fetchSize;
        this.fetchSql = "fetch forward " + fetchSize + " in " + this.cursorName;
        this.stmt = conn.createStatement();
        this.fetchNextResultSet();
        conn.addCursor(this.cursorName);
    }

    public String formatCursor(String cursorName) {
        if (!cursorName.startsWith("\"") || !cursorName.endsWith("\"")) {
            cursorName = "\"" + cursorName + "\"";
        }
        return cursorName;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void afterLast() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.resultset.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.resultset.close();
        this.conn.closeCursor(this.cursorName, (BaseStatement)((Object)this.stmt));
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.resultset.findColumn(columnName);
    }

    @Override
    public boolean first() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkResultSet();
        return this.resultset.getArray(i);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getArray(colName);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getAsciiStream(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBigDecimal(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBigDecimal(columnIndex, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBigDecimal(columnName, scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBinaryStream(columnName);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBlob(i);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBlob(colName);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBoolean(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBoolean(columnName);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getByte(columnIndex);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getByte(columnName);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBytes(columnIndex);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBytes(columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getCharacterStream(columnName);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkResultSet();
        return this.resultset.getClob(i);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getClob(colName);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDate(columnName);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDate(columnName, cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDouble(columnIndex);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDouble(columnName);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getFloat(columnIndex);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getFloat(columnName);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getInt(columnIndex);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getInt(columnName);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getLong(columnIndex);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getLong(columnName);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkResultSet();
        return this.resultset.getMetaData();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getObject(columnName);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.checkResultSet();
        return this.resultset.getRef(i);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getRef(colName);
    }

    @Override
    public int getRow() throws SQLException {
        return this.current_row;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getShort(columnIndex);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getShort(columnName);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getString(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getString(columnName);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTime(columnName);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTime(columnName, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTimestamp(columnName);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTimestamp(columnName, cal);
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getURL(columnName);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkResultSet();
        return this.resultset.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        this.checkResultSet();
        return this.resultset.getUnicodeStream(columnName);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.current_row == -1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.current_row == 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.current_row == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean last() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.resultset.next()) {
            ++this.current_row;
            return true;
        }
        this.fetchNextResultSet();
        if (this.resultset.next()) {
            ++this.current_row;
            return true;
        }
        this.current_row = -1;
        return false;
    }

    private void fetchNextResultSet() throws SQLException {
        if (this.resultset != null) {
            this.resultset.close();
        }
        this.stmt.execute(this.fetchSql);
        this.resultset = this.stmt.getResultSet();
    }

    @Override
    public boolean previous() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new OSQLException("OSCAR-00426", "88888", 426);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new OSQLException("OSCAR-00307", "88888", 307);
        }
        if (rows > 0) {
            this.fetchSize = rows;
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.resultset.wasNull();
    }

    public void checkResultSet() throws SQLException {
        if (this.resultset == null) {
            throw new OSQLException("OSCAR-00427", "88888", 427);
        }
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        if (paramClass.isAssignableFrom(this.getClass())) {
            return paramClass.cast(this);
        }
        throw new SQLException();
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return paramClass.isAssignableFrom(this.getClass());
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        this.checkResultSet();
        return this.resultset.getObject(i, map);
    }

    @Override
    public Object getObject(String i, Map<String, Class<?>> map) throws SQLException {
        this.checkResultSet();
        return this.resultset.getObject(i, map);
    }

    @Override
    public RowId getRowId(int paramInt) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public RowId getRowId(String paramString) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateRowId(int paramInt, RowId paramRowId) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateRowId(String paramString, RowId paramRowId) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkResultSet();
        return this.resultset.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.checkResultSet();
        return this.resultset.isClosed();
    }

    @Override
    public void updateNString(int paramInt, String paramString) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNString(String paramString1, String paramString2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(int paramInt, NClob paramNClob) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(String paramString, NClob paramNClob) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public NClob getNClob(int paramInt) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public NClob getNClob(String paramString) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public SQLXML getSQLXML(int paramInt) throws SQLException {
        String data = this.getString(paramInt);
        if (data == null) {
            return null;
        }
        return new OscarSQLXML(this.conn, data);
    }

    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        return this.getSQLXML(this.findColumn(columnName));
    }

    @Override
    public void updateSQLXML(int paramInt, SQLXML paramSQLXML) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateSQLXML(String paramString, SQLXML paramSQLXML) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public String getNString(int paramInt) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public String getNString(String paramString) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public Reader getNCharacterStream(int paramInt) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public Reader getNCharacterStream(String paramString) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNCharacterStream(int paramInt, Reader paramReader, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNCharacterStream(String paramString, Reader paramReader, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(int paramInt, InputStream paramInputStream, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(int paramInt, InputStream paramInputStream, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(int paramInt, Reader paramReader, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(String paramString, InputStream paramInputStream, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(String paramString, InputStream paramInputStream, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(String paramString, Reader paramReader, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(int paramInt, InputStream paramInputStream, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(String paramString, InputStream paramInputStream, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(int paramInt, Reader paramReader, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(String paramString, Reader paramReader, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(int paramInt, Reader paramReader, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(String paramString, Reader paramReader, long paramLong) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNCharacterStream(int paramInt, Reader paramReader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNCharacterStream(String paramString, Reader paramReader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(int paramInt, InputStream paramInputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(int paramInt, InputStream paramInputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(int paramInt, Reader paramReader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(String paramString, InputStream paramInputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(String paramString, InputStream paramInputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(String paramString, Reader paramReader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(int paramInt, InputStream paramInputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(String paramString, InputStream paramInputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(int paramInt, Reader paramReader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(String paramString, Reader paramReader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(int paramInt, Reader paramReader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(String paramString, Reader paramReader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkResultSet();
        return ((OscarResultSet)this.resultset).getObject(columnIndex, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.checkResultSet();
        return ((OscarResultSet)this.resultset).getObject(columnLabel, type);
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (((R2dbcNextPredicate)((Object)this.resultset)).hasNext()) {
            return true;
        }
        if (((OscarResultSet)this.resultset).getTupleCount() == 0) {
            return false;
        }
        this.fetchNextResultSet();
        return this.hasNext();
    }
}

