/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.binary;

import com.oscar.gis.binary.ByteGetter;
import com.oscar.gis.binary.ValueGetter;
import com.oscar.gis.util.Geometry;
import com.oscar.gis.util.GeometryCollection;
import com.oscar.gis.util.LineString;
import com.oscar.gis.util.LinearRing;
import com.oscar.gis.util.MultiLineString;
import com.oscar.gis.util.MultiPoint;
import com.oscar.gis.util.MultiPolygon;
import com.oscar.gis.util.Point;
import com.oscar.gis.util.Polygon;

public class BinaryParser {
    public static ValueGetter valueGetterForEndian(ByteGetter bytes) {
        if (bytes.get(0) == 0) {
            return new ValueGetter.XDR(bytes);
        }
        if (bytes.get(0) == 1) {
            return new ValueGetter.NDR(bytes);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + bytes.get(0));
    }

    public synchronized Geometry parse(String value) {
        ByteGetter.StringByteGetter bytes = new ByteGetter.StringByteGetter(value);
        return this.parseGeometry(BinaryParser.valueGetterForEndian(bytes));
    }

    public synchronized Geometry parse(byte[] value) {
        ByteGetter.BinaryByteGetter bytes = new ByteGetter.BinaryByteGetter(value);
        return this.parseGeometry(BinaryParser.valueGetterForEndian(bytes));
    }

    protected Geometry parseGeometry(ValueGetter data) {
        Geometry result1;
        byte endian = data.getByte();
        if (endian != data.endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        int typeword = data.getInt();
        int realtype = typeword & 0x1FFFFFFF;
        boolean haveZ = (typeword & Integer.MIN_VALUE) != 0;
        boolean haveM = (typeword & 0x40000000) != 0;
        boolean haveS = (typeword & 0x20000000) != 0;
        int srid = 0;
        if (haveS) {
            srid = Geometry.parseSRID(data.getInt());
        }
        switch (realtype) {
            case 1: {
                result1 = this.parsePoint(data, haveZ, haveM);
                break;
            }
            case 2: {
                result1 = this.parseLineString(data, haveZ, haveM);
                break;
            }
            case 3: {
                result1 = this.parsePolygon(data, haveZ, haveM);
                break;
            }
            case 4: {
                result1 = this.parseMultiPoint(data);
                break;
            }
            case 5: {
                result1 = this.parseMultiLineString(data);
                break;
            }
            case 6: {
                result1 = this.parseMultiPolygon(data);
                break;
            }
            case 7: {
                result1 = this.parseCollection(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + realtype);
            }
        }
        Geometry result = result1;
        if (srid != 0) {
            result.setSrid(srid);
        }
        return result;
    }

    private Point parsePoint(ValueGetter data, boolean haveZ, boolean haveM) {
        Point result;
        double X = data.getDouble();
        double Y = data.getDouble();
        if (haveZ) {
            double Z = data.getDouble();
            result = new Point(X, Y, Z);
        } else {
            result = new Point(X, Y);
        }
        if (haveM) {
            result.setM(data.getDouble());
        }
        return result;
    }

    private void parseGeometryArray(ValueGetter data, Geometry[] container) {
        for (int i = 0; i < container.length; ++i) {
            container[i] = this.parseGeometry(data);
        }
    }

    private Point[] parsePointArray(ValueGetter data, boolean haveZ, boolean haveM) {
        int count = data.getInt();
        Point[] result = new Point[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.parsePoint(data, haveZ, haveM);
        }
        return result;
    }

    private MultiPoint parseMultiPoint(ValueGetter data) {
        Geometry[] points = new Point[data.getInt()];
        this.parseGeometryArray(data, points);
        return new MultiPoint((Point[])points);
    }

    private LineString parseLineString(ValueGetter data, boolean haveZ, boolean haveM) {
        Point[] points = this.parsePointArray(data, haveZ, haveM);
        return new LineString(points);
    }

    private LinearRing parseLinearRing(ValueGetter data, boolean haveZ, boolean haveM) {
        Point[] points = this.parsePointArray(data, haveZ, haveM);
        return new LinearRing(points);
    }

    private Polygon parsePolygon(ValueGetter data, boolean haveZ, boolean haveM) {
        int count = data.getInt();
        LinearRing[] rings = new LinearRing[count];
        for (int i = 0; i < count; ++i) {
            rings[i] = this.parseLinearRing(data, haveZ, haveM);
        }
        return new Polygon(rings);
    }

    private MultiLineString parseMultiLineString(ValueGetter data) {
        int count = data.getInt();
        Geometry[] strings = new LineString[count];
        this.parseGeometryArray(data, strings);
        return new MultiLineString((LineString[])strings);
    }

    private MultiPolygon parseMultiPolygon(ValueGetter data) {
        int count = data.getInt();
        Geometry[] polys = new Polygon[count];
        this.parseGeometryArray(data, polys);
        return new MultiPolygon((Polygon[])polys);
    }

    private GeometryCollection parseCollection(ValueGetter data) {
        int count = data.getInt();
        Geometry[] geoms = new Geometry[count];
        this.parseGeometryArray(data, geoms);
        return new GeometryCollection(geoms);
    }
}

